/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.construct;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.service.AnvilMechanics;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.PreProcessElement;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PrintableMenu
extends Menu {
    public PrintableMenu(Plugin host, String title, Menu.Rows rows, Menu.Type type, Menu.Property ... properties) {
        super(host, title, rows, type, properties);
        this.properties.add(Menu.Property.SHAREABLE);
        AnvilMechanics mechanics = (AnvilMechanics)Bukkit.getServicesManager().load(AnvilMechanics.class);
        if (mechanics != null) {
            this.addElement(new InventoryElement.Printable(title, mechanics, this));
        } else {
            LabyrinthProvider.getInstance().getLogger().severe("- No anvil mechanic service found!!");
            this.addElement(new InventoryElement.Printable(title, null, this));
        }
    }

    @Override
    public InventoryElement.Printable getInventory() {
        return (InventoryElement.Printable)this.getElement(e -> e instanceof InventoryElement);
    }

    @Override
    public void open(Player player) {
        if (this.process != null) {
            PreProcessElement element = new PreProcessElement(this, player, player.getOpenInventory());
            this.process.apply(element);
        }
        this.getInventory().open(player);
    }
}

