/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.construct;

import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.PreProcessElement;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PaginatedMenu
extends Menu {
    public PaginatedMenu(Plugin host, String title, Menu.Rows rows, Menu.Type type, Menu.Property ... properties) {
        super(host, title, rows, type, properties);
        if (this.getProperties().contains((Object)Menu.Property.SHAREABLE)) {
            if (!this.getProperties().contains((Object)Menu.Property.ANIMATED)) {
                this.addElement(new InventoryElement.SharedPaginated(title, this));
            } else {
                this.addElement(new InventoryElement.Paginated(title, this));
            }
        } else {
            this.addElement(new InventoryElement.Paginated(title, this));
        }
        this.properties.add(Menu.Property.REFILLABLE);
        TaskScheduler.of(() -> {
            if (this.getProperties().contains((Object)Menu.Property.SAVABLE)) {
                this.retrieve();
            }
        }).scheduleLater(3L);
    }

    @Override
    public InventoryElement.Paginated getInventory() {
        return (InventoryElement.Paginated)this.getElement(e -> e instanceof InventoryElement);
    }

    @Override
    public void open(Player player) {
        if (this.process != null) {
            PreProcessElement element = new PreProcessElement(this, player, player.getOpenInventory());
            this.process.apply(element);
        }
        this.getInventory().open(player);
    }
}

