/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.construct;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.Service;
import com.github.sanctum.labyrinth.data.ServiceManager;
import com.github.sanctum.labyrinth.data.ServiceType;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.construct.MenuDuplicationException;
import com.github.sanctum.labyrinth.gui.unity.construct.MenuNotCacheableException;
import com.github.sanctum.panther.container.ImmutablePantherCollection;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.util.Check;
import com.github.sanctum.panther.util.Deployable;
import java.util.function.Supplier;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public interface MenuRegistration
extends Service {
    public <M extends Menu> Deployable<Void> register(M var1) throws MenuNotCacheableException, MenuDuplicationException;

    public Deployable<Void> unregister(Menu var1) throws MenuNotCacheableException;

    @NotNull
    public Deployable<PantherCollection<Menu>> get(@NotNull Plugin var1);

    @NotNull
    public Deployable<PantherCollection<Menu>> getAll();

    @NotNull
    public Deployable<Menu> get(@NotNull String var1);

    public static MenuRegistration getInstance() {
        ServiceManager services = LabyrinthProvider.getInstance().getServiceManager();
        MenuRegistration cache = services.get(MenuRegistration.class);
        if (cache != null) {
            return cache;
        }
        ServiceType<MenuRegistration> type = new ServiceType<MenuRegistration>(() -> new MenuRegistration(){
            private final PantherMap<Plugin, PantherCollection<Menu>> cache = new PantherEntryMap<Plugin, PantherCollection<Menu>>();

            @Override
            public <M extends Menu> Deployable<Void> register(M menu) throws MenuDuplicationException, MenuNotCacheableException {
                return Deployable.of(() -> {
                    PantherCollection<Menu> menus = this.cache.get(menu.getHost());
                    if (menus != null) {
                        if (menus.contains(menu)) {
                            throw new MenuDuplicationException("Menu's can only be registered one time!");
                        }
                        if (!menu.getProperties().contains((Object)Menu.Property.CACHEABLE)) {
                            throw new MenuNotCacheableException("Menu doesn't contain required property '" + (Object)((Object)Menu.Property.CACHEABLE) + "'.");
                        }
                        menus.add(menu);
                    } else {
                        PantherList n = new PantherList();
                        n.add(menu);
                        this.cache.put(menu.getHost(), n);
                    }
                }, 0);
            }

            @Override
            public Deployable<Void> unregister(Menu menu) throws MenuNotCacheableException {
                return Deployable.of(() -> {
                    PantherCollection<Menu> menus = this.cache.get(menu.getHost());
                    if (menus != null) {
                        if (!menus.contains(menu)) {
                            throw new MenuNotCacheableException("Menu not cached.");
                        }
                    } else {
                        throw new MenuNotCacheableException("No menu's cached for plugin " + menu.getHost());
                    }
                    menus.remove(menu);
                }, 0);
            }

            @Override
            @NotNull
            public Deployable<PantherCollection<Menu>> get(@NotNull Plugin host) {
                if (host == null) {
                    1.$$$reportNull$$$0(0);
                }
                Deployable<PantherCollection<Menu>> deployable = Deployable.of(new PantherList(), list -> list.addAll(Check.forNull(this.cache.get(host), "No registrations logged for provided plugin.")), 0);
                if (deployable == null) {
                    1.$$$reportNull$$$0(1);
                }
                return deployable;
            }

            @Override
            @NotNull
            public Deployable<PantherCollection<Menu>> getAll() {
                Deployable<PantherCollection<Menu>> deployable = Deployable.of((PantherCollection)this.cache.values().stream().reduce((menus, menus2) -> {
                    ImmutablePantherCollection.Builder<Menu> b = ImmutablePantherCollection.builder();
                    for (Menu o : menus) {
                        b.add(o);
                    }
                    for (Menu t : menus2) {
                        b.add(t);
                    }
                    return b.build();
                }).orElse(new PantherList()), unused -> {}, 0);
                if (deployable == null) {
                    1.$$$reportNull$$$0(2);
                }
                return deployable;
            }

            @Override
            @NotNull
            public Deployable<Menu> get(@NotNull String key) {
                if (key == null) {
                    1.$$$reportNull$$$0(3);
                }
                Supplier<Menu> getter = () -> {
                    for (PantherCollection pantherCollection : this.cache.values()) {
                        for (Menu m : pantherCollection) {
                            if (!m.getKey().map(key::equals).orElse(false).booleanValue()) continue;
                            return m;
                        }
                    }
                    return null;
                };
                Deployable<Menu> deployable = Deployable.of(getter, 0);
                if (deployable == null) {
                    1.$$$reportNull$$$0(4);
                }
                return deployable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "host";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/github/sanctum/labyrinth/gui/unity/construct/MenuRegistration$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/github/sanctum/labyrinth/gui/unity/construct/MenuRegistration$1";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "get";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAll";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "get";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        services.load(type);
        return type.getLoader().get();
    }
}

