/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.construct;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.container.PersistentContainer;
import com.github.sanctum.labyrinth.event.LabyrinthVentCall;
import com.github.sanctum.labyrinth.formatting.UniformedComponents;
import com.github.sanctum.labyrinth.gui.unity.construct.MenuRegistration;
import com.github.sanctum.labyrinth.gui.unity.construct.PaginatedMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.PrintableMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.SingularMenu;
import com.github.sanctum.labyrinth.gui.unity.event.MenuClickEvent;
import com.github.sanctum.labyrinth.gui.unity.event.MenuDragItemEvent;
import com.github.sanctum.labyrinth.gui.unity.impl.ClickElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ClosingElement;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.ItemElement;
import com.github.sanctum.labyrinth.gui.unity.impl.OpeningElement;
import com.github.sanctum.labyrinth.gui.unity.impl.PreProcessElement;
import com.github.sanctum.labyrinth.library.Items;
import com.github.sanctum.labyrinth.library.NamespacedKey;
import com.github.sanctum.labyrinth.task.RenderedTask;
import com.github.sanctum.labyrinth.task.TaskMonitor;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.util.Task;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Menu {
    protected static Controller controller;
    protected AnvilController anvil;
    protected final Set<Element<?, ?>> elements;
    protected final Rows rows;
    protected final Type type;
    protected final Plugin host;
    protected final String title;
    protected final Set<Property> properties;
    protected String key;
    private boolean retrieved;
    protected Open open;
    protected Click click;
    protected Close close;
    protected Process process;

    protected Menu(Plugin host, String title, Rows rows, Type type, Property ... properties) {
        this.rows = rows;
        this.host = host;
        this.title = title;
        this.type = type;
        this.elements = new HashSet();
        this.properties = new HashSet<Property>(Arrays.asList(properties));
        if (this.properties.contains((Object)Property.CACHEABLE)) {
            MenuRegistration.getInstance().register(this).deploy();
        }
    }

    public abstract InventoryElement getInventory();

    public abstract void open(Player var1);

    public void close(Player player) {
        this.getInventory().close(player);
    }

    public Listener getController() {
        return this.anvil;
    }

    public final Optional<String> getKey() {
        return Optional.ofNullable(this.key);
    }

    public boolean isRetrieved() {
        return this.retrieved;
    }

    public final Type getType() {
        return this.type;
    }

    public final Rows getSize() {
        return this.rows;
    }

    public final Set<Property> getProperties() {
        return this.properties;
    }

    public final Optional<Close> getCloseEvent() {
        return Optional.ofNullable(this.close);
    }

    @NotNull
    public final Plugin getHost() {
        Plugin plugin = this.host;
        if (plugin == null) {
            Menu.$$$reportNull$$$0(0);
        }
        return plugin;
    }

    protected final void registerController() throws InstantiationException {
        if (controller == null) {
            controller = new Controller();
            Bukkit.getPluginManager().registerEvents((Listener)controller, LabyrinthProvider.getInstance().getPluginInstance());
        }
        if (this.anvil == null && this instanceof PrintableMenu) {
            if (this.host == null) {
                throw new InstantiationException("Menu host cannot be null!");
            }
            this.anvil = new AnvilController();
            Bukkit.getPluginManager().registerEvents((Listener)this.anvil, this.host);
        }
    }

    public final synchronized void retrieve() {
        if (!this.retrieved) {
            this.retrieved = true;
            PersistentContainer container = LabyrinthProvider.getInstance().getContainer(new NamespacedKey(this.host, "labyrinth-gui-" + this.key));
            if (this.getInventory().isPaginated()) {
                Map map = container.get(Map.class, this.getInventory().getTitle());
                if (map != null) {
                    if (!this.getProperties().contains((Object)Property.SAVABLE)) {
                        container.delete(this.getInventory().getTitle());
                        return;
                    }
                    InventoryElement inv = this.getInventory();
                    for (Map.Entry entry : map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).collect(Collectors.toList())) {
                        for (ItemStack i : (ItemStack[])((UniformedComponents)entry.getValue()).array()) {
                            if (i == null || i.getType() == Material.AIR) continue;
                            inv.addItem(new ItemElement<PersistentContainer>(container).setParent(this.getInventory()).setElement(i));
                        }
                    }
                }
                return;
            }
            ItemStack[] array = container.get(ItemStack[].class, this.getInventory().getTitle());
            if (array != null) {
                if (!this.getProperties().contains((Object)Property.SAVABLE)) {
                    container.delete(this.getInventory().getTitle());
                    return;
                }
                for (ItemStack i : array) {
                    if (i == null || i.getType() == Material.AIR) continue;
                    this.getInventory().addItem(new ItemElement<PersistentContainer>(container).setParent(this.getInventory()).setElement(i));
                }
            }
        }
    }

    public final synchronized void save() {
        if (!this.getProperties().contains((Object)Property.SAVABLE)) {
            return;
        }
        PersistentContainer container = LabyrinthProvider.getInstance().getContainer(new NamespacedKey(this.host, "labyrinth-gui-" + this.key));
        if (this.getInventory().isPaginated()) {
            InventoryElement.Paginated inv = (InventoryElement.Paginated)this.getInventory();
            HashMap s = new HashMap();
            for (InventoryElement.Page entry : inv.getAllPages()) {
                s.put(entry.toNumber(), UniformedComponents.accept(entry.getAttachment().stream().map(ItemElement::getElement).collect(Collectors.toList())));
            }
            container.attach(this.getInventory().getTitle(), s);
        } else {
            container.attach(this.getInventory().getTitle(), this.getInventory().getElement().getContents());
        }
    }

    public final <T, R> T addElement(Element<T, R> element) {
        this.elements.add(element);
        return element.getElement();
    }

    public final <R> R getElement(Predicate<Element<?, ?>> function) {
        for (Element<?, ?> e : this.elements) {
            if (!function.test(e)) continue;
            return (R)e;
        }
        return null;
    }

    public final <T extends Menu> T addAction(Click click) {
        this.click = click;
        return (T)this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/gui/unity/construct/Menu", "getHost"));
    }

    public static enum Rows {
        ONE(9),
        TWO(18),
        THREE(27),
        FOUR(36),
        FIVE(45),
        SIX(54);

        private final int slots;

        private Rows(int slots) {
            this.slots = slots;
        }

        public int getSize() {
            return this.slots;
        }

        public int[] getSlots(Panel layout) {
            return layout.get(this.getSize());
        }
    }

    public static enum Type {
        MODDED,
        PAGINATED,
        PRINTABLE,
        SINGULAR;

    }

    public static enum Property {
        ANIMATED,
        CACHEABLE,
        LIVE_META,
        SAVABLE,
        REFILLABLE,
        RECURSIVE,
        SHAREABLE;

    }

    class AnvilController
    implements Listener {
        AnvilController() {
        }

        private void unRegisterHandlers() {
            HandlerList.unregisterAll((Listener)Menu.this.getController());
            InventoryCloseEvent.getHandlerList().unregister(Menu.this.getController());
            InventoryOpenEvent.getHandlerList().unregister(Menu.this.getController());
            InventoryDragEvent.getHandlerList().unregister(Menu.this.getController());
            InventoryClickEvent.getHandlerList().unregister(Menu.this.getController());
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onClose(InventoryCloseEvent e) {
            if (!(e.getPlayer() instanceof Player)) {
                return;
            }
            if (Menu.this.getType() != Type.PRINTABLE && e.getView().getTopInventory().getSize() < Menu.this.rows.slots) {
                return;
            }
            Inventory target = Menu.this.getInventory().getElement();
            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                target = Menu.this.getInventory().getViewer((Player)e.getPlayer()).getElement();
            }
            if (e.getInventory().equals(target)) {
                if (LabyrinthProvider.getInstance().isModded()) {
                    TaskScheduler.of(() -> Arrays.stream(e.getPlayer().getInventory().getContents()).filter(i -> i != null && i.getType() != Material.AIR).forEach(i -> {
                        if (i.hasItemMeta() && !i.getItemMeta().hasDisplayName() && i.getType() == (Items.findMaterial("playerhead") == null ? Items.findMaterial("skullitem") : Items.findMaterial("playerhead"))) {
                            i.setAmount(0);
                            i.setType(Material.AIR);
                        }
                    })).scheduleLater(1L);
                }
                Player p = (Player)e.getPlayer();
                if (Menu.this.getProperties().contains((Object)Property.LIVE_META) || Menu.this.getProperties().contains((Object)Property.ANIMATED)) {
                    Task t;
                    RenderedTask task = Menu.this.getInventory().getViewer(p).getTask();
                    if (task != null) {
                        task.getTask().cancel();
                    }
                    if ((t = TaskMonitor.getLocalInstance().get("Labyrinth:" + Menu.this.hashCode() + ";slide-" + p.getUniqueId())) != null) {
                        t.cancel();
                    }
                }
                if (Menu.this.close != null) {
                    ClosingElement element = new ClosingElement(Menu.this, (Player)e.getPlayer(), e.getView());
                    Menu.this.close.apply(element);
                    if (element.isCancelled()) {
                        Menu.this.getInventory().open(p);
                    }
                }
                Inventory finalTarget = target;
                if (!Menu.this.getProperties().contains((Object)Property.CACHEABLE)) {
                    TaskScheduler.of(() -> {
                        if (finalTarget.getViewers().stream().noneMatch(v -> v instanceof Player)) {
                            this.unRegisterHandlers();
                        }
                    }).scheduleLater(2L);
                }
            }
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onOpen(InventoryOpenEvent e) {
            if (!(e.getPlayer() instanceof Player)) {
                return;
            }
            if (Menu.this.getType() != Type.PRINTABLE && e.getView().getTopInventory().getSize() < Menu.this.rows.slots) {
                return;
            }
            Inventory target = Menu.this.getInventory().getElement();
            if (e.getInventory().equals(target)) {
                Player p = (Player)e.getPlayer();
                if (Menu.this.open != null) {
                    OpeningElement element = new OpeningElement(Menu.this, (Player)e.getPlayer(), e.getView());
                    Menu.this.open.apply(element);
                    if (element.isCancelled()) {
                        element.getElement().closeInventory();
                    }
                }
            }
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onDrag(InventoryDragEvent e) {
            MenuDragItemEvent event;
            if (!(e.getWhoClicked() instanceof Player)) {
                return;
            }
            if (Menu.this.getType() != Type.PRINTABLE && e.getView().getTopInventory().getSize() < Menu.this.rows.slots) {
                return;
            }
            Inventory target = Menu.this.getInventory().getElement();
            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                target = Menu.this.getInventory().getViewer((Player)e.getWhoClicked()).getElement();
            }
            if (!e.getInventory().equals(target)) {
                return;
            }
            if (e.getInventory().equals(target)) {
                e.setResult(Event.Result.DENY);
            }
            ItemStack attempt = e.getCursor() != null ? e.getCursor() : e.getOldCursor();
            ItemElement<Object> element = Menu.this.getInventory().getItem(attempt);
            if (element == null) {
                element = new ItemElement().setPlayerAdded(true).setParent(Menu.this.getInventory()).setElement(attempt);
            }
            if ((event = (MenuDragItemEvent)new LabyrinthVentCall<MenuDragItemEvent>(new MenuDragItemEvent(Menu.this, (Player)e.getWhoClicked(), element)).run()).isCancelled()) {
                e.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onClick(InventoryClickEvent e) {
            if (!(e.getWhoClicked() instanceof Player)) {
                return;
            }
            if (Menu.this.getType() != Type.PRINTABLE && e.getView().getTopInventory().getSize() < Menu.this.rows.slots) {
                return;
            }
            Inventory target = Menu.this.getInventory().getElement();
            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                target = Menu.this.getInventory().getViewer((Player)e.getWhoClicked()).getElement();
            }
            if (!e.getInventory().equals(target)) {
                return;
            }
            if (e.getClickedInventory() == e.getInventory()) {
                Player p = (Player)e.getWhoClicked();
                if (e.getCurrentItem() != null) {
                    ItemStack item = e.getCurrentItem();
                    ItemElement<?> fixedSlotElement = Menu.this.getInventory().getItem(i -> i.getSlot().isPresent() && e.getRawSlot() == i.getSlot().get().intValue() && item.getType() == i.getElement().getType() && i.getType() != ItemElement.ControlType.ITEM_FILLER && i.getType() != ItemElement.ControlType.ITEM_BORDER);
                    if (fixedSlotElement != null) {
                        MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, Menu.this, fixedSlotElement)).run();
                        if (event.isCancelled()) {
                            e.setCancelled(true);
                            return;
                        }
                        Click click = fixedSlotElement.getAttachment();
                        ClickElement clickElement = new ClickElement(p, e.getRawSlot(), e.getAction(), e.getClick(), fixedSlotElement, e.getCursor(), e.getView());
                        if (click != null) {
                            click.apply(clickElement);
                        }
                        if (clickElement.getResult() != null) {
                            e.setResult(clickElement.getResult());
                        }
                        if (e.getHotbarButton() != -1 && !clickElement.isHotbarAllowed()) {
                            e.setCancelled(true);
                        }
                        if (fixedSlotElement.getType() != null) {
                            ClickElement.Consumer consumer = clickElement.getConsumer();
                            switch (fixedSlotElement.getType()) {
                                case TAKEAWAY: {
                                    fixedSlotElement.remove(false);
                                    break;
                                }
                                case BUTTON_EXIT: {
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                case BUTTON_NEXT: {
                                    if (Menu.this instanceof PaginatedMenu) {
                                        PaginatedMenu m = (PaginatedMenu)Menu.this;
                                        if (Menu.this.getProperties().contains((Object)Property.SAVABLE)) {
                                            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                            } else {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                            if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (m.getInventory().getGlobalSlot().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                case BUTTON_BACK: {
                                    if (Menu.this instanceof PaginatedMenu) {
                                        PaginatedMenu m = (PaginatedMenu)Menu.this;
                                        if (Menu.this.getProperties().contains((Object)Property.SAVABLE)) {
                                            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (m.getInventory().getGlobalSlot().toNumber() - 1 >= 1) {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                            if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (m.getInventory().getGlobalSlot().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getGlobalSlot().toNumber() - 1 >= 1) {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                }
                            }
                        }
                        if (clickElement.isCancelled()) {
                            e.setCancelled(true);
                        }
                    } else {
                        ItemElement<?> otherElement;
                        ItemElement<?> hotKeyElement = Menu.this.getInventory().getItem(e.getRawSlot());
                        if (hotKeyElement != null) {
                            MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, Menu.this, hotKeyElement)).run();
                            if (event.isCancelled()) {
                                e.setCancelled(true);
                                return;
                            }
                            Click click = hotKeyElement.getAttachment();
                            ClickElement clickElement = new ClickElement(p, e.getRawSlot(), e.getAction(), e.getClick(), hotKeyElement, e.getCursor(), e.getView());
                            if (click != null) {
                                click.apply(clickElement);
                            }
                            if (clickElement.getResult() != null) {
                                e.setResult(clickElement.getResult());
                            }
                            if (e.getHotbarButton() != -1 && !clickElement.isHotbarAllowed()) {
                                e.setCancelled(true);
                            }
                            if (hotKeyElement.getType() != null) {
                                ClickElement.Consumer consumer = clickElement.getConsumer();
                                switch (hotKeyElement.getType()) {
                                    case TAKEAWAY: {
                                        hotKeyElement.remove(false);
                                        break;
                                    }
                                    case BUTTON_EXIT: {
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    case BUTTON_NEXT: {
                                        PaginatedMenu m;
                                        if (Menu.this instanceof PaginatedMenu) {
                                            m = (PaginatedMenu)Menu.this;
                                            if (Menu.this.getProperties().contains((Object)Property.SAVABLE)) {
                                                if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                                } else {
                                                    m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (m.getInventory().getGlobalSlot().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    case BUTTON_BACK: {
                                        PaginatedMenu m;
                                        if (Menu.this instanceof PaginatedMenu) {
                                            m = (PaginatedMenu)Menu.this;
                                            if (Menu.this.getProperties().contains((Object)Property.SAVABLE)) {
                                                if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                    if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                        m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                        if (consumer == null) break;
                                                        consumer.accept(clickElement.getElement(), true);
                                                        break;
                                                    }
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), false);
                                                    break;
                                                }
                                                if (m.getInventory().getGlobalSlot().toNumber() - 1 >= 1) {
                                                    m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (m.getInventory().getGlobalSlot().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getGlobalSlot().toNumber() - 1 >= 1) {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                    }
                                }
                            }
                            if (clickElement.isCancelled()) {
                                e.setCancelled(true);
                            }
                        }
                        if ((otherElement = Menu.this.getInventory().getItem(item)) != null) {
                            MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, Menu.this, otherElement)).run();
                            if (event.isCancelled()) {
                                e.setCancelled(true);
                                return;
                            }
                            Click click = otherElement.getAttachment();
                            ClickElement clickElement = new ClickElement(p, e.getRawSlot(), e.getAction(), e.getClick(), otherElement, e.getCursor(), e.getView());
                            if (click == null) {
                                if (Menu.this.click != null) {
                                    Menu.this.click.apply(clickElement);
                                }
                            } else {
                                click.apply(clickElement);
                            }
                            if (clickElement.getResult() != null) {
                                e.setResult(clickElement.getResult());
                            }
                            if (e.getHotbarButton() != -1 && !clickElement.isHotbarAllowed()) {
                                e.setCancelled(true);
                            }
                            if (otherElement.getType() != null) {
                                ClickElement.Consumer consumer = clickElement.getConsumer();
                                switch (otherElement.getType()) {
                                    case TAKEAWAY: {
                                        otherElement.remove(false);
                                        break;
                                    }
                                    case BUTTON_EXIT: {
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    case BUTTON_NEXT: {
                                        if (Menu.this instanceof PaginatedMenu) {
                                            PaginatedMenu m = (PaginatedMenu)Menu.this;
                                            if (Menu.this.getProperties().contains((Object)Property.SAVABLE)) {
                                                if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                                } else {
                                                    m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (m.getInventory().getGlobalSlot().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    case BUTTON_BACK: {
                                        if (Menu.this instanceof PaginatedMenu) {
                                            PaginatedMenu m = (PaginatedMenu)Menu.this;
                                            if (Menu.this.getProperties().contains((Object)Property.SAVABLE)) {
                                                if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                    if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                        m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                        if (consumer == null) break;
                                                        consumer.accept(clickElement.getElement(), true);
                                                        break;
                                                    }
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), false);
                                                    break;
                                                }
                                                if (m.getInventory().getGlobalSlot().toNumber() - 1 >= 1) {
                                                    m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (!Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                                if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (m.getInventory().getGlobalSlot().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getGlobalSlot().toNumber() - 1 >= 1) {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                    }
                                }
                            }
                            if (clickElement.isCancelled()) {
                                e.setCancelled(true);
                            }
                            return;
                        }
                        if (!e.isCancelled()) {
                            ItemElement element1 = new ItemElement().setPlayerAdded(true).setParent(Menu.this.getInventory()).setElement(e.getCurrentItem());
                            MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, Menu.this, element1)).run();
                            if (event.isCancelled()) {
                                e.setCancelled(true);
                                return;
                            }
                            if (Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                                if (Menu.this.getInventory().isPaginated()) {
                                    InventoryElement.Paginated inv = (InventoryElement.Paginated)Menu.this.getInventory();
                                    element1.setPage(inv.getGlobalSlot());
                                }
                            } else {
                                element1.setPage(Menu.this.getInventory().getViewer((Player)e.getWhoClicked()).getPage());
                            }
                            if (Menu.this.click != null) {
                                ClickElement element3 = new ClickElement((Player)e.getWhoClicked(), e.getRawSlot(), e.getAction(), e.getClick(), element1, e.getCursor(), e.getView());
                                Menu.this.click.apply(element3);
                                if (element3.getResult() != null) {
                                    e.setResult(element3.getResult());
                                }
                                if (e.getHotbarButton() != -1 && !element3.isHotbarAllowed()) {
                                    e.setCancelled(true);
                                }
                                if (element3.isCancelled()) {
                                    e.setCancelled(true);
                                }
                            }
                        }
                    }
                }
                if (!e.isCancelled()) {
                    ItemElement el = new ItemElement().setPlayerAdded(true).setParent(Menu.this.getInventory()).setElement(e.getCursor());
                    MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, Menu.this, el)).run();
                    if (event.isCancelled()) {
                        e.setCancelled(true);
                        return;
                    }
                    if (Menu.this.getProperties().contains((Object)Property.SHAREABLE)) {
                        if (Menu.this.getInventory().isPaginated()) {
                            InventoryElement.Paginated inv = (InventoryElement.Paginated)Menu.this.getInventory();
                            el.setPage(inv.getGlobalSlot());
                        }
                    } else {
                        el.setPage(Menu.this.getInventory().getViewer((Player)e.getWhoClicked()).getPage());
                    }
                    if (Menu.this.click != null) {
                        ClickElement element3 = new ClickElement((Player)e.getWhoClicked(), e.getRawSlot(), e.getAction(), e.getClick(), el, e.getCursor(), e.getView());
                        Menu.this.click.apply(element3);
                        if (element3.getResult() != null) {
                            e.setResult(element3.getResult());
                        }
                        if (e.getHotbarButton() != -1 && !element3.isHotbarAllowed()) {
                            e.setCancelled(true);
                        }
                        if (element3.isCancelled()) {
                            e.setCancelled(true);
                        }
                    }
                }
            }
        }
    }

    @FunctionalInterface
    public static interface Close {
        public void apply(ClosingElement var1);
    }

    static class Controller
    implements Listener {
        Controller() {
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onClose(InventoryCloseEvent e) {
            if (!(e.getInventory().getHolder() instanceof Instance)) {
                return;
            }
            if (!(e.getPlayer() instanceof Player)) {
                return;
            }
            Menu menu = ((Instance)e.getInventory().getHolder()).getMenu();
            if (menu.getType() != Type.PRINTABLE && e.getView().getTopInventory().getSize() < menu.rows.slots) {
                return;
            }
            Player p = (Player)e.getPlayer();
            if (menu.getProperties().contains((Object)Property.LIVE_META) || menu.getProperties().contains((Object)Property.ANIMATED)) {
                Task t;
                RenderedTask task = menu.getInventory().getViewer(p).getTask();
                if (task != null) {
                    task.getTask().cancel();
                }
                if ((t = TaskMonitor.getLocalInstance().get("Labyrinth:" + menu.hashCode() + ";slide-" + p.getUniqueId())) != null) {
                    t.cancel();
                }
            }
            if (menu instanceof PrintableMenu) {
                menu.close(p);
            }
            if (menu.close != null) {
                ClosingElement element = new ClosingElement(menu, (Player)e.getPlayer(), e.getView());
                menu.close.apply(element);
                if (element.isCancelled()) {
                    menu.getInventory().open(p);
                }
            }
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onOpen(InventoryOpenEvent e) {
            if (!(e.getInventory().getHolder() instanceof Instance)) {
                return;
            }
            if (!(e.getPlayer() instanceof Player)) {
                return;
            }
            Menu menu = ((Instance)e.getInventory().getHolder()).getMenu();
            if (menu.open != null) {
                OpeningElement element = new OpeningElement(menu, (Player)e.getPlayer(), e.getView());
                menu.open.apply(element);
                if (element.isCancelled()) {
                    menu.close((Player)e.getPlayer());
                }
            }
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onDrag(InventoryDragEvent e) {
            MenuDragItemEvent event;
            if (!(e.getInventory().getHolder() instanceof Instance)) {
                return;
            }
            if (!(e.getWhoClicked() instanceof Player)) {
                return;
            }
            Menu menu = ((Instance)e.getInventory().getHolder()).getMenu();
            ItemStack attempt = e.getCursor() != null ? e.getCursor() : e.getOldCursor();
            ItemElement<Object> element = menu.getInventory().getItem(attempt);
            if (element == null) {
                element = new ItemElement().setPlayerAdded(true).setParent(menu.getInventory()).setElement(attempt);
            }
            if ((event = (MenuDragItemEvent)new LabyrinthVentCall<MenuDragItemEvent>(new MenuDragItemEvent(menu, (Player)e.getWhoClicked(), element)).run()).isCancelled()) {
                e.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onClick(InventoryClickEvent e) {
            if (!(e.getInventory().getHolder() instanceof Instance)) {
                return;
            }
            if (!(e.getWhoClicked() instanceof Player)) {
                return;
            }
            Menu menu = ((Instance)e.getInventory().getHolder()).getMenu();
            if (menu.getType() != Type.PRINTABLE && e.getView().getTopInventory().getSize() < menu.rows.slots) {
                return;
            }
            Player p = (Player)e.getWhoClicked();
            if (e.getCurrentItem() != null) {
                ItemStack item = e.getCurrentItem();
                ItemElement<?> fixedSlotElement = menu.getInventory().getItem(i -> i.getSlot().isPresent() && e.getRawSlot() == i.getSlot().get().intValue() && item.getType() == i.getElement().getType() && i.getType() != ItemElement.ControlType.ITEM_FILLER && i.getType() != ItemElement.ControlType.ITEM_BORDER);
                if (fixedSlotElement != null) {
                    MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, menu, fixedSlotElement)).run();
                    if (event.isCancelled()) {
                        e.setCancelled(true);
                        return;
                    }
                    Click click = fixedSlotElement.getAttachment();
                    ClickElement clickElement = new ClickElement(p, e.getRawSlot(), e.getAction(), e.getClick(), fixedSlotElement, e.getCursor(), e.getView());
                    if (click != null) {
                        click.apply(clickElement);
                    }
                    if (clickElement.getResult() != null) {
                        e.setResult(clickElement.getResult());
                    }
                    if (e.getHotbarButton() != -1 && !clickElement.isHotbarAllowed()) {
                        e.setCancelled(true);
                    }
                    if (fixedSlotElement.getType() != null) {
                        ClickElement.Consumer consumer = clickElement.getConsumer();
                        switch (fixedSlotElement.getType()) {
                            case TAKEAWAY: {
                                fixedSlotElement.remove(false);
                                break;
                            }
                            case BUTTON_EXIT: {
                                if (consumer == null) break;
                                consumer.accept(clickElement.getElement(), false);
                                break;
                            }
                            case BUTTON_NEXT: {
                                if (menu instanceof PaginatedMenu) {
                                    PaginatedMenu m = (PaginatedMenu)menu;
                                    if (menu.getProperties().contains((Object)Property.SAVABLE)) {
                                        if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                            m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                        } else {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), true);
                                        break;
                                    }
                                    if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                        if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                            m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (m.getInventory().getGlobalSlot().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                        m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), true);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                if (consumer == null) break;
                                consumer.accept(clickElement.getElement(), false);
                                break;
                            }
                            case BUTTON_BACK: {
                                if (menu instanceof PaginatedMenu) {
                                    PaginatedMenu m = (PaginatedMenu)menu;
                                    if (menu.getProperties().contains((Object)Property.SAVABLE)) {
                                        if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                            if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 0) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (m.getInventory().getGlobalSlot().toNumber() - 1 >= 0) {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                        if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                            m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (m.getInventory().getGlobalSlot().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getGlobalSlot().toNumber() - 1 >= 0) {
                                        m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), true);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                if (consumer == null) break;
                                consumer.accept(clickElement.getElement(), false);
                            }
                        }
                    }
                    if (clickElement.isCancelled()) {
                        e.setCancelled(true);
                    }
                } else {
                    ItemElement<?> otherElement;
                    ItemElement<?> hotKeyElement = menu.getInventory().getItem(e.getRawSlot());
                    if (hotKeyElement != null) {
                        MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, menu, hotKeyElement)).run();
                        if (event.isCancelled()) {
                            e.setCancelled(true);
                            return;
                        }
                        Click click = hotKeyElement.getAttachment();
                        ClickElement clickElement = new ClickElement(p, e.getRawSlot(), e.getAction(), e.getClick(), hotKeyElement, e.getCursor(), e.getView());
                        if (click != null) {
                            click.apply(clickElement);
                        }
                        if (clickElement.getResult() != null) {
                            e.setResult(clickElement.getResult());
                        }
                        if (e.getHotbarButton() != -1 && !clickElement.isHotbarAllowed()) {
                            e.setCancelled(true);
                        }
                        if (hotKeyElement.getType() != null) {
                            ClickElement.Consumer consumer = clickElement.getConsumer();
                            switch (hotKeyElement.getType()) {
                                case TAKEAWAY: {
                                    hotKeyElement.remove(false);
                                    break;
                                }
                                case BUTTON_EXIT: {
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                case BUTTON_NEXT: {
                                    PaginatedMenu m;
                                    if (menu instanceof PaginatedMenu) {
                                        m = (PaginatedMenu)menu;
                                        if (menu.getProperties().contains((Object)Property.SAVABLE)) {
                                            if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                            } else {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                            if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (m.getInventory().getGlobalSlot().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                case BUTTON_BACK: {
                                    PaginatedMenu m;
                                    if (menu instanceof PaginatedMenu) {
                                        m = (PaginatedMenu)menu;
                                        if (menu.getProperties().contains((Object)Property.SAVABLE)) {
                                            if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                                if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 0) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (m.getInventory().getGlobalSlot().toNumber() - 1 >= 0) {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                            if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (m.getInventory().getGlobalSlot().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getGlobalSlot().toNumber() - 1 >= 0) {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                }
                            }
                        }
                        if (clickElement.isCancelled()) {
                            e.setCancelled(true);
                        }
                    }
                    if ((otherElement = menu.getInventory().getItem(item)) != null) {
                        MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, menu, otherElement)).run();
                        if (event.isCancelled()) {
                            e.setCancelled(true);
                            return;
                        }
                        Click click = otherElement.getAttachment();
                        ClickElement clickElement = new ClickElement(p, e.getRawSlot(), e.getAction(), e.getClick(), otherElement, e.getCursor(), e.getView());
                        if (click == null) {
                            if (menu.click != null) {
                                menu.click.apply(clickElement);
                            }
                        } else {
                            click.apply(clickElement);
                        }
                        if (clickElement.getResult() != null) {
                            e.setResult(clickElement.getResult());
                        }
                        if (e.getHotbarButton() != -1 && !clickElement.isHotbarAllowed()) {
                            e.setCancelled(true);
                        }
                        if (otherElement.getType() != null) {
                            ClickElement.Consumer consumer = clickElement.getConsumer();
                            switch (otherElement.getType()) {
                                case TAKEAWAY: {
                                    otherElement.remove(false);
                                    break;
                                }
                                case BUTTON_EXIT: {
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                case BUTTON_NEXT: {
                                    if (menu instanceof PaginatedMenu) {
                                        PaginatedMenu m = (PaginatedMenu)menu;
                                        if (menu.getProperties().contains((Object)Property.SAVABLE)) {
                                            if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                            } else {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                            if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() + 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (m.getInventory().getGlobalSlot().toNumber() + 1 <= m.getInventory().getTotalPages()) {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() + 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                    break;
                                }
                                case BUTTON_BACK: {
                                    if (menu instanceof PaginatedMenu) {
                                        PaginatedMenu m = (PaginatedMenu)menu;
                                        if (menu.getProperties().contains((Object)Property.SAVABLE)) {
                                            if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                                if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 0) {
                                                    m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                    if (consumer == null) break;
                                                    consumer.accept(clickElement.getElement(), true);
                                                    break;
                                                }
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), false);
                                                break;
                                            }
                                            if (m.getInventory().getGlobalSlot().toNumber() - 1 >= 0) {
                                                m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (!menu.getProperties().contains((Object)Property.SHAREABLE)) {
                                            if (m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1 >= 1) {
                                                m.getInventory().getViewer(clickElement.getElement()).setPage(m.getInventory().getViewer(clickElement.getElement()).getPage().toNumber() - 1);
                                                if (consumer == null) break;
                                                consumer.accept(clickElement.getElement(), true);
                                                break;
                                            }
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), false);
                                            break;
                                        }
                                        if (m.getInventory().getGlobalSlot().toNumber() - 1 < m.getInventory().getTotalPages() && m.getInventory().getGlobalSlot().toNumber() - 1 >= 0) {
                                            m.getInventory().setGlobalSlot(m.getInventory().getGlobalSlot().toNumber() - 1);
                                            if (consumer == null) break;
                                            consumer.accept(clickElement.getElement(), true);
                                            break;
                                        }
                                        if (consumer == null) break;
                                        consumer.accept(clickElement.getElement(), false);
                                        break;
                                    }
                                    if (consumer == null) break;
                                    consumer.accept(clickElement.getElement(), false);
                                }
                            }
                        }
                        if (clickElement.isCancelled()) {
                            e.setCancelled(true);
                        }
                        return;
                    }
                    if (!e.isCancelled()) {
                        ItemElement element1 = new ItemElement().setPlayerAdded(true).setParent(menu.getInventory()).setElement(e.getCurrentItem());
                        MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, menu, element1)).run();
                        if (event.isCancelled()) {
                            e.setCancelled(true);
                            return;
                        }
                        if (menu.getProperties().contains((Object)Property.SHAREABLE)) {
                            if (menu.getInventory().isPaginated()) {
                                InventoryElement.Paginated inv = (InventoryElement.Paginated)menu.getInventory();
                                element1.setPage(inv.getGlobalSlot());
                            }
                        } else {
                            element1.setPage(menu.getInventory().getViewer((Player)e.getWhoClicked()).getPage());
                        }
                        if (menu.click != null) {
                            ClickElement element3 = new ClickElement((Player)e.getWhoClicked(), e.getRawSlot(), e.getAction(), e.getClick(), element1, e.getCursor(), e.getView());
                            menu.click.apply(element3);
                            if (element3.getResult() != null) {
                                e.setResult(element3.getResult());
                            }
                            if (e.getHotbarButton() != -1 && !element3.isHotbarAllowed()) {
                                e.setCancelled(true);
                            }
                            if (element3.isCancelled()) {
                                e.setCancelled(true);
                            }
                        }
                    }
                }
            }
            if (!e.isCancelled()) {
                ItemElement el = new ItemElement().setPlayerAdded(true).setParent(menu.getInventory()).setElement(e.getCursor());
                MenuClickEvent event = (MenuClickEvent)new LabyrinthVentCall<MenuClickEvent>(new MenuClickEvent(p, menu, el)).run();
                if (event.isCancelled()) {
                    e.setCancelled(true);
                    return;
                }
                if (menu.getProperties().contains((Object)Property.SHAREABLE)) {
                    if (menu.getInventory().isPaginated()) {
                        InventoryElement.Paginated inv = (InventoryElement.Paginated)menu.getInventory();
                        el.setPage(inv.getGlobalSlot());
                    }
                } else {
                    el.setPage(menu.getInventory().getViewer((Player)e.getWhoClicked()).getPage());
                }
                if (menu.click != null) {
                    ClickElement element3 = new ClickElement((Player)e.getWhoClicked(), e.getRawSlot(), e.getAction(), e.getClick(), el, e.getCursor(), e.getView());
                    menu.click.apply(element3);
                    if (element3.getResult() != null) {
                        e.setResult(element3.getResult());
                    }
                    if (e.getHotbarButton() != -1 && !element3.isHotbarAllowed()) {
                        e.setCancelled(true);
                    }
                    if (element3.isCancelled()) {
                        e.setCancelled(true);
                    }
                }
            }
        }
    }

    public static abstract class Element<T, V> {
        private final Set<Element<?, ?>> elements = new HashSet();

        public abstract T getElement();

        public abstract V getAttachment();

        public final <X, Y> X addElement(Element<X, Y> element) {
            this.elements.add(element);
            return element.getElement();
        }

        @Nullable
        public final Element<?, ?> getElement(Predicate<Element<?, ?>> predicate) {
            for (Element<?, ?> e : this.elements) {
                if (!predicate.test(e)) continue;
                return e;
            }
            return null;
        }

        @NotNull
        public final Set<Element<?, ?>> getElements() {
            Set<Element<?, ?>> set = this.elements;
            if (set == null) {
                Element.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/gui/unity/construct/Menu$Element", "getElements"));
        }
    }

    @FunctionalInterface
    public static interface Click {
        public void apply(ClickElement var1);
    }

    @FunctionalInterface
    public static interface Instance
    extends InventoryHolder {
        @NotNull
        public Menu getMenu();

        @NotNull
        default public Inventory getInventory() {
            Inventory inventory = this.getMenu().getInventory().getElement();
            if (inventory == null) {
                Instance.$$$reportNull$$$0(0);
            }
            return inventory;
        }

        @NotNull
        public static Instance of(@NotNull Menu menu) {
            if (menu == null) {
                Instance.$$$reportNull$$$0(1);
            }
            Instance instance = () -> menu;
            if (instance == null) {
                Instance.$$$reportNull$$$0(2);
            }
            return instance;
        }

        @NotNull
        public static Instance of(final @NotNull Menu menu, final Player player) {
            if (menu == null) {
                Instance.$$$reportNull$$$0(3);
            }
            return new Instance(){

                @Override
                @NotNull
                public Inventory getInventory() {
                    Inventory inventory = player != null ? menu.getInventory().getViewer(player).getInventory().getElement() : menu.getInventory().getElement();
                    if (inventory == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return inventory;
                }

                @Override
                @NotNull
                public Menu getMenu() {
                    Menu menu2 = menu;
                    if (menu2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return menu2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/github/sanctum/labyrinth/gui/unity/construct/Menu$Instance$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getInventory";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getMenu";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/github/sanctum/labyrinth/gui/unity/construct/Menu$Instance";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "menu";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInventory";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/github/sanctum/labyrinth/gui/unity/construct/Menu$Instance";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Builder<T extends Menu, K extends InventoryElement> {
        private final Type type;
        private Plugin host;
        private String title;
        private Close close;
        private Consumer<K> inventoryEdit;
        private Open open;
        private Process process;
        private String key;
        protected final Set<Property> properties = new HashSet<Property>();
        private Rows size;

        public Builder(Type type) {
            this.type = type;
        }

        public Builder<T, K> setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder<T, K> setHost(@NotNull Plugin plugin) {
            if (plugin == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.host = plugin;
            return this;
        }

        public Builder<T, K> setSize(Rows rows) {
            this.size = rows;
            return this;
        }

        public Builder<T, K> setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder<T, K> setProperty(Property ... properties) {
            this.properties.addAll(Arrays.asList(properties));
            return this;
        }

        public Builder<T, K> setStock(Consumer<K> edit) {
            this.inventoryEdit = edit;
            return this;
        }

        public Builder<T, K> setCloseEvent(Close close) {
            this.close = close;
            return this;
        }

        public Builder<T, K> setOpenEvent(Open open) {
            this.open = open;
            return this;
        }

        public Builder<T, K> setProcessEvent(Process process) {
            this.process = process;
            return this;
        }

        public T orGet(Predicate<Menu> predicate) {
            Menu test = MenuRegistration.getInstance().getAll().deploy().get().stream().filter(predicate).findFirst().orElse(null);
            if (test != null) {
                return (T)test;
            }
            Menu menu = null;
            switch (this.type) {
                case PAGINATED: {
                    menu = new PaginatedMenu(this.host, this.title, this.size, Type.PAGINATED, this.properties.toArray(new Property[0]));
                    break;
                }
                case PRINTABLE: {
                    menu = new PrintableMenu(this.host, this.title, this.size, Type.PRINTABLE, this.properties.toArray(new Property[0]));
                    break;
                }
                case SINGULAR: {
                    menu = new SingularMenu(this.host, this.title, this.size, Type.SINGULAR, this.properties.toArray(new Property[0]));
                }
            }
            if (this.inventoryEdit != null) {
                this.inventoryEdit.accept(menu.getInventory());
            }
            if (this.key != null) {
                menu.key = this.key;
            }
            menu.close = this.close;
            menu.open = this.open;
            try {
                menu.registerController();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            return (T)menu;
        }

        public T join() {
            Menu menu = null;
            switch (this.type) {
                case PAGINATED: {
                    menu = new PaginatedMenu(this.host, this.title, this.size, Type.PAGINATED, this.properties.toArray(new Property[0]));
                    break;
                }
                case PRINTABLE: {
                    menu = new PrintableMenu(this.host, this.title, this.size, Type.PRINTABLE, this.properties.toArray(new Property[0]));
                    break;
                }
                case SINGULAR: {
                    menu = new SingularMenu(this.host, this.title, this.size, Type.SINGULAR, this.properties.toArray(new Property[0]));
                }
            }
            if (this.inventoryEdit != null) {
                this.inventoryEdit.accept(menu.getInventory());
            }
            if (this.key != null) {
                menu.key = this.key;
            }
            menu.close = this.close;
            menu.open = this.open;
            try {
                menu.registerController();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            return (T)menu;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/github/sanctum/labyrinth/gui/unity/construct/Menu$Builder", "setHost"));
        }
    }

    public static interface BuilderFactory<T extends Builder<V, K>, V extends Menu, K extends InventoryElement> {
        public T createBuilder();
    }

    public static enum Panel {
        TOP(i -> IntStream.range(0, 9).toArray()),
        BOTTOM(i -> IntStream.range(i - 9, i).toArray()),
        MIDDLE(i -> {
            if (i <= 18) {
                return IntStream.range(0, 9).toArray();
            }
            return IntStream.range(10, i).filter(n -> n < i - 9 && n % 9 != 0 && n % 9 != 8).toArray();
        }),
        LEFT(i -> IntStream.iterate(0, n -> n + 9).limit(i / 9).toArray()),
        RIGHT(i -> IntStream.iterate(8, n -> n + 9).limit(i / 9).toArray());

        private final Function<Integer, int[]> generatorFunction;
        private final Map<Integer, int[]> cache = new HashMap<Integer, int[]>();

        private Panel(Function<Integer, int[]> generatorFunction) {
            this.generatorFunction = generatorFunction;
        }

        public int[] get(int slots) {
            int[] result = this.cache.computeIfAbsent(slots, this.generatorFunction);
            return Arrays.copyOf(result, result.length);
        }
    }

    @FunctionalInterface
    public static interface Populate<T> {
        public void accept(T var1, ItemElement<?> var2);
    }

    @FunctionalInterface
    public static interface Process {
        public void apply(PreProcessElement var1);
    }

    @FunctionalInterface
    public static interface Open {
        public void apply(OpeningElement var1);
    }
}

