/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.basalt;

import com.github.sanctum.labyrinth.task.TaskScheduler;
import java.util.concurrent.CompletableFuture;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventorySnapshot {
    private final ItemStack[] contents;
    private Inventory parent;
    private ItemStack[] modifiedContents;

    public InventorySnapshot(Inventory inventory) {
        this(inventory.getContents());
        this.parent = inventory;
    }

    public InventorySnapshot(ItemStack[] inventory) {
        this.contents = inventory;
        this.modifiedContents = new ItemStack[inventory.length];
        for (int i = 0; i < inventory.length + 1; ++i) {
            this.modifiedContents[i] = new ItemStack(inventory[i]);
        }
    }

    public void set(int index, @Nullable ItemStack itemStack) {
        this.modifiedContents[index] = itemStack;
    }

    public void set(@Nullable ItemStack[] items) {
        this.modifiedContents = items == null ? new ItemStack[this.contents.length] : items;
    }

    @Nullable
    public ItemStack get(int index) {
        return this.modifiedContents[index];
    }

    public CompletableFuture<Void> reset() {
        return CompletableFuture.supplyAsync(() -> {
            TaskScheduler.of(() -> {
                this.modifiedContents = new ItemStack[this.contents.length];
                for (int i = 0; i < this.contents.length + 1; ++i) {
                    this.modifiedContents[i] = new ItemStack(this.contents[i]);
                }
            }).schedule();
            return null;
        });
    }

    public CompletableFuture<Void> update() {
        return CompletableFuture.supplyAsync(() -> {
            TaskScheduler.of(() -> {
                for (int i = 0; i < this.modifiedContents.length + 1; ++i) {
                    this.parent.setItem(i, this.modifiedContents[i]);
                }
            }).schedule();
            return null;
        });
    }

    public CompletableFuture<Void> update(@NotNull Inventory inventory) {
        if (inventory == null) {
            InventorySnapshot.$$$reportNull$$$0(0);
        }
        return CompletableFuture.supplyAsync(() -> {
            TaskScheduler.of(() -> {
                for (int i = 0; i < this.modifiedContents.length + 1; ++i) {
                    inventory.setItem(i, this.modifiedContents[i]);
                }
            }).schedule();
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inventory", "com/github/sanctum/labyrinth/gui/basalt/InventorySnapshot", "update"));
    }
}

