/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.basalt;

import com.github.sanctum.labyrinth.data.service.AnvilMechanics;
import com.github.sanctum.labyrinth.gui.basalt.InventoryProperties;
import com.github.sanctum.labyrinth.gui.basalt.InventorySnapshot;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryContainer {
    private final Inventory inventory;
    private final InventoryProperties properties;
    private final PantherMap<UUID, Inventory> inventoryMap = new PantherEntryMap<UUID, Inventory>();

    public InventoryContainer(Inventory inventory, InventoryProperties properties) {
        this.inventory = inventory;
        this.properties = properties;
    }

    @Nullable
    public Inventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public Inventory getInventory(@NotNull Player player) {
        if (player == null) {
            InventoryContainer.$$$reportNull$$$0(0);
        }
        return this.inventoryMap.get(player.getUniqueId());
    }

    @Nullable
    public InventorySnapshot newSnapshot() {
        if (this.inventory == null) {
            return null;
        }
        return new InventorySnapshot(this.inventory);
    }

    @Nullable
    public InventorySnapshot newSnapshot(@NotNull Player player) {
        if (player == null) {
            InventoryContainer.$$$reportNull$$$0(1);
        }
        if (this.inventory == null) {
            return null;
        }
        return new InventorySnapshot(this.inventoryMap.computeIfAbsent(player.getUniqueId(), () -> {
            switch (this.properties.getFormat()) {
                case ANVIL: {
                    AnvilMechanics mechanics = AnvilMechanics.getInstance();
                    Object container = mechanics.newContainerAnvil(player, this.properties.getTitle());
                    Inventory ne = mechanics.toBukkitInventory(container);
                    for (int i = 0; i < this.inventory.getSize() + 1; ++i) {
                        ne.setItem(i, this.inventory.getItem(i));
                    }
                    return ne;
                }
                case NORMAL: 
                case PAGINATED: {
                    Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.properties.getTitle());
                    for (int i = 0; i < this.inventory.getSize() + 1; ++i) {
                        inv.setItem(i, this.inventory.getItem(i));
                    }
                    return inv;
                }
            }
            return null;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "player";
        objectArray2[1] = "com/github/sanctum/labyrinth/gui/basalt/InventoryContainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInventory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "newSnapshot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

