/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import com.github.sanctum.labyrinth.formatting.string.GradientColor;
import com.github.sanctum.panther.annotation.Json;
import com.github.sanctum.panther.util.RandomID;
import java.awt.Color;
import java.util.Random;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.melion.rgbchat.chat.TextColor;

public class RandomHex
extends Number
implements CustomColor {
    private static final long serialVersionUID = -7282478033342958031L;
    private final int hex;
    private final String id;
    private String con;
    private final String c1;
    private final String c2;
    private final GradientColor color;

    protected RandomHex(String c1, String c2, String name) {
        this.id = name;
        this.c1 = c1;
        this.c2 = c2;
        this.color = new GradientColor(c1, c2);
        this.hex = Color.decode(c1).getRGB();
    }

    public RandomHex() {
        Random random = new Random();
        String color1 = String.format("#%06x", random.nextInt(0x1000000));
        String color2 = String.format("#%06x", random.nextInt(0x1000000));
        this.id = new RandomID(6, color1 + color2).generate();
        this.c1 = color1;
        this.c2 = color2;
        this.color = new GradientColor(color1, color2);
        this.hex = Color.decode(color1).getRGB();
    }

    public org.bukkit.Color toColor() {
        return org.bukkit.Color.fromRGB((int)this.intValue());
    }

    public String toString() {
        return this.c1;
    }

    public GradientColor toGradient() {
        return this.color;
    }

    @Override
    public int intValue() {
        return this.hex;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    @Json(key="name")
    public String name() {
        return this.id;
    }

    @Override
    public String join() {
        return "<" + this.c1 + ">" + this.con + "</" + this.c2 + ">";
    }

    @Override
    public BaseComponent[] build() {
        return TextComponent.fromLegacyText((String)this.translate());
    }

    @Override
    public String translate() {
        return new ColoredString(this.join(), ColoredString.ColorType.HEX).toString();
    }

    @Override
    public CustomColor context(String context) {
        this.con = context;
        return this;
    }

    @Override
    @Json(key="color1")
    public String getStart() {
        return this.c1;
    }

    @Override
    @Json(key="color2")
    public String getEnd() {
        return this.c2;
    }

    @Override
    public TextColor[] colors() {
        return new TextColor[]{new TextColor(this.c1), new TextColor(this.c2)};
    }
}

