/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.PlaceholderFormatService;
import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class FormattedString {
    private String context;

    public FormattedString(@NotNull String context) {
        if (context == null) {
            FormattedString.$$$reportNull$$$0(0);
        }
        this.context = context;
    }

    public FormattedString append(char c) {
        this.context = this.context + String.valueOf(c);
        return this;
    }

    public FormattedString append(@NotNull CharSequence sequence) {
        if (sequence == null) {
            FormattedString.$$$reportNull$$$0(1);
        }
        this.context = this.context + sequence.toString();
        return this;
    }

    public FormattedString append(@NotNull Number number) {
        if (number == null) {
            FormattedString.$$$reportNull$$$0(2);
        }
        if (number instanceof Double) {
            this.context = this.context + number.doubleValue();
        }
        if (number instanceof Long) {
            this.context = this.context + number.longValue();
        }
        if (number instanceof Integer) {
            this.context = this.context + number.intValue();
        }
        if (number instanceof Short) {
            this.context = this.context + number.shortValue();
        }
        if (number instanceof Float) {
            this.context = this.context + number.floatValue();
        }
        if (number instanceof Byte) {
            this.context = this.context + number.byteValue();
        }
        return this;
    }

    public FormattedString color() {
        this.context = new ColoredString(this.context).toString();
        return this;
    }

    public FormattedString translate() {
        this.context = LabyrinthProvider.getService(PlaceholderFormatService.class).replaceAll(this.context, null);
        return this;
    }

    public FormattedString translate(@NotNull Object variable) {
        if (variable == null) {
            FormattedString.$$$reportNull$$$0(3);
        }
        this.context = LabyrinthProvider.getService(PlaceholderFormatService.class).replaceAll(this.context, variable);
        return this;
    }

    public FormattedString replace(@NotNull String regex, @NotNull String replacement) {
        if (regex == null) {
            FormattedString.$$$reportNull$$$0(4);
        }
        if (replacement == null) {
            FormattedString.$$$reportNull$$$0(5);
        }
        this.context = Pattern.compile(regex, 82).matcher(this.context).replaceAll(Matcher.quoteReplacement(replacement));
        return this;
    }

    public boolean contains(CharSequence ... sequences) {
        for (CharSequence s : sequences) {
            if (!Pattern.compile(Pattern.quote(s.toString()), 2).matcher(this.context).find()) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(CharSequence ... sequences) {
        for (CharSequence s : sequences) {
            if (Pattern.compile(Pattern.quote(s.toString()), 2).matcher(this.context).find()) continue;
            return false;
        }
        return true;
    }

    public String get() {
        return this.context;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/formatting/string/FormattedString";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "translate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

