/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import com.github.sanctum.labyrinth.formatting.string.ImageBreakdown;
import com.github.sanctum.labyrinth.formatting.string.RandomHex;
import com.github.sanctum.panther.annotation.Note;
import java.awt.Color;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.melion.rgbchat.chat.TextColor;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public enum DefaultColor implements CustomColor
{
    MANGO("#269947", "#e69f12"),
    VELVET("#e62012", "#8c0b10"),
    RANDOM(new RandomHex().toString(), new RandomHex().toString()),
    GALAXY("#1f1c4d", "#991c4e");

    private final CharSequence start;
    private final CharSequence end;
    private String context;

    private DefaultColor(CharSequence start, CharSequence end) {
        this.start = start;
        this.end = end;
    }

    private static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    private static boolean areIdentical(Color c1, Color c2) {
        return Math.abs(c1.getRed() - c2.getRed()) <= 5 && Math.abs(c1.getGreen() - c2.getGreen()) <= 5 && Math.abs(c1.getBlue() - c2.getBlue()) <= 5;
    }

    @Note(value="Easily convert any color into a game only color")
    @NotNull
    public static @Note(value="Easily convert any color into a game only color") @NotNull ChatColor fromAwt(@NotNull Color color) {
        int i;
        if (color == null) {
            DefaultColor.$$$reportNull$$$0(0);
        }
        int index = 0;
        double best = -1.0;
        for (i = 0; i < ImageBreakdown.VANILLA_COLORS.length; ++i) {
            if (!DefaultColor.areIdentical(ImageBreakdown.VANILLA_COLORS[i], color)) continue;
            ChatColor chatColor = ChatColor.values()[i];
            if (chatColor == null) {
                DefaultColor.$$$reportNull$$$0(1);
            }
            return chatColor;
        }
        for (i = 0; i < ImageBreakdown.VANILLA_COLORS.length; ++i) {
            double distance = DefaultColor.getDistance(color, ImageBreakdown.VANILLA_COLORS[i]);
            if (!(distance < best) && best != -1.0) continue;
            best = distance;
            index = i;
        }
        ChatColor chatColor = ChatColor.values()[index];
        if (chatColor == null) {
            DefaultColor.$$$reportNull$$$0(2);
        }
        return chatColor;
    }

    public DefaultColor wrap(String context) {
        this.context = context;
        return this;
    }

    @Override
    public String join() {
        return "<" + this.start + ">" + this.context + "</" + this.end + ">";
    }

    public String join(String context) {
        return "<" + this.start + ">" + context + "</" + this.end + ">";
    }

    @Override
    public BaseComponent[] build() {
        return TextComponent.fromLegacyText((String)this.translate());
    }

    @Override
    public CustomColor context(String context) {
        this.context = context;
        return this;
    }

    @Override
    public TextColor[] colors() {
        return new TextColor[]{new TextColor(this.start.toString()), new TextColor(this.end.toString())};
    }

    @Override
    public String getStart() {
        return this.start.toString();
    }

    @Override
    public String getEnd() {
        return this.end.toString();
    }

    public BaseComponent[] build(String context) {
        return TextComponent.fromLegacyText((String)this.translate(context));
    }

    @Override
    public String translate() {
        return new ColoredString(this.join(), ColoredString.ColorType.HEX).toString();
    }

    public String translate(String context) {
        return new ColoredString(this.join(context), ColoredString.ColorType.HEX).toString();
    }

    public String getName() {
        return this.name();
    }

    public String toString() {
        return this.getStart();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/formatting/string/DefaultColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/formatting/string/DefaultColor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAwt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromAwt";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

