/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.pagination;

import com.github.sanctum.labyrinth.data.ReplaceableKeyedValue;
import com.github.sanctum.labyrinth.formatting.FancyMessage;
import com.github.sanctum.labyrinth.formatting.FancyMessageChain;
import com.github.sanctum.panther.util.AbstractPaginatedCollection;
import com.github.sanctum.panther.util.Page;
import com.github.sanctum.panther.util.TriadConsumer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public final class AdvancedPagination<T> {
    private final AbstractPaginatedCollection<T> collection;
    private TriadConsumer<T, Map.Entry<Integer, Integer>, FancyMessage> format;
    private BiConsumer<Player, FancyMessage> header;
    private BiConsumer<Player, FancyMessage> footer;
    private final Player player;

    public AdvancedPagination(Player target, Collection<T> collection) {
        this.collection = AbstractPaginatedCollection.of(collection);
        this.player = target;
    }

    public AdvancedPagination(Player target, Collection<T> collection, Comparator<? super T> comparator) {
        this.collection = AbstractPaginatedCollection.of(collection).sort(comparator);
        this.player = target;
    }

    public AdvancedPagination(Player target, Collection<T> collection, Comparator<? super T> comparator, Predicate<? super T> predicate) {
        this.collection = AbstractPaginatedCollection.of(collection).sort(comparator).filter(predicate);
        this.player = target;
    }

    @SafeVarargs
    public AdvancedPagination(Player target, T ... collection) {
        this.collection = AbstractPaginatedCollection.of(collection);
        this.player = target;
    }

    @SafeVarargs
    public AdvancedPagination(Player target, Comparator<? super T> comparator, T ... collection) {
        this.collection = AbstractPaginatedCollection.of(collection).sort(comparator);
        this.player = target;
    }

    @SafeVarargs
    public AdvancedPagination(Player target, Comparator<? super T> comparator, Predicate<? super T> predicate, T ... collection) {
        this.collection = AbstractPaginatedCollection.of(collection).sort(comparator).filter(predicate);
        this.player = target;
    }

    public void setHeader(BiConsumer<Player, FancyMessage> consumer) {
        this.header = consumer;
    }

    public void setFooter(BiConsumer<Player, FancyMessage> consumer) {
        this.footer = consumer;
    }

    public void setFormat(TriadConsumer<T, Map.Entry<Integer, Integer>, FancyMessage> messageConsumer) {
        this.format = messageConsumer;
    }

    public void limit(int elements) {
        this.collection.limit(elements);
    }

    public int size() {
        return this.collection.size();
    }

    private String calc(int i) {
        String val = String.valueOf(i);
        int size = String.valueOf(i).length();
        if (val.contains("-")) {
            if (size == 2) {
                val = "-0" + i;
            }
        } else if (size == 1) {
            val = "0" + i;
        }
        return val;
    }

    public void send(int page) {
        int i;
        Page<T> p = this.collection.get(page);
        int totalPages = this.collection.size();
        FancyMessageChain chain = new FancyMessageChain();
        chain.append(header -> this.header.accept(this.player, (FancyMessage)header));
        int testing = 0;
        if (page > 0) {
            for (i = page; i > 0; --i) {
                if (i == page) continue;
                testing += this.collection.get(i).size();
            }
        }
        for (i = 0; i < p.size(); ++i) {
            T t = p.get(i);
            FancyMessage message = new FancyMessage();
            this.format.accept(t, ReplaceableKeyedValue.of(page, testing + i + 1), message);
            chain.append(message);
        }
        chain.append(footer -> this.footer.accept(this.player, (FancyMessage)footer));
        chain.append(footer -> {
            FancyMessage pages = new FancyMessage();
            for (int i = page - 2; i < totalPages; ++i) {
                int finalI = i + 1;
                if (pages.length() >= 17) continue;
                if (finalI == page) {
                    if (i == totalPages - 1) {
                        pages.then("&a&l" + this.calc(finalI)).hover("&cYou're already on this page.");
                        continue;
                    }
                    pages.then("&a&l" + this.calc(finalI)).hover("&cYou're already on this page.").then("&8...");
                    continue;
                }
                if (i == totalPages - 1) {
                    if (String.valueOf(i).contains("-")) {
                        pages.then("&7" + this.calc(finalI));
                        continue;
                    }
                    pages.then("&7" + this.calc(finalI)).action(() -> this.send(finalI)).hover("&6Click to goto this page.");
                    continue;
                }
                if (String.valueOf(i).contains("-")) {
                    pages.then("&7" + this.calc(finalI)).then("&8...");
                    continue;
                }
                pages.then("&7" + this.calc(finalI)).action(() -> this.send(finalI)).hover("&6Click to goto this page.").then("&8...");
            }
            if (page == 1 || page == 0) {
                if (totalPages == 1) {
                    FancyMessage t = footer.then("\u00ab").color(ChatColor.DARK_GRAY).then(" ").append(pages);
                    t.then(" ").then("\u00bb").color(ChatColor.DARK_GRAY);
                    return;
                }
                FancyMessage t = footer.then("\u00ab").color(ChatColor.DARK_GRAY).then(" ").append(pages);
                t.then(" ").then("\u00bb").action(() -> this.send(page + 1)).color(ChatColor.DARK_AQUA);
                return;
            }
            if (page == totalPages) {
                FancyMessage t = footer.then("\u00ab").action(() -> this.send(page - 1)).color(ChatColor.DARK_AQUA).then(" ").append(pages);
                t.then(" ").then("\u00bb").color(ChatColor.DARK_GRAY);
                return;
            }
            FancyMessage t = footer.then("\u00ab").action(() -> this.send(page - 1)).color(ChatColor.DARK_AQUA).then(" ").append(pages);
            t.then(" ").then("\u00bb").action(() -> this.send(page + 1)).color(ChatColor.DARK_AQUA);
        });
        chain.send(this.player).deploy();
    }
}

