/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.Service;
import com.github.sanctum.labyrinth.formatting.TabGroup;
import com.github.sanctum.labyrinth.formatting.TabInfo;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface TablistInstance {
    public Player getHolder();

    public Collection<TabGroup> getGroups();

    public TabGroup getGroup(String var1);

    public TabGroup getCurrent();

    public TabGroup getPrevious();

    public boolean add(TabGroup var1);

    public boolean remove(TabGroup var1);

    public boolean enable();

    public boolean enable(Consumer<Player> var1);

    public boolean enable(Consumer<Player> var1, TimeUnit var2, long var3);

    public boolean disable();

    public boolean disable(Consumer<Player> var1);

    public boolean isEnabled();

    public void setActive(TabGroup var1, boolean var2);

    default public boolean setActive(TabGroup group, TimeUnit unit, long time, boolean stopFirst) {
        if (stopFirst) {
            if (this.disable()) {
                this.setActive(group, true);
                this.enable();
                LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> {
                    if (this.disable()) {
                        this.setActive(this.getPrevious(), true);
                        this.enable();
                    }
                }, group.getKey() + "-status-change", unit.toMillis(time));
                return true;
            }
        } else {
            this.setActive(group, true);
            LabyrinthProvider.getService(Service.TASK).getScheduler(0).wait(() -> this.setActive(this.getPrevious(), true), group.getKey() + "-status-change", unit.toMillis(time));
            return true;
        }
        return false;
    }

    @NotNull
    public static TablistInstance get(@NotNull Player target) {
        if (target == null) {
            TablistInstance.$$$reportNull$$$0(0);
        }
        TablistInstance tablistInstance = TabInfo.instances.computeIfAbsent(target, player -> new TablistInstance((Player)player){
            private final Map<String, TabGroup> groups = new HashMap<String, TabGroup>();
            private String previous;
            final /* synthetic */ Player val$player;
            {
                this.val$player = player;
            }

            @Override
            public Player getHolder() {
                return this.val$player;
            }

            @Override
            public Collection<TabGroup> getGroups() {
                return this.groups.values();
            }

            @Override
            public TabGroup getGroup(String key) {
                return this.groups.get(key);
            }

            @Override
            public TabGroup getCurrent() {
                return this.getGroups().stream().filter(TabGroup::isActive).findFirst().orElse(null);
            }

            @Override
            public TabGroup getPrevious() {
                return this.groups.get(this.previous);
            }

            @Override
            public boolean add(TabGroup group) {
                this.groups.put(group.getKey(), group);
                return true;
            }

            @Override
            public boolean remove(TabGroup group) {
                this.groups.remove(group.getKey());
                return true;
            }

            @Override
            public boolean enable() {
                return this.enable(player1 -> {}, TimeUnit.MILLISECONDS, 40L);
            }

            @Override
            public boolean enable(Consumer<Player> consumer) {
                return this.enable(consumer, TimeUnit.MILLISECONDS, 40L);
            }

            @Override
            public boolean enable(final Consumer<Player> consumer, TimeUnit unit, long period) {
                if (this.isEnabled()) {
                    return false;
                }
                Task task = new Task(this.getHolder().getName() + "-tablist", 1, TaskChain.getSynchronous()){
                    private static final long serialVersionUID = -3924140918741032392L;

                    @Ordinal
                    public void onRun() {
                        if (this.getHolder() == null || !this.getHolder().isOnline()) {
                            this.cancel();
                            return;
                        }
                        this.getGroups().stream().filter(TabGroup::isActive).findFirst().ifPresent(tabGroup -> {
                            tabGroup.nextDisplayIndex(0);
                            tabGroup.nextDisplayIndex(1);
                            TabInfo header = tabGroup.getHeader(tabGroup.getCurrentHeaderIndex());
                            TabInfo footer = tabGroup.getFooter(tabGroup.getCurrentFooterIndex());
                            this.getHolder().setPlayerListHeaderFooter(StringUtils.use(header.toString()).translate((OfflinePlayer)this.getHolder()), StringUtils.use(footer.toString()).translate((OfflinePlayer)this.getHolder()));
                            consumer.accept(this.getHolder());
                        });
                    }
                };
                TaskChain.getSynchronous().repeat(task, unit.toMillis(period), unit.toMillis(period));
                return true;
            }

            @Override
            public boolean disable() {
                if (!this.isEnabled()) {
                    return false;
                }
                LabyrinthProvider.getInstance().getScheduler(0).get(this.getHolder().getName() + "-tablist").cancel();
                return true;
            }

            @Override
            public boolean disable(Consumer<Player> consumer) {
                if (!this.isEnabled()) {
                    return false;
                }
                LabyrinthProvider.getInstance().getScheduler(0).get(this.getHolder().getName() + "-tablist").cancel();
                consumer.accept(this.getHolder());
                return true;
            }

            @Override
            public boolean isEnabled() {
                return Optional.ofNullable(LabyrinthProvider.getInstance().getScheduler(0).get(this.getHolder().getName() + "-tablist")).isPresent();
            }

            @Override
            public void setActive(TabGroup group, boolean active) {
                if (active) {
                    this.groups.values().forEach(group1 -> {
                        if (!group1.equals(group) && group1.isActive()) {
                            group1.setActive(false);
                            this.previous = group1.getKey();
                        }
                    });
                    group.setActive(true);
                } else {
                    this.previous = group.getKey();
                    group.setActive(false);
                }
            }
        });
        if (tablistInstance == null) {
            TablistInstance.$$$reportNull$$$0(1);
        }
        return tablistInstance;
    }

    @NotNull
    public static TablistInstance[] getAll() {
        TablistInstance[] tablistInstanceArray = (TablistInstance[])Bukkit.getOnlinePlayers().stream().map(TablistInstance::get).toArray(TablistInstance[]::new);
        if (tablistInstanceArray == null) {
            TablistInstance.$$$reportNull$$$0(2);
        }
        return tablistInstanceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/formatting/TablistInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/formatting/TablistInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

