/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.formatting.TabInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public interface TabGroup {
    public String getKey();

    public boolean isActive();

    public boolean isWindable();

    public void setActive(boolean var1);

    public TabInfo getHeader(int var1);

    public int getCurrentHeaderIndex();

    public TabInfo getFooter(int var1);

    public int getCurrentFooterIndex();

    public void setWindable(boolean var1);

    public void nextDisplayIndex(int var1);

    public static TabGroup fromInfo(final String key, final TabInfo[] header, final TabInfo[] footer) {
        return new TabGroup(){
            private final List<TabInfo> headerlist = Collections.synchronizedList(new LinkedList());
            private final List<TabInfo> footerlist = Collections.synchronizedList(new LinkedList());
            private int headerPos;
            private int footerPos;
            private boolean isWindable = true;
            private boolean isActive = true;
            private boolean headerGoingBackwards;
            private boolean footerGoingBackwards;
            {
                this.headerlist.addAll(Arrays.asList(header));
                this.footerlist.addAll(Arrays.asList(footer));
            }

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public boolean isActive() {
                return this.isActive;
            }

            @Override
            public boolean isWindable() {
                return this.isWindable;
            }

            @Override
            public void setActive(boolean active) {
                this.isActive = active;
            }

            @Override
            public TabInfo getHeader(int index) {
                return Collections.unmodifiableList(this.headerlist).get(index);
            }

            @Override
            public int getCurrentHeaderIndex() {
                return Math.max(0, this.headerPos);
            }

            @Override
            public TabInfo getFooter(int index) {
                return Collections.unmodifiableList(this.footerlist).get(index);
            }

            @Override
            public int getCurrentFooterIndex() {
                return Math.max(this.footerPos, 0);
            }

            @Override
            public void setWindable(boolean windable) {
                this.isWindable = windable;
            }

            @Override
            public void nextDisplayIndex(int side) {
                switch (side) {
                    case 0: {
                        if (this.headerPos + 1 >= this.headerlist.size()) {
                            if (this.isWindable) {
                                this.headerGoingBackwards = true;
                                --this.headerPos;
                                break;
                            }
                            this.headerPos = 0;
                            break;
                        }
                        if (this.headerGoingBackwards) {
                            if (this.headerPos == 0) {
                                this.headerGoingBackwards = false;
                                ++this.headerPos;
                                break;
                            }
                            --this.headerPos;
                            break;
                        }
                        ++this.headerPos;
                        break;
                    }
                    case 1: {
                        if (this.footerPos + 1 >= this.footerlist.size()) {
                            if (this.isWindable) {
                                this.footerGoingBackwards = true;
                                --this.footerPos;
                                break;
                            }
                            this.footerPos = 0;
                            break;
                        }
                        if (this.footerGoingBackwards) {
                            if (this.footerPos == 0) {
                                this.footerGoingBackwards = false;
                                ++this.footerPos;
                                break;
                            }
                            --this.footerPos;
                            break;
                        }
                        ++this.footerPos;
                    }
                }
            }
        };
    }
}

