/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.formatting.ScoreboardBuilder;
import com.github.sanctum.labyrinth.formatting.ScoreboardGroup;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.labyrinth.task.BukkitTaskPredicate;
import com.github.sanctum.labyrinth.task.RenderedTask;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ScoreboardInstance {
    public ScoreboardInstance update(@NotNull Scoreboard var1);

    public ScoreboardInstance update(@NotNull ScoreboardGroup var1);

    public ScoreboardInstance update(@NotNull ScoreboardGroup var1, long var2);

    /*
     * WARNING - void declaration
     */
    default public ScoreboardInstance flip(@NotNull ScoreboardGroup group, @NotNull ScoreboardGroup group2, long interval, long l) {
        void flip;
        if (group == null) {
            ScoreboardInstance.$$$reportNull$$$0(0);
        }
        if (group2 == null) {
            ScoreboardInstance.$$$reportNull$$$0(1);
        }
        this.update(group2, interval);
        this.update(group);
        TaskScheduler.of(this::revert).scheduleLater((long)flip);
        return this;
    }

    public ScoreboardInstance add(@NotNull ScoreboardGroup var1);

    public ScoreboardInstance remove(@NotNull ScoreboardGroup var1);

    public ScoreboardInstance revert();

    public ScoreboardInstance resume();

    public ScoreboardInstance stop();

    @NotNull
    public Player getHolder();

    @Nullable
    public ScoreboardGroup getGroup(@NotNull String var1);

    @Nullable
    public ScoreboardGroup getPrevious();

    @Nullable
    public ScoreboardGroup getCurrent();

    public static ScoreboardInstance get(final @NotNull Player p) {
        if (p == null) {
            ScoreboardInstance.$$$reportNull$$$0(2);
        }
        return ScoreboardBuilder.instances.stream().filter(i -> i.getHolder().equals(p)).findFirst().orElse(new ScoreboardInstance(){
            final PantherMap<String, ScoreboardGroup> groups = new PantherEntryMap<String, ScoreboardGroup>();
            final Player player = p;
            long lastRecordedInt = 1L;
            Scoreboard last = this.player.getScoreboard();
            RenderedTask task;
            ScoreboardGroup previous;
            ScoreboardGroup now;

            @Override
            public ScoreboardInstance update(@NotNull Scoreboard scoreboard) {
                if (scoreboard == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.last = this.player.getScoreboard();
                Objective t = scoreboard.getObjective("Labyrinth-Board");
                if (t != null) {
                    String title = t.getDisplayName();
                    PantherEntryMap map = new PantherEntryMap();
                    scoreboard.getEntries().forEach(e -> scoreboard.getScores(e).forEach(s -> map.put(StringUtils.use(s.getEntry()).translate((OfflinePlayer)this.player), s.getScore())));
                    t.unregister();
                    Objective n = scoreboard.registerNewObjective("Labyrinth-Board", "dummy", StringUtils.use(title).translate((OfflinePlayer)this.player));
                    map.forEach(e -> n.getScore((String)e.getKey()).setScore(((Integer)e.getValue()).intValue()));
                    n.setDisplaySlot(DisplaySlot.SIDEBAR);
                }
                this.player.setScoreboard(scoreboard);
                return this;
            }

            @Override
            public ScoreboardInstance update(@NotNull ScoreboardGroup group) {
                if (group == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.update(group, this.lastRecordedInt);
            }

            @Override
            public ScoreboardInstance update(@NotNull ScoreboardGroup group, long interval) {
                if (group == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.now != null) {
                    this.now.setActive(false);
                }
                this.previous = this.now;
                this.now = group;
                this.now.setActive(true);
                this.lastRecordedInt = interval;
                if (this.task != null) {
                    this.task.getTask().cancel();
                }
                this.task = TaskScheduler.of(() -> {
                    this.now.next();
                    ScoreboardBuilder builder = this.now.getBuilder(this.now.getIndex());
                    this.update(builder.toScoreboard());
                }).scheduleTimer(this.player.getName() + "-scoreboard", interval, interval, BukkitTaskPredicate.cancelAfter(this.player));
                return this;
            }

            @Override
            public ScoreboardInstance add(@NotNull ScoreboardGroup group) {
                if (group == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.groups.put(group.getKey(), group);
                return this;
            }

            @Override
            public ScoreboardInstance remove(@NotNull ScoreboardGroup group) {
                if (group == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.groups.remove(group.getKey());
                return this;
            }

            @Override
            public ScoreboardInstance revert() {
                if (this.previous == null) {
                    Scoreboard now = this.player.getScoreboard();
                    this.player.setScoreboard(this.last);
                    this.last = now;
                } else {
                    this.update(this.previous, this.lastRecordedInt);
                }
                return this;
            }

            @Override
            public ScoreboardInstance resume() {
                if (!this.getCurrent().isActive()) {
                    this.update(this.getCurrent());
                }
                return this;
            }

            @Override
            public ScoreboardInstance stop() {
                if (this.getCurrent().isActive()) {
                    this.task.getTask().cancel();
                    this.getCurrent().setActive(false);
                }
                return this;
            }

            @Override
            @NotNull
            public Player getHolder() {
                Player player = this.player;
                if (player == null) {
                    1.$$$reportNull$$$0(5);
                }
                return player;
            }

            @Override
            public ScoreboardGroup getGroup(@NotNull String key) {
                if (key == null) {
                    1.$$$reportNull$$$0(6);
                }
                return this.groups.get(key);
            }

            @Override
            public ScoreboardGroup getPrevious() {
                return this.previous;
            }

            @Override
            public ScoreboardGroup getCurrent() {
                return this.now;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scoreboard";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/github/sanctum/labyrinth/formatting/ScoreboardInstance$1";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/github/sanctum/labyrinth/formatting/ScoreboardInstance$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHolder";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "add";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "remove";
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getGroup";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/formatting/ScoreboardInstance";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "flip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

