/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.formatting.FancyMessage;
import com.github.sanctum.labyrinth.formatting.JsonChunk;
import com.github.sanctum.labyrinth.formatting.TextChunk;
import com.github.sanctum.labyrinth.formatting.ToolTip;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import com.github.sanctum.panther.annotation.Json;
import com.github.sanctum.panther.util.Deployable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.entity.Player;

public abstract class Message
implements Iterable<Chunk> {
    protected final List<Chunk> TEXT = new ArrayList<Chunk>();

    public abstract Message append(Chunk var1);

    public abstract Message append(Message var1);

    public abstract Message append(@Json String var1);

    public abstract BaseComponent bake();

    public abstract BaseComponent[] build();

    @Json
    public abstract String toJson();

    public final Chunk get(int index) {
        return this.TEXT.get(index);
    }

    public final int length() {
        return this.TEXT.size();
    }

    public boolean isEmpty() {
        return this.TEXT.isEmpty();
    }

    public abstract Deployable<Void> send(Player var1);

    public abstract Deployable<Void> send(Predicate<Player> var1);

    public abstract Deployable<Void> clear();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message chunks = (Message)o;
        return Objects.equals(this.toJson(), chunks.toJson());
    }

    public int hashCode() {
        return Objects.hash(this.toJson());
    }

    public static abstract class Chunk
    implements Iterable<ToolTip<?>> {
        public abstract Chunk append(String var1);

        public abstract Chunk append(int var1);

        public abstract Chunk append(double var1);

        public abstract Chunk append(long var1);

        public abstract Chunk style(ChatColor var1);

        public abstract Chunk style(ChatColor ... var1);

        public abstract Chunk style(CustomColor var1);

        public abstract Chunk color(ChatColor var1);

        public abstract Chunk color(Color var1);

        public abstract Chunk bind(ToolTip<?> var1);

        public abstract Chunk setText(String var1);

        public abstract Chunk replace(String var1, String var2);

        public abstract String getText();

        public boolean isEmpty() {
            return this.getText() != null && !this.getText().isEmpty();
        }

        public abstract BaseComponent toComponent();

        @Json
        public String toJson() {
            return ComponentSerializer.toString((BaseComponent)this.toComponent());
        }

        public static interface Factory {
            default public Chunk json(@Json String section) {
                return new JsonChunk(section);
            }

            default public Chunk text(String text) {
                return new TextChunk(text);
            }

            default public Chunk text(String text, Color color) {
                return new TextChunk(text, color);
            }

            default public Chunk text(String text, ChatColor color) {
                return new TextChunk(text, color);
            }

            default public Chunk text(String text, CustomColor color) {
                return new TextChunk(text, color);
            }
        }
    }

    public static interface Factory
    extends Chunk.Factory,
    ToolTip.Factory {
        default public Message message() {
            return new FancyMessage();
        }
    }
}

