/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.ComponentUtil;
import com.github.sanctum.labyrinth.formatting.Message;
import com.github.sanctum.labyrinth.formatting.ToolTip;
import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import com.github.sanctum.labyrinth.formatting.string.FormattedString;
import com.github.sanctum.labyrinth.library.ListUtils;
import com.github.sanctum.labyrinth.library.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

public class ComponentChunk
extends Message.Chunk {
    private final List<ToolTip<?>> CONTEXT = new ArrayList();
    private TextComponent parent;
    private String color;
    private String style;

    public ComponentChunk(BaseComponent ... parent) {
        this.parent = new TextComponent(parent);
    }

    @Override
    public ComponentChunk append(String text) {
        String now = this.parent.getText();
        this.parent.setText(now + text);
        return this;
    }

    @Override
    public Message.Chunk append(int i) {
        return this.append(String.valueOf(i));
    }

    @Override
    public Message.Chunk append(double d) {
        return this.append(String.valueOf(d));
    }

    @Override
    public Message.Chunk append(long l) {
        return this.append(String.valueOf(l));
    }

    @Override
    public ComponentChunk style(ChatColor style) {
        List<ChatColor> targets = Arrays.asList(ChatColor.BOLD, ChatColor.ITALIC, ChatColor.UNDERLINE, ChatColor.STRIKETHROUGH, ChatColor.RESET, ChatColor.MAGIC);
        if (!targets.contains(style)) {
            throw new IllegalArgumentException("Message: Invalid text style provided.");
        }
        this.style = style.toString();
        return this;
    }

    @Override
    public Message.Chunk style(ChatColor ... style) {
        List<ChatColor> targets = Arrays.asList(ChatColor.BOLD, ChatColor.ITALIC, ChatColor.UNDERLINE, ChatColor.STRIKETHROUGH, ChatColor.RESET, ChatColor.MAGIC);
        for (ChatColor s : style) {
            if (targets.contains(s)) continue;
            throw new IllegalArgumentException("Message: Invalid text style provided.");
        }
        this.style = ListUtils.use(style).join(colors -> colors.stream().map(ChatColor::toString).collect(Collectors.joining()));
        return this;
    }

    @Override
    public ComponentChunk style(CustomColor color) {
        String now = this.parent.getText();
        this.style = null;
        this.color = null;
        String stripped = net.md_5.bungee.api.ChatColor.stripColor((String)StringUtils.use(now).translate());
        this.parent.setText(color.context(stripped).join());
        return this;
    }

    @Override
    public Message.Chunk color(ChatColor color) {
        this.color = color.toString();
        return this;
    }

    @Override
    public Message.Chunk color(Color color) {
        this.color = String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        return this;
    }

    @Override
    public ComponentChunk bind(ToolTip<?> context) {
        this.CONTEXT.add(context);
        return this;
    }

    @Override
    public ComponentChunk setText(String text) {
        this.parent.setText(text);
        return this;
    }

    @Override
    public Message.Chunk replace(String text, String replacement) {
        TextComponent replace = new TextComponent();
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        for (BaseComponent c : this.parent.getExtra()) {
            TextComponent n = new TextComponent(new FormattedString(c.toLegacyText()).replace(text, replacement).get());
            ComponentUtil.copyMeta(c, n);
            components.add(n);
        }
        replace.setExtra(components);
        this.parent = replace;
        return this;
    }

    List<BaseComponent> getAll(Function<String, String> function, List<BaseComponent> list) {
        ArrayList<BaseComponent> components = new ArrayList<BaseComponent>();
        for (BaseComponent c : list) {
            if (c.getExtra() != null) {
                for (BaseComponent inner : this.getAll(function, c.getExtra())) {
                    TextComponent t = new ColoredString(function.apply(inner.toLegacyText()), ColoredString.ColorType.MC_COMPONENT).toComponent();
                    ComponentUtil.copyMeta(inner, t);
                    components.add((BaseComponent)t);
                }
                continue;
            }
            TextComponent t = new ColoredString(function.apply(c.toLegacyText()), ColoredString.ColorType.MC_COMPONENT).toComponent();
            ComponentUtil.copyMeta(c, t);
            components.add((BaseComponent)t);
        }
        return components;
    }

    public Message.Chunk map(Function<String, String> function) {
        TextComponent replace = new TextComponent();
        List<BaseComponent> components = this.getAll(function, this.parent.getExtra());
        replace.setExtra(components);
        this.parent = replace;
        return this;
    }

    @Override
    public String getText() {
        return this.parent.getText();
    }

    @Override
    public BaseComponent toComponent() {
        String now;
        if (this.style != null) {
            if (this.color != null) {
                now = this.parent.getText();
                this.parent.setText(this.color + this.style + now);
            } else {
                this.parent.setText(this.style + this.parent.getText());
            }
        } else if (this.color != null) {
            now = this.parent.getText();
            this.parent.setText(this.color + now);
        }
        ArrayList adjusted = new ArrayList();
        this.CONTEXT.stream().filter(t -> t instanceof ToolTip.Text).forEach((? super T toolTip) -> adjusted.add(((ToolTip.Text)toolTip).get()));
        ListUtils.use(adjusted).append((T object) -> object + "\n").forEach((? super T context) -> {
            if (LabyrinthProvider.getInstance().isLegacy()) {
                this.parent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringUtils.use(context).translate()).create()));
            } else {
                ComponentUtil.addContent((BaseComponent)this.parent, context);
            }
        });
        block8: for (ToolTip<?> context2 : this.CONTEXT) {
            switch (context2.getType()) {
                case COMMAND: {
                    this.parent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)context2.get()));
                    break;
                }
                case HOVER: {
                    if (!(context2 instanceof ToolTip.Item)) break;
                    ToolTip.Item item = (ToolTip.Item)context2;
                    BaseComponent[] components = new BaseComponent[]{new TextComponent(item.toJson())};
                    if (this.parent.getHoverEvent() != null) continue block8;
                    this.parent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, components));
                    break;
                }
                case ACTION: {
                    ToolTip.Action action = (ToolTip.Action)context2;
                    LabyrinthProvider.getInstance().registerComponent(action).deploy();
                    this.parent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + action.getId()));
                    break;
                }
                case SUGGEST: {
                    this.parent.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, (String)context2.get()));
                    break;
                }
                case URL: {
                    this.parent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)context2.get()));
                    break;
                }
                case COPY: {
                    this.parent.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, (String)context2.get()));
                }
            }
        }
        return this.parent;
    }

    @Override
    @NotNull
    public Iterator<ToolTip<?>> iterator() {
        Iterator<ToolTip<?>> iterator = this.CONTEXT.iterator();
        if (iterator == null) {
            ComponentChunk.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    public void forEach(Consumer<? super ToolTip<?>> action) {
        this.CONTEXT.forEach(action);
    }

    @Override
    public Spliterator<ToolTip<?>> spliterator() {
        return this.CONTEXT.spliterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/formatting/ComponentChunk", "iterator"));
    }
}

