/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.event;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EasyListener {
    private Listener listener;
    private Class<? extends Listener> impl;

    public EasyListener(Listener listener) {
        this.listener = listener;
    }

    public EasyListener(Class<? extends Listener> impl) {
        this.impl = impl;
    }

    public void call(Plugin plugin) {
        try {
            if (this.listener == null && this.impl != null) {
                this.listener = this.impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.register(plugin);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LabyrinthProvider.getInstance().getLogger().warning("- Listener " + (this.impl != null ? this.impl.getSimpleName() : "Unknown") + " wasn't able to instantiate. Ensure the constructor contains no parameters.");
        }
    }

    protected void register(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents(this.listener, plugin);
    }

    public static void call(Plugin plugin, Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, plugin);
    }
}

