/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.service;

import com.github.sanctum.labyrinth.data.service.Constant;
import com.github.sanctum.labyrinth.data.service.ProtectedConstants;
import com.github.sanctum.panther.util.Deployable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

final class UtilityBreachedConstants<T>
extends ProtectedConstants<T> {
    private final Class<T> t;
    private final List<Constant<T>> list = new ArrayList<Constant<T>>();

    UtilityBreachedConstants(Class<T> type) {
        this.t = type;
    }

    @Override
    public Deployable<Field[]> debug() {
        return Deployable.of(this.t.getDeclaredFields(), fields -> {
            for (Field f : fields) {
                int modifiers = f.getModifiers();
                if ((!Modifier.isPrivate(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) && (!Modifier.isProtected(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers))) continue;
                f.setAccessible(true);
                try {
                    Object o = f.get(null);
                    Bukkit.getLogger().info("- got field " + f.getName() + " type:" + o.getClass().getSimpleName());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public Deployable<Map<Class<?>, List<Object>>> resolve() {
        HashMap objects = new HashMap();
        return Deployable.of(objects, objects1 -> {
            objects1.clear();
            this.list.clear();
            for (final Field f : this.t.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if ((!Modifier.isPrivate(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) && (!Modifier.isProtected(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers))) continue;
                f.setAccessible(true);
                try {
                    final Object o = f.get(null);
                    if (o == null) continue;
                    this.list.add(new Constant<T>(){

                        @Override
                        public String getName() {
                            return f.getName();
                        }

                        @Override
                        public Class<T> getType() {
                            return o.getClass();
                        }

                        @Override
                        public Class<?> getParent() {
                            return UtilityBreachedConstants.this.t;
                        }

                        @Override
                        public T getValue() {
                            return o;
                        }
                    });
                    if (objects1.get(o.getClass()) != null) {
                        ((List)objects1.get(o.getClass())).add(o);
                        continue;
                    }
                    objects1.put(o.getClass(), new ArrayList<Object>(Collections.singletonList(o)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public <O> Deployable<List<O>> resolve(Class<O> c) {
        ArrayList objects = new ArrayList();
        return Deployable.of(objects, objects1 -> {
            objects1.clear();
            this.list.clear();
            for (Field f : this.t.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if ((!Modifier.isPrivate(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) && (!Modifier.isProtected(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers))) continue;
                f.setAccessible(true);
                try {
                    Object o = f.get(null);
                    if (o == null || !c.isAssignableFrom(o.getClass())) continue;
                    objects1.add(o);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public <O> Deployable<List<Constant<O>>> get(final Class<O> c) {
        ArrayList objects = new ArrayList();
        return Deployable.of(objects, objects1 -> {
            objects1.clear();
            for (final Field f : this.t.getFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                f.setAccessible(true);
                try {
                    final Object o = f.get(null);
                    if (o == null || !c.isAssignableFrom(o.getClass())) continue;
                    objects1.add(new Constant<O>(){

                        @Override
                        public String getName() {
                            return f.getName();
                        }

                        @Override
                        public Class<O> getType() {
                            return c;
                        }

                        @Override
                        public Class<?> getParent() {
                            return UtilityBreachedConstants.this.t;
                        }

                        @Override
                        public O getValue() {
                            return o;
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public Constant<T> get(String name) {
        if (this.list.isEmpty()) {
            this.resolve().deploy();
        }
        return this.list.stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public int count() {
        return (int)Arrays.stream(this.t.getFields()).filter(f -> {
            int modifiers = f.getModifiers();
            return Modifier.isPrivate(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) || Modifier.isProtected(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
        }).map(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(o -> {
            if (o == null) {
                return false;
            }
            return this.t.isAssignableFrom(o.getClass());
        }).count();
    }

    @Override
    @NotNull
    public Iterator<Constant<T>> iterator() {
        Deployable<Map<Class<?>, List<Object>>> deployable = this.resolve();
        if (this.list.isEmpty()) {
            deployable.deploy();
        }
        Iterator<Constant<T>> iterator = this.list.iterator();
        if (iterator == null) {
            UtilityBreachedConstants.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    public void forEach(Consumer<? super Constant<T>> action) {
        Deployable<Map<Class<?>, List<Object>>> deployable = this.resolve();
        if (this.list.isEmpty()) {
            deployable.deploy();
        }
        this.list.forEach(action);
    }

    @Override
    public Spliterator<Constant<T>> spliterator() {
        Deployable<Map<Class<?>, List<Object>>> deployable = this.resolve();
        if (this.list.isEmpty()) {
            deployable.deploy();
        }
        return this.list.spliterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/data/service/UtilityBreachedConstants", "iterator"));
    }
}

