/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.service;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.LabyrinthAPI;
import com.github.sanctum.labyrinth.data.LabyrinthUser;
import com.github.sanctum.labyrinth.data.container.CollectionTask;
import com.github.sanctum.labyrinth.formatting.string.ImageBreakdown;
import com.github.sanctum.labyrinth.library.TimeWatch;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.util.Deployable;
import com.github.sanctum.panther.util.SpecialID;
import com.google.gson.JsonArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerSearch
implements LabyrinthUser {
    static final PantherMap<String, PlayerSearch> lookups = new PantherEntryMap<String, PlayerSearch>();

    @Override
    @NotNull
    public abstract String getName();

    @Override
    @NotNull
    public abstract OfflinePlayer getPlayer();

    @Override
    @NotNull
    public abstract UUID getId();

    @NotNull
    public abstract SpecialID getSpecialId();

    public final TimeWatch.Recording getPlaytime() {
        return TimeWatch.Recording.subtract(this.getPlayer().getFirstPlayed());
    }

    public abstract ImageBreakdown getHeadImage();

    public static PlayerSearch of(final @NotNull OfflinePlayer player) {
        String name;
        if (player == null) {
            PlayerSearch.$$$reportNull$$$0(0);
        }
        if ((name = player.getName()) == null) {
            LabyrinthProvider.getInstance().getLogger().severe("- Attempted and failed to register corrupt player data (" + player + "), this is not the fault of labyrinth.");
            return null;
        }
        return lookups.computeIfAbsent(name, s -> new PlayerSearch((String)s){
            final OfflinePlayer parent;
            ImageBreakdown image;
            final String name;
            String[] names;
            final UUID reference;
            final boolean isOnlineMode;
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
                this.parent = player;
                this.isOnlineMode = Bukkit.getOnlineMode();
                this.name = this.val$s;
                this.reference = player.getUniqueId();
                if (StringUtils.isAlphanumeric((String)this.name)) {
                    TaskScheduler.of(() -> {
                        try {
                            this.image = new ImageBreakdown("https://minotar.net/avatar/" + this.val$s + ".png", 8, '\u2588'){};
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }).scheduleAsync().next(() -> {
                        BufferedReader in = null;
                        StringBuilder sb = new StringBuilder();
                        try {
                            String str;
                            URL url = new URL("https://api.mojang.com/user/profiles/" + this.reference.toString() + "/names");
                            in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                            while ((str = in.readLine()) != null) {
                                sb.append(str);
                            }
                        }
                        catch (Exception str) {
                        }
                        finally {
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException str) {}
                        }
                        if (sb.length() > 0) {
                            JsonArray array = (JsonArray)JsonAdapter.getJsonBuilder().create().fromJson(sb.toString(), JsonArray.class);
                            PantherList names = new PantherList();
                            array.forEach(element -> {
                                if (element.isJsonObject()) {
                                    names.add(element.getAsJsonObject().get("name").getAsString());
                                }
                            });
                            this.names = (String[])names.stream().toArray(String[]::new);
                        }
                    }).scheduleAsync();
                } else {
                    this.names = new String[0];
                }
            }

            @Override
            @NotNull
            public String getName() {
                String string = this.name;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public String[] getPreviousNames() {
                return this.names;
            }

            @Override
            @NotNull
            public OfflinePlayer getPlayer() {
                OfflinePlayer offlinePlayer = this.isOnlineMode ? this.parent : Bukkit.getOfflinePlayer((String)this.getName());
                if (offlinePlayer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return offlinePlayer;
            }

            @Override
            @NotNull
            public UUID getId() {
                UUID uUID = this.isOnlineMode ? this.reference : this.getPlayer().getUniqueId();
                if (uUID == null) {
                    1.$$$reportNull$$$0(2);
                }
                return uUID;
            }

            @Override
            @Note(value="Length of 12 (HUID)")
            @NotNull
            public @Note(value="Length of 12 (HUID)") @NotNull SpecialID getSpecialId() {
                SpecialID specialID = SpecialID.builder().setLength(12).build(this.name);
                if (specialID == null) {
                    1.$$$reportNull$$$0(3);
                }
                return specialID;
            }

            @Override
            public ImageBreakdown getHeadImage() {
                if (this.image == null) {
                    return null;
                }
                return new ImageBreakdown(this.image){};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/github/sanctum/labyrinth/data/service/PlayerSearch$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPlayer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSpecialId";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    public static PlayerSearch of(String name) {
        return lookups.get(name);
    }

    public static void register(@NotNull PlayerSearch search) {
        if (search == null) {
            PlayerSearch.$$$reportNull$$$0(1);
        }
        lookups.put(search.getName(), search);
    }

    public static PantherCollection<PlayerSearch> values() {
        return lookups.values();
    }

    public static Deployable<Void> reload() {
        return Deployable.of(() -> {
            lookups.clear();
            OfflinePlayer[] players = Bukkit.getOfflinePlayers();
            LabyrinthAPI api = LabyrinthProvider.getInstance();
            if (players.length >= 500) {
                if (players.length >= 1000) {
                    int runtime = 0;
                    CollectionTask<OfflinePlayer> cache = CollectionTask.process(players, "USER-CACHE", 20, runtime, PlayerSearch::of);
                    api.getLogger().warning("- Whoa large amounts of registered players, splitting the workload...");
                    api.getScheduler(runtime).repeat(cache, 0L, 50L);
                } else {
                    CollectionTask<OfflinePlayer> cache = CollectionTask.process(players, "USER-CACHE", 20, PlayerSearch::of);
                    api.getLogger().warning("- A-lot of registered players, splitting the workload...");
                    api.getScheduler(1).repeat(cache, 0L, 50L);
                    while (cache.getCompletion() < 100.0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                for (OfflinePlayer op : players) {
                    PlayerSearch.of(op);
                }
            }
            return null;
        }, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/data/service/PlayerSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "of";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

