/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.service;

import com.github.sanctum.labyrinth.data.service.AccessibleConstants;
import com.github.sanctum.labyrinth.data.service.Constant;
import com.github.sanctum.panther.util.Deployable;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

final class ParsableAccessibleConstants
extends AccessibleConstants<Object> {
    private final Class<?> t;
    private final List<Constant<?>> list = new ArrayList();

    ParsableAccessibleConstants(Type type) {
        this.t = TypeToken.get((Type)type).getRawType();
    }

    @Override
    public Deployable<Field[]> debug() {
        return Deployable.of(this.t.getFields(), fields -> {
            for (Field f : fields) {
                int modifiers = f.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                try {
                    Object o = f.get(null);
                    Bukkit.getLogger().info("- got field " + f.getName() + " type:" + o.getClass().getSimpleName());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public Deployable<Map<Class<?>, List<Object>>> resolve() {
        HashMap objects = new HashMap();
        return Deployable.of(objects, objects1 -> {
            objects1.clear();
            this.list.clear();
            for (final Field f : this.t.getFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                try {
                    final Object o = f.get(null);
                    if (o == null) continue;
                    this.list.add(new Constant<Object>(){

                        @Override
                        public String getName() {
                            return f.getName();
                        }

                        @Override
                        public Class<Object> getType() {
                            return o.getClass();
                        }

                        @Override
                        public Class<?> getParent() {
                            return ParsableAccessibleConstants.this.t;
                        }

                        @Override
                        public Object getValue() {
                            return o;
                        }
                    });
                    if (objects.get(o.getClass()) != null) {
                        ((List)objects1.get(o.getClass())).add(o);
                        continue;
                    }
                    objects1.put(o.getClass(), new ArrayList<Object>(Collections.singletonList(o)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public <O> Deployable<List<O>> resolve(Class<O> c) {
        ArrayList objects = new ArrayList();
        return Deployable.of(objects, objects1 -> {
            objects1.clear();
            this.list.clear();
            for (Field f : this.t.getFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                try {
                    Object o = f.get(null);
                    if (o == null || !c.isAssignableFrom(o.getClass())) continue;
                    objects1.add(o);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public <O> Deployable<List<Constant<O>>> get(final Class<O> c) {
        ArrayList objects = new ArrayList();
        return Deployable.of(objects, objects1 -> {
            objects1.clear();
            for (final Field f : this.t.getFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                try {
                    final Object o = f.get(null);
                    if (o == null || !c.isAssignableFrom(o.getClass())) continue;
                    objects1.add(new Constant<O>(){

                        @Override
                        public String getName() {
                            return f.getName();
                        }

                        @Override
                        public Class<O> getType() {
                            return c;
                        }

                        @Override
                        public Class<?> getParent() {
                            return ParsableAccessibleConstants.this.t;
                        }

                        @Override
                        public O getValue() {
                            return o;
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 0);
    }

    @Override
    public Constant<?> get(String name) {
        if (this.list.isEmpty()) {
            this.resolve().deploy();
        }
        return this.list.stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public int count() {
        return (int)Arrays.stream(this.t.getFields()).filter(f -> {
            int modifiers = f.getModifiers();
            return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
        }).map(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(o -> {
            if (o == null) {
                return false;
            }
            return this.t.isAssignableFrom(o.getClass());
        }).count();
    }

    @Override
    @NotNull
    public Iterator<Constant<Object>> iterator() {
        Deployable<Map<Class<?>, List<Object>>> deployable = this.resolve();
        if (this.list.isEmpty()) {
            deployable.deploy();
        }
        Iterator<Constant<Object>> iterator = this.list.stream().map(constant -> constant).collect(Collectors.toList()).iterator();
        if (iterator == null) {
            ParsableAccessibleConstants.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    public void forEach(Consumer<? super Constant<Object>> action) {
        Deployable<Map<Class<?>, List<Object>>> deployable = this.resolve();
        if (this.list.isEmpty()) {
            deployable.deploy();
        }
        this.list.stream().map(constant -> constant).collect(Collectors.toList()).forEach(action);
    }

    @Override
    public Spliterator<Constant<Object>> spliterator() {
        Deployable<Map<Class<?>, List<Object>>> deployable = this.resolve();
        if (this.list.isEmpty()) {
            deployable.deploy();
        }
        return this.list.stream().map(constant -> constant).collect(Collectors.toList()).spliterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/data/service/ParsableAccessibleConstants", "iterator"));
    }
}

