/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.service;

import com.github.sanctum.labyrinth.api.LabyrinthAPI;
import com.github.sanctum.labyrinth.data.FileList;
import com.github.sanctum.labyrinth.data.service.AnvilMechanics;
import com.github.sanctum.labyrinth.data.service.AnvilMechanicsLoader;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalDataService {
    private boolean valid;

    public abstract AnvilMechanics getMechanics();

    public abstract String getServerVersion();

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid() {
        this.valid = true;
    }

    public static final class Handshake
    extends Task {
        private static final long serialVersionUID = -6080924258181953124L;
        static Handshake handshake;
        private final LabyrinthAPI instance;
        private final String version;
        private boolean shook;

        Handshake(LabyrinthAPI instance) {
            super("Labyrinth-Handshake", TaskChain.getSynchronous());
            this.instance = instance;
            this.version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1);
        }

        @Ordinal
        private void initialize() {
            if (!this.shook) {
                InputStream stream = this.instance.getPluginInstance().getResource(this.version + ".jar");
                if (stream == null) {
                    this.instance.getLogger().severe("- Version " + this.version + " not supported correctly. Consult labyrinth developers.");
                    return;
                }
                File file = new File("plugins/Labyrinth/Service/" + this.version + ".jar");
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                for (File f : file.getParentFile().listFiles()) {
                    if (!f.isFile() || !f.delete()) continue;
                    this.instance.getLogger().info("- Deleting old version traces.");
                }
                if (!file.exists()) {
                    this.shook = true;
                    this.instance.getLogger().info("- Compiling anvil mechanics for version " + this.version + ".");
                    FileList.copy(stream, file);
                    try {
                        AnvilMechanicsLoader loader = new AnvilMechanicsLoader(file, this.instance.getPluginInstance().getClass().getClassLoader(), new Object[0]);
                        ExternalDataService service = (ExternalDataService)loader.getMainClass();
                        AnvilMechanics mechanics = service.getMechanics();
                        if (mechanics != null) {
                            if (!service.getServerVersion().contains(this.version)) {
                                this.instance.getLogger().severe("- Version service " + service.getServerVersion() + " invalid for " + this.version);
                                return;
                            }
                            Bukkit.getServicesManager().register(AnvilMechanics.class, (Object)mechanics, this.instance.getPluginInstance(), ServicePriority.High);
                            this.instance.getLogger().info("- Version service " + service.getClass().getSimpleName() + " selected as primary anvil mechanics.");
                            service.setValid();
                        } else {
                            this.instance.getLogger().severe("- Version service " + service.getClass().getSimpleName() + " has invalid anvil mechanics...");
                        }
                    }
                    catch (IOException e) {
                        this.instance.getLogger().severe("- Unable to resolve version service " + this.version + ", contact labyrinth developers.");
                    }
                }
            }
        }

        public String toString() {
            return "Handshake{version='" + this.version + '\'' + ", shook=" + this.shook + '}';
        }

        public static Handshake getInstance(@NotNull LabyrinthAPI api) {
            if (api == null) {
                Handshake.$$$reportNull$$$0(0);
            }
            return handshake != null ? handshake : (handshake = new Handshake(api));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/github/sanctum/labyrinth/data/service/ExternalDataService$Handshake", "getInstance"));
        }
    }
}

