/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.CuboidAxis;
import com.github.sanctum.labyrinth.data.CuboidLocation;
import com.github.sanctum.labyrinth.data.RegionServicesManager;
import com.github.sanctum.labyrinth.data.container.Cuboid;
import com.github.sanctum.labyrinth.formatting.UniformedComponents;
import com.github.sanctum.labyrinth.interfacing.Catchable;
import com.github.sanctum.labyrinth.interfacing.Snapshot;
import com.github.sanctum.panther.container.ImmutablePantherCollection;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.util.HUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class Region
implements Cuboid,
Snapshot,
Catchable<Region> {
    private Region parent;
    private final double distanceBetweenPoints;
    private final Location point1;
    private final Location point2;
    private final CuboidAxis axis;
    private final CuboidLocation location;
    private final HUID id;
    private UUID owner;
    private String name;
    private boolean dominant;
    private final Plugin plugin;
    protected final List<Cuboid.Flag> FLAGS;
    private final List<UUID> MEMBERS;
    private final PantherList<Block> list;

    protected Region(Cuboid cuboid) {
        if (cuboid instanceof Region) {
            this.parent = (Region)cuboid;
            this.axis = ((Region)cuboid).axis;
            this.id = ((Region)cuboid).id;
            this.FLAGS = ((Region)cuboid).FLAGS;
            this.MEMBERS = ((Region)cuboid).MEMBERS;
            this.plugin = ((Region)cuboid).plugin;
            this.list = ((Region)cuboid).list;
            this.owner = ((Region)cuboid).owner;
            this.name = ((Region)cuboid).name;
            this.dominant = ((Region)cuboid).dominant;
            this.point1 = ((Region)cuboid).point1;
            this.point2 = ((Region)cuboid).point2;
            this.distanceBetweenPoints = ((Region)cuboid).distanceBetweenPoints;
            this.location = ((Region)cuboid).location;
        } else {
            this.axis = cuboid.getAxis();
            this.location = cuboid.getLocation();
            this.id = HUID.randomID();
            this.FLAGS = new ArrayList<Cuboid.Flag>();
            this.MEMBERS = new ArrayList<UUID>();
            this.plugin = LabyrinthProvider.getInstance().getPluginInstance();
            this.list = new PantherList(this.axis.getTotalSize());
            for (int x = this.axis.getxMin(); x <= this.axis.getxMax(); ++x) {
                for (int y = this.axis.getyMin(); y <= this.axis.getyMax(); ++y) {
                    for (int z = this.axis.getzMin(); z <= this.axis.getzMax(); ++z) {
                        Block b = this.location.getWorld().getBlockAt(x, y, z);
                        this.list.add(b);
                    }
                }
            }
            this.point1 = new Location(this.location.getWorld(), (double)this.axis.getxMin(), (double)this.axis.getyMin(), (double)this.axis.getzMin());
            this.point2 = new Location(this.location.getWorld(), (double)this.axis.getxMax(), (double)this.axis.getyMax(), (double)this.axis.getzMax());
            this.distanceBetweenPoints = this.getStartingPoint().distance(this.getEndingPoint());
            for (Cuboid.Flag registered : RegionServicesManager.getInstance().getFlagManager().getFlags()) {
                this.addFlag(registered);
            }
        }
    }

    protected Region(Region cuboid, Region parent) {
        this(cuboid);
        this.parent = parent;
    }

    protected Region(Location point1, Location point2) {
        this(point1, point2, HUID.randomID());
    }

    protected Region(Location point1, Location point2, HUID id) {
        this(point1, point2, LabyrinthProvider.getInstance().getPluginInstance(), id);
    }

    protected Region(Location point1, Location point2, Plugin plugin) {
        this(point1, point2, plugin, HUID.randomID());
    }

    protected Region(Location point1, Location point2, Plugin plugin, HUID id) {
        this(point1.getWorld(), Math.min(point1.getBlockX(), point2.getBlockX()), Math.max(point1.getBlockX(), point2.getBlockX()), Math.min(point1.getBlockY(), point2.getBlockY()), Math.max(point1.getBlockY(), point2.getBlockY()), Math.min(point1.getBlockZ(), point2.getBlockZ()), Math.max(point1.getBlockZ(), point2.getBlockZ()), plugin, id);
    }

    protected Region(World world, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, HUID id) {
        this(world, xMin, xMax, yMin, yMax, zMin, zMax, LabyrinthProvider.getInstance().getPluginInstance(), id);
    }

    protected Region(World world, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, Plugin plugin, HUID id) {
        this.axis = new CuboidAxis(xMax, xMin, yMax, yMin, zMax, zMin);
        this.location = new CuboidLocation(this.axis, world);
        this.id = id;
        this.FLAGS = new ArrayList<Cuboid.Flag>();
        this.MEMBERS = new ArrayList<UUID>();
        this.plugin = plugin;
        this.list = new PantherList(this.axis.getTotalSize());
        for (int x = this.axis.getxMin(); x <= this.axis.getxMax(); ++x) {
            for (int y = this.axis.getyMin(); y <= this.axis.getyMax(); ++y) {
                for (int z = this.axis.getzMin(); z <= this.axis.getzMax(); ++z) {
                    Block b = this.location.getWorld().getBlockAt(x, y, z);
                    this.list.add(b);
                }
            }
        }
        this.point1 = new Location(this.location.getWorld(), (double)this.axis.getxMin(), (double)this.axis.getyMin(), (double)this.axis.getzMin());
        this.point2 = new Location(this.location.getWorld(), (double)this.axis.getxMax(), (double)this.axis.getyMax(), (double)this.axis.getzMax());
        this.distanceBetweenPoints = this.getStartingPoint().distance(this.getEndingPoint());
        for (Cuboid.Flag registered : RegionServicesManager.getInstance().getFlagManager().getFlags()) {
            this.addFlag(registered);
        }
    }

    @Override
    public Region getSnapshot() {
        return new Region(this, this){};
    }

    @Override
    public boolean update() throws IllegalArgumentException {
        if (this.parent == null) {
            return false;
        }
        if (!this.parent.id.equals(this.id)) {
            throw new IllegalArgumentException("Region snapshot mismatch!.");
        }
        boolean updated = false;
        if (!this.parent.MEMBERS.containsAll(this.MEMBERS)) {
            this.parent.MEMBERS.clear();
            this.parent.MEMBERS.addAll(this.MEMBERS);
            updated = true;
        }
        if (!this.parent.FLAGS.containsAll(this.FLAGS)) {
            this.parent.FLAGS.clear();
            this.parent.FLAGS.addAll(this.FLAGS);
            updated = true;
        }
        if (!this.parent.owner.equals(this.owner)) {
            this.parent.setOwner(this.owner);
            updated = true;
        }
        if (!this.parent.getName().equals(this.getName())) {
            this.parent.setName(this.name);
            updated = true;
        }
        return updated;
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    public HUID getId() {
        return this.id;
    }

    public PantherCollection<Block> getBlocks() {
        return ImmutablePantherCollection.of(this.list);
    }

    public List<Region> getLaced() {
        ArrayList<Region> list = new ArrayList<Region>();
        RegionServicesManager.getInstance().getAll().forEach(c -> {
            for (Block b : this.list) {
                if (!c.contains(b.getLocation()) || c.getId().equals(this.getId())) continue;
                list.add((Region)c);
            }
        });
        return list;
    }

    public Location getHighpoint() {
        return this.getStartingPoint().getBlockY() > this.getEndingPoint().getBlockY() ? this.getStartingPoint() : this.getEndingPoint();
    }

    public Location getLowpoint() {
        return this.getEndingPoint().getBlockY() < this.getStartingPoint().getBlockY() ? this.getEndingPoint() : this.getStartingPoint();
    }

    public double getDistanceBetweenPoints() {
        return this.distanceBetweenPoints;
    }

    public Location getStartingPoint() {
        return this.point1;
    }

    public Location getEndingPoint() {
        return this.point2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : this.id.toString();
    }

    @Override
    public Cuboid.VisualBoundary getBoundary(Player target) {
        return new Cuboid.VisualBoundary((double)this.axis.getxMax() + 0.5, (double)this.axis.getxMin() + 0.5, (double)this.axis.getyMax() + 0.5, (double)this.axis.getyMin() + 0.5, (double)this.axis.getzMax() + 0.5, (double)this.axis.getzMin() + 0.5).setViewer(target);
    }

    @Override
    public CuboidAxis getAxis() {
        return this.axis;
    }

    @Override
    public CuboidLocation getLocation() {
        return this.location;
    }

    @Override
    public int getTotalBlocks() {
        return this.axis.getTotalSize();
    }

    public OfflinePlayer getOwner() {
        return this.owner != null ? Bukkit.getOfflinePlayer((UUID)this.owner) : null;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public List<OfflinePlayer> getMembers() {
        return UniformedComponents.accept(this.MEMBERS).map(Bukkit::getOfflinePlayer).collect(Collectors.toList());
    }

    public List<Cuboid.Flag> getFlags() {
        return Collections.unmodifiableList(this.FLAGS);
    }

    public Optional<Cuboid.Flag> getFlag(String id) {
        return this.FLAGS.stream().filter(f -> f.getId().equals(id)).findFirst();
    }

    public boolean isMember(OfflinePlayer p) {
        return UniformedComponents.accept(this.getMembers()).filter(o -> o.getUniqueId().equals(p.getUniqueId())).findAny().isPresent();
    }

    public boolean hasFlag(String id) {
        return this.getFlag(id).isPresent();
    }

    public boolean hasFlag(Cuboid.Flag flag) {
        return this.FLAGS.stream().anyMatch(f -> f.getId().equals(flag.getId()));
    }

    public boolean addFlag(Cuboid.Flag flag) {
        if (!this.hasFlag(flag)) {
            return this.FLAGS.add(flag.clone());
        }
        return false;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void setDominant(boolean dominant) {
        this.dominant = dominant;
    }

    public boolean addFlag(Cuboid.Flag ... flag) {
        for (Cuboid.Flag f : flag) {
            if (this.hasFlag(f)) {
                return false;
            }
            this.FLAGS.add(f.clone());
        }
        return true;
    }

    public boolean addMember(OfflinePlayer p) {
        if (this.isMember(p)) {
            return false;
        }
        return this.MEMBERS.add(p.getUniqueId());
    }

    public boolean addMember(OfflinePlayer ... p) {
        for (OfflinePlayer op : p) {
            if (this.addMember(op)) continue;
            return false;
        }
        return true;
    }

    public boolean removeMember(OfflinePlayer p) {
        if (!this.isMember(p)) {
            return false;
        }
        return this.MEMBERS.remove(p.getUniqueId());
    }

    public boolean removeFlag(Cuboid.Flag ... flag) {
        for (Cuboid.Flag fl : flag) {
            if (this.FLAGS.removeIf(f -> f.getId().equals(fl.getId()))) continue;
            return false;
        }
        return true;
    }

    public boolean removeMember(OfflinePlayer ... p) {
        for (OfflinePlayer op : p) {
            if (this.removeMember(op)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Block block) {
        return block.getWorld() == this.location.getWorld() && block.getX() >= this.axis.getxMin() && block.getX() <= this.axis.getxMax() && block.getY() >= this.axis.getyMin() && block.getY() <= this.axis.getyMax() && block.getZ() >= this.axis.getzMin() && block.getZ() <= this.axis.getzMax();
    }

    public boolean contains(Location loc) {
        return loc.getWorld() == this.location.getWorld() && loc.getBlockX() >= this.axis.getxMin() && loc.getBlockX() <= this.axis.getxMax() && loc.getBlockY() >= this.axis.getyMin() && loc.getBlockY() <= this.axis.getyMax() && loc.getBlockZ() >= this.axis.getzMin() && loc.getBlockZ() <= this.axis.getzMax();
    }

    public boolean contains(Player player) {
        return this.contains(player.getLocation());
    }

    public boolean contains(Block b, double precision) {
        return this.contains(b.getLocation(), precision);
    }

    public boolean contains(Player p, double precision) {
        return this.contains(p.getLocation(), precision);
    }

    public boolean contains(Location loc, double precision) {
        return loc.getWorld() == this.location.getWorld() && loc.getX() >= (double)this.axis.getxMin() + 0.5 - precision && loc.getX() <= (double)this.axis.getxMax() + 0.5 + precision && loc.getY() >= (double)this.axis.getyMin() + 0.5 - precision && loc.getY() <= (double)this.axis.getyMax() + 0.5 + precision && loc.getZ() >= (double)this.axis.getzMin() + 0.5 - precision && loc.getZ() <= (double)this.axis.getzMax() + 0.5 + precision;
    }

    public final boolean remove() {
        return RegionServicesManager.getInstance().unload(this);
    }

    public final boolean load() {
        return RegionServicesManager.getInstance().load(this);
    }

    public final Region clone() {
        return new Region((Cuboid)this){};
    }

    public static class Resident {
        public static final List<Resident> LIST = new ArrayList<Resident>();
        private final OfflinePlayer p;
        private boolean spawnTagged;
        private boolean pastSpawn;

        protected Resident(OfflinePlayer player) {
            this.p = player;
            LIST.add(this);
        }

        public static Resident get(OfflinePlayer player) {
            for (Resident resident : LIST) {
                if (!resident.getPlayer().equals(player)) continue;
                return resident;
            }
            Resident r = new Resident(player);
            LIST.add(r);
            return r;
        }

        public OfflinePlayer getPlayer() {
            return this.p;
        }

        public Player getOnline() {
            return this.getPlayer().getPlayer();
        }

        public Optional<Region> getRegion() {
            if (this.getPlayer().isOnline()) {
                return CompletableFuture.supplyAsync(() -> Optional.ofNullable(this.getPlayer()).map(OfflinePlayer::getPlayer).map(Entity::getLocation).flatMap(location -> Optional.ofNullable(RegionServicesManager.getInstance().get((Location)location)))).join();
            }
            return Optional.empty();
        }

        public boolean isSpawnTagged() {
            return this.spawnTagged;
        }

        public boolean isPastSpawn() {
            return this.pastSpawn;
        }

        public void setPastSpawn(boolean pastSpawn) {
            this.pastSpawn = pastSpawn;
        }

        public void setSpawnTagged(boolean spawnTagged) {
            this.spawnTagged = spawnTagged;
        }
    }
}

