/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.container.CollectionTask;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.labyrinth.library.TimeWatch;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.util.ProgressBar;
import com.github.sanctum.panther.util.RandomID;
import java.text.NumberFormat;

final class PantherCollectionMergeProcess<T>
extends CollectionTask<T> {
    private static final long serialVersionUID = -4311490730088594915L;
    PantherCollection<T> collector;
    PantherCollection<T> child;
    int index = 0;
    int limit;
    long started = 0L;
    long lastRan = 0L;
    String table;
    T current;

    PantherCollectionMergeProcess(PantherCollection<T> collector, PantherCollection<T> child, int processLimit, String table) {
        super(new RandomID().generate());
        this.collector = collector;
        this.child = child;
        this.limit = processLimit;
        this.table = table;
    }

    @Override
    public double getCompletion() {
        return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.child.size()).getPercentage());
    }

    @Override
    public long getTimeStarted() {
        return this.started;
    }

    @Override
    public long getRecentExecution() {
        return this.lastRan;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.child.size();
    }

    @Override
    public boolean hasNext(int bounds) {
        return this.index + bounds < this.child.size();
    }

    @Override
    @Ordinal
    public T next() {
        return this.next(this.limit);
    }

    @Override
    @Ordinal(value=1)
    public T next(int bounds) {
        int processed = 0;
        if (this.isPaused()) {
            return this.current;
        }
        if (this.index < this.child.size()) {
            if (this.started == 0L) {
                this.started = System.currentTimeMillis();
            }
            this.lastRan = System.currentTimeMillis();
            for (int i = this.index; i < this.child.size(); ++i) {
                if (processed > bounds) continue;
                T o = this.child.get(i);
                this.current = o;
                this.collector.add(o);
                ++this.index;
                ++processed;
            }
            LabyrinthProvider.getInstance().getLogger().info("- Queable collection process " + this.table + ";MERGE @ " + this.correctDecimal(NumberFormat.getNumberInstance().format(this.getCompletion())) + "% ");
            return this.current;
        }
        TimeWatch.Recording recording = TimeWatch.Recording.subtract(this.started);
        LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- &aTask " + this.table + " completed after " + recording.getHours() + " hours " + recording.getMinutes() + " minutes & " + recording.getSeconds() + " seconds.").translate());
        LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- &aSize b match of a (" + this.child.size() + " vs " + this.collector.size() + ")").translate());
        this.cancel();
        return this.current;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.started = 0L;
        this.lastRan = 0L;
        this.current = null;
    }
}

