/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.data.container.LabyrinthAtlasMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.file.Generic;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.file.Primitive;
import com.github.sanctum.panther.util.MapDecompression;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class LabyrinthAtlasNode
implements Node,
Primitive {
    private final LabyrinthAtlasMap MAP;
    private final String key;

    public LabyrinthAtlasNode(@NotNull String key, @NotNull LabyrinthAtlasMap parent) {
        if (key == null) {
            LabyrinthAtlasNode.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            LabyrinthAtlasNode.$$$reportNull$$$0(1);
        }
        this.key = key;
        this.MAP = parent;
    }

    @Override
    public Object get() {
        return this.MAP.get(this.key);
    }

    @Override
    public Primitive toPrimitive() {
        return this;
    }

    @Override
    public <T extends Generic> T toGeneric(@NotNull Class<T> clazz) {
        if (clazz == null) {
            LabyrinthAtlasNode.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type) {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!type.isAssignableFrom(o.getClass())) {
            return null;
        }
        return (T)o;
    }

    @Override
    public void set(Object o) {
        this.MAP.put(this.key, o);
    }

    @Override
    public Node getParent() {
        String[] k = this.key.split(this.MAP.dividerAdapt());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < k.length - 1; ++i) {
            builder.append(k[i]).append(this.MAP.divider);
        }
        String key = builder.toString();
        if (key.endsWith(this.MAP.divider + "")) {
            key = key.substring(0, builder.length() - 1);
        }
        if (key.equals(this.key)) {
            return this;
        }
        return this.getNode(key);
    }

    @Override
    public String toJson() {
        Gson g = new GsonBuilder().create();
        return g.toJson(this.get());
    }

    @Override
    public String getPath() {
        return this.key;
    }

    @Override
    public boolean isNode(String node) {
        return this.MAP.isNode(this.key + this.MAP.divider + node);
    }

    @Override
    public Node getNode(String node) {
        return (Node)Optional.ofNullable(this.MAP.QUERY.get(this.key + this.MAP.divider + node)).orElseGet(() -> {
            LabyrinthAtlasNode n = new LabyrinthAtlasNode(this.key + this.MAP.divider + node, this.MAP);
            this.MAP.QUERY.put(this.key + this.MAP.divider + node, n);
            return n;
        });
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        HashSet<String> keys = new HashSet<String>();
        if (this.get() instanceof PantherMap) {
            PantherMap map1 = (PantherMap)this.get();
            if (deep) {
                return MapDecompression.getInstance().decompress(map1, this.MAP.divider, null).toSet();
            }
            for (Map.Entry entry : map1.entries()) {
                keys.add((String)entry.getKey());
            }
        } else {
            keys.add(this.key);
        }
        return keys;
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.get() instanceof PantherMap) {
            PantherMap map1 = (PantherMap)this.get();
            if (deep) {
                return MapDecompression.getInstance().decompress(map1, this.MAP.divider, null).toMap();
            }
            for (Map.Entry entry : map1.entries()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            map.put(this.key, this.get());
        }
        return map;
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public boolean delete() {
        this.MAP.put(this.key, (Object)null);
        return true;
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean create() {
        return false;
    }

    @Override
    public boolean exists() {
        return this.MAP.getKeys(true).contains(this.key);
    }

    @Override
    public String getString() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            return null;
        }
        return (String)o;
    }

    @Override
    public int getInt() {
        Object o = this.get();
        if (o == null) {
            return 0;
        }
        if (!(o instanceof Integer)) {
            return 0;
        }
        return (Integer)o;
    }

    @Override
    public boolean getBoolean() {
        Object o = this.get();
        if (o == null) {
            return false;
        }
        if (!(o instanceof Boolean)) {
            return false;
        }
        return (Boolean)o;
    }

    @Override
    public double getDouble() {
        Object o = this.get();
        if (o == null) {
            return 0.0;
        }
        if (!(o instanceof Double) && !(o instanceof Integer)) {
            return 0.0;
        }
        return (Double)o;
    }

    @Override
    public float getFloat() {
        Object o = this.get();
        if (o == null) {
            return 0.0f;
        }
        if (!(o instanceof Double) && !(o instanceof Float)) {
            return 0.0f;
        }
        return ((Float)o).floatValue();
    }

    @Override
    public long getLong() {
        Object o = this.get();
        if (o == null) {
            return 0L;
        }
        if (!(o instanceof Long) && !(o instanceof Integer)) {
            return 0L;
        }
        return (Long)o;
    }

    @Override
    public List<?> getList() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        return (List)o;
    }

    @Override
    public Map<?, ?> getMap() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof Map)) {
            return null;
        }
        return (HashMap)o;
    }

    @Override
    public List<String> getStringList() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        if (!((List)o).isEmpty() && !(((List)o).get(0) instanceof String)) {
            return null;
        }
        return (List)o;
    }

    @Override
    public List<Integer> getIntegerList() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        if (!((List)o).isEmpty() && !(((List)o).get(0) instanceof Integer)) {
            return null;
        }
        return (List)o;
    }

    @Override
    public List<Double> getDoubleList() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        if (!((List)o).isEmpty() && !(((List)o).get(0) instanceof Double)) {
            return null;
        }
        return (List)o;
    }

    @Override
    public List<Float> getFloatList() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        if (!((List)o).isEmpty() && !(((List)o).get(0) instanceof Float)) {
            return null;
        }
        return (List)o;
    }

    @Override
    public List<Long> getLongList() {
        Object o = this.get();
        if (o == null) {
            return null;
        }
        if (!(o instanceof List)) {
            return null;
        }
        if (!((List)o).isEmpty() && !(((List)o).get(0) instanceof Long)) {
            return null;
        }
        return (List)o;
    }

    @Override
    public boolean isString() {
        return this.getString() != null;
    }

    @Override
    public boolean isBoolean() {
        return this.get() instanceof Boolean;
    }

    @Override
    public boolean isInt() {
        return this.get() instanceof Integer;
    }

    @Override
    public boolean isDouble() {
        return this.get() instanceof Double;
    }

    @Override
    public boolean isFloat() {
        return this.get() instanceof Float;
    }

    @Override
    public boolean isLong() {
        return this.get() instanceof Long;
    }

    @Override
    public boolean isList() {
        return this.get() instanceof List;
    }

    @Override
    public boolean isStringList() {
        return this.getStringList() != null && !this.getStringList().isEmpty();
    }

    @Override
    public boolean isFloatList() {
        return this.getFloatList() != null && !this.getFloatList().isEmpty();
    }

    @Override
    public boolean isDoubleList() {
        return this.getDoubleList() != null && !this.getDoubleList().isEmpty();
    }

    @Override
    public boolean isIntegerList() {
        return this.getIntegerList() != null && !this.getIntegerList().isEmpty();
    }

    @Override
    public boolean isLongList() {
        return this.getLongList() != null && !this.getLongList().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/data/container/LabyrinthAtlasNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toGeneric";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

