/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.data.container.LabyrinthAtlas;
import com.github.sanctum.labyrinth.data.container.LabyrinthAtlasNode;
import com.github.sanctum.panther.container.PantherEntry;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.util.MapDecompression;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabyrinthAtlasMap
implements LabyrinthAtlas {
    protected final PantherMap<String, Object> SOURCE = new PantherEntryMap<String, Object>();
    protected final PantherMap<String, MemorySpace> QUERY = new PantherEntryMap<String, MemorySpace>();
    protected final char divider;

    public LabyrinthAtlasMap() {
        this.divider = (char)46;
    }

    public LabyrinthAtlasMap(char divider) {
        this.divider = divider;
    }

    String dividerAdapt() {
        return this.divider == '.' ? "[" + this.divider + "]" : this.divider + "";
    }

    @Override
    public boolean isNode(String key) {
        String[] a = key.split(this.dividerAdapt());
        String k = a[Math.max(0, a.length - 1)];
        PantherMap o = this.SOURCE;
        for (int i = 0; i < a.length - 1; ++i) {
            String pathKey = a[i];
            Object obj = o.get((String)pathKey);
            if (!(obj instanceof Map)) continue;
            PantherMap js = (PantherMap)obj;
            if (js.containsKey(k)) {
                return js.get(k) instanceof PantherMap;
            }
            o = js;
        }
        return o.get((String)k) instanceof Map;
    }

    @Override
    public Node getNode(String key) {
        return (Node)this.QUERY.entries().stream().filter(e -> ((String)e.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElseGet(() -> {
            LabyrinthAtlasNode n = new LabyrinthAtlasNode(key, this);
            this.QUERY.put(key, n);
            return n;
        });
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        HashSet<String> keys = new HashSet<String>();
        this.SOURCE.forEach(e -> {
            if (deep) {
                if (e.getValue() instanceof PantherMap) {
                    MapDecompression.getInstance().decompress((PantherMap)e.getValue(), this.divider, null).toPantherSet().forEach(keys::add);
                } else {
                    keys.add((String)e.getKey());
                }
            } else {
                keys.add((String)e.getKey());
            }
        });
        return keys;
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.SOURCE.forEach(e -> {
            if (deep) {
                if (e.getValue() instanceof PantherMap) {
                    MapDecompression.getInstance().decompress((PantherMap)e.getValue(), this.divider, null).toPantherMap().forEach(ev -> map.put((String)ev.getKey(), ev.getValue()));
                } else {
                    map.put((String)e.getKey(), e.getValue());
                }
            } else {
                map.put((String)e.getKey(), e.getValue());
            }
        });
        return map;
    }

    @Override
    public int size() {
        return this.getValues(true).size();
    }

    @Override
    public boolean isEmpty() {
        return this.SOURCE.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Object get(String key) {
        String[] a = key.split(this.dividerAdapt());
        String k = a[Math.max(0, a.length - 1)];
        PantherMap o = this.SOURCE;
        for (int i = 0; i < a.length - 1; ++i) {
            PantherMap js;
            String pathKey = a[i];
            Object obj = o.get((String)pathKey);
            if (obj instanceof Map) {
                js = (PantherMap)obj;
                if (js.containsKey(k)) {
                    return js.get(k);
                }
            } else {
                return obj;
            }
            o = js;
        }
        return o.get((String)k);
    }

    @Override
    @Nullable
    public Object put(String key, Object o) {
        String[] a = key.split(this.dividerAdapt());
        String k = a[Math.max(0, a.length - 1)];
        PantherMap ob = this.SOURCE;
        for (int i = 0; i < a.length - 1; ++i) {
            String pathKey = a[i];
            Object os = ob.get((String)pathKey);
            if (os instanceof PantherMap) {
                ob = (PantherMap)os;
                continue;
            }
            PantherEntryMap n = new PantherEntryMap();
            ob.put(pathKey, n);
            ob = (PantherMap)ob.get(pathKey);
        }
        if (o == null) {
            ob.remove((String)k);
            this.QUERY.remove(k);
            return null;
        }
        ob.put((String)k, (Object)o);
        return o;
    }

    @Override
    public boolean putAll(Iterable<Map.Entry<String, Object>> iterable) {
        return this.SOURCE.putAll(iterable);
    }

    @Override
    public boolean remove(String key) {
        return this.SOURCE.remove(key);
    }

    @Override
    public boolean removeAll(Iterable<Map.Entry<String, Object>> iterable) {
        return this.SOURCE.removeAll(iterable);
    }

    @Override
    public void clear() {
        this.SOURCE.clear();
    }

    @Override
    @NotNull
    public Iterator<PantherEntry.Modifiable<String, Object>> iterator() {
        Iterator<PantherEntry.Modifiable<String, Object>> iterator = this.SOURCE.iterator();
        if (iterator == null) {
            LabyrinthAtlasMap.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    public char getDivider() {
        return this.divider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/data/container/LabyrinthAtlasMap", "iterator"));
    }
}

