/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.AddonLoader;
import com.github.sanctum.labyrinth.data.FileList;
import com.github.sanctum.labyrinth.data.RegistryData;
import com.github.sanctum.panther.annotation.Note;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;

public class Registry<T> {
    private final Class<T> type;
    private Predicate<? super String> filter;
    private Object handle = null;
    private String PACKAGE;

    public Registry(Class<T> cl) {
        this.type = cl;
    }

    public static <T> Registry<T> use(Class<T> cl) {
        return new Registry<T>(cl);
    }

    public Registry<T> source(Object loader) {
        this.handle = loader;
        return this;
    }

    public Registry<T> filter(String packageName) {
        this.PACKAGE = packageName;
        return this;
    }

    public Registry<T> filter(Predicate<? super String> predicate) {
        this.filter = predicate;
        return this;
    }

    public RegistryData<T> confine() {
        HashSet classes = Sets.newHashSet();
        JarFile jarFile = null;
        if (this.handle != null) {
            try {
                jarFile = new JarFile(URLDecoder.decode(this.handle.getClass().getProtectionDomain().getCodeSource().getLocation().getFile(), String.valueOf(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (jarFile == null) {
            throw new IllegalStateException("Invalid jar file");
        }
        Stream<JarEntry> entries = jarFile.stream();
        if (this.filter != null) {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.filter.test(className)) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        } else {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.PACKAGE != null) {
                    if (className.startsWith(this.PACKAGE) && className.endsWith(".class")) {
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName(substring);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (clazz != null && this.type.isAssignableFrom(clazz)) {
                            classes.add(clazz);
                        }
                    }
                } else if (className.endsWith(".class")) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        }
        LinkedList additions = new LinkedList();
        for (Class aClass : classes) {
            try {
                Object a = aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                additions.add(a);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                break;
            }
        }
        return new RegistryData(additions, this.handle, this.PACKAGE);
    }

    public RegistryData<T> construct(Object ... args) {
        HashSet classes = Sets.newHashSet();
        JarFile jarFile = null;
        if (this.handle != null) {
            try {
                jarFile = new JarFile(URLDecoder.decode(this.handle.getClass().getProtectionDomain().getCodeSource().getLocation().getFile(), String.valueOf(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (jarFile == null) {
            throw new IllegalStateException("Invalid jar file");
        }
        Stream<JarEntry> entries = jarFile.stream();
        if (this.filter != null) {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.filter.test(className)) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        } else {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.PACKAGE != null) {
                    if (className.startsWith(this.PACKAGE) && className.endsWith(".class")) {
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName(substring);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (clazz != null && this.type.isAssignableFrom(clazz)) {
                            classes.add(clazz);
                        }
                    }
                } else if (className.endsWith(".class")) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        }
        Constructor<?> constructor = null;
        block4: for (Constructor<?> con : this.type.getConstructors()) {
            if (args.length != con.getParameters().length) continue;
            int success = 0;
            for (int i = 0; i < args.length; ++i) {
                Class<?> typeClass;
                Class<?> objectClass = args[i].getClass();
                if (objectClass.isAssignableFrom(typeClass = con.getParameters()[i].getType())) {
                    ++success;
                }
                if (success != args.length) continue;
                constructor = con;
                continue block4;
            }
        }
        LinkedList additions = new LinkedList();
        for (Class aClass : classes) {
            try {
                Object a = constructor != null ? aClass.getDeclaredConstructor(constructor.getParameterTypes()).newInstance(args) : aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                additions.add(a);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                break;
            }
        }
        return new RegistryData(additions, this.handle, this.PACKAGE);
    }

    public RegistryData<T> construct(Consumer<T> operation, Object ... args) {
        HashSet classes = Sets.newHashSet();
        JarFile jarFile = null;
        if (this.handle != null) {
            try {
                jarFile = new JarFile(URLDecoder.decode(this.handle.getClass().getProtectionDomain().getCodeSource().getLocation().getFile(), String.valueOf(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (jarFile == null) {
            throw new IllegalStateException("Invalid jar file");
        }
        Stream<JarEntry> entries = jarFile.stream();
        if (this.filter != null) {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.filter.test(className)) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        } else {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.PACKAGE != null) {
                    if (className.startsWith(this.PACKAGE) && className.endsWith(".class")) {
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName(substring);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (clazz != null && this.type.isAssignableFrom(clazz)) {
                            classes.add(clazz);
                        }
                    }
                } else if (className.endsWith(".class")) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        }
        Constructor<?> constructor = null;
        block4: for (Constructor<?> con : this.type.getConstructors()) {
            if (args.length != con.getParameters().length) continue;
            int success = 0;
            for (int i = 0; i < args.length; ++i) {
                Class<?> typeClass;
                Class<?> objectClass = args[i].getClass();
                if (objectClass.isAssignableFrom(typeClass = con.getParameters()[i].getType())) {
                    ++success;
                }
                if (success != args.length) continue;
                constructor = con;
                continue block4;
            }
        }
        LinkedList additions = new LinkedList();
        for (Class aClass : classes) {
            try {
                Object a = constructor != null ? aClass.getDeclaredConstructor(constructor.getParameterTypes()).newInstance(args) : aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                operation.accept(a);
                additions.add(a);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                break;
            }
        }
        return new RegistryData(additions, this.handle, this.PACKAGE);
    }

    public RegistryData<T> operate(Consumer<T> operation) {
        HashSet classes = Sets.newHashSet();
        JarFile jarFile = null;
        if (this.handle != null) {
            try {
                jarFile = new JarFile(URLDecoder.decode(this.handle.getClass().getProtectionDomain().getCodeSource().getLocation().getFile(), String.valueOf(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new IllegalStateException("Directory not valid", e);
            }
        }
        if (jarFile == null) {
            throw new IllegalStateException("Invalid jar file");
        }
        Stream<JarEntry> entries = jarFile.stream();
        if (this.filter != null) {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.filter.test(className)) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        } else {
            entries.forEach(entry -> {
                String className = entry.getName().replace("/", ".");
                String substring = className.substring(0, Math.max(className.length() - 6, 0));
                if (this.PACKAGE != null) {
                    if (className.startsWith(this.PACKAGE) && className.endsWith(".class")) {
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName(substring);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (clazz != null && this.type.isAssignableFrom(clazz)) {
                            classes.add(clazz);
                        }
                    }
                } else if (className.endsWith(".class")) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(substring);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz != null && this.type.isAssignableFrom(clazz)) {
                        classes.add(clazz);
                    }
                }
            });
        }
        LinkedList additions = new LinkedList();
        for (Class aClass : classes) {
            try {
                Object a = aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                operation.accept(a);
                additions.add(a);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                break;
            }
        }
        return new RegistryData(additions, this.handle, this.PACKAGE);
    }

    public static class Loader<T> {
        private final Class<T> type;
        private AddonLoader loader;
        private Plugin plugin;
        private String directory;

        public Loader(Class<T> type) {
            this.type = type;
        }

        public Loader<T> source(Plugin plugin) {
            this.plugin = plugin;
            return this;
        }

        public Loader<T> from(String directory) {
            this.directory = directory;
            return this;
        }

        @Note(value="New! Unload all classes relative to this loader.")
        public @Note(value="New! Unload all classes relative to this loader.") boolean unravel() {
            if (this.loader != null) {
                try {
                    return this.loader.unload(FileList.search(this.plugin).get("dummy", this.directory).getRoot().getParent().getParentFile().getPath());
                }
                catch (ClassNotFoundException e) {
                    LabyrinthProvider.getInstance().getLogger().severe("Unable to unload classes for path '" + this.directory + "'");
                }
            }
            return false;
        }

        public RegistryData<T> confine() {
            File file = FileList.search(this.plugin).get("dummy", this.directory).getRoot().getParent().getParentFile();
            AddonLoader l = this.loader != null ? this.loader : (this.loader = AddonLoader.newInstance(this.plugin));
            List<Class<?>> classes = l.loadFolder(file);
            LinkedList data = new LinkedList();
            for (Class<?> cl : classes) {
                if (!this.type.isAssignableFrom(cl)) continue;
                try {
                    Object e = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    data.add(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return new RegistryData(data, this.plugin, this.directory);
        }

        public RegistryData<T> confine(Consumer<T> action) {
            File file = FileList.search(this.plugin).get("dummy", this.directory).getRoot().getParent().getParentFile();
            AddonLoader l = this.loader != null ? this.loader : (this.loader = AddonLoader.newInstance(this.plugin));
            List<Class<?>> classes = l.loadFolder(file);
            LinkedList data = new LinkedList();
            for (Class<?> cl : classes) {
                if (!this.type.isAssignableFrom(cl)) continue;
                try {
                    Object e = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    action.accept(e);
                    data.add(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return new RegistryData(data, this.plugin, this.directory);
        }

        public RegistryData<T> construct(Object ... o) {
            File file = FileList.search(this.plugin).get("dummy", this.directory).getRoot().getParent().getParentFile();
            AddonLoader l = this.loader != null ? this.loader : (this.loader = AddonLoader.newInstance(this.plugin));
            List<Class<?>> classes = l.loadFolder(file);
            LinkedList data = new LinkedList();
            Constructor<?> constructor = null;
            block2: for (Constructor<?> con : this.type.getConstructors()) {
                if (o.length != con.getParameters().length) continue;
                int success = 0;
                for (int i = 0; i < o.length; ++i) {
                    Class<?> typeClass;
                    Class<?> objectClass = o[i].getClass();
                    if (objectClass.isAssignableFrom(typeClass = con.getParameters()[i].getType())) {
                        ++success;
                    }
                    if (success != o.length) continue;
                    constructor = con;
                    continue block2;
                }
            }
            for (Class clazz : classes) {
                if (!this.type.isAssignableFrom(clazz)) continue;
                try {
                    Object e = constructor != null ? clazz.getDeclaredConstructor(constructor.getParameterTypes()).newInstance(o) : clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    data.add(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return new RegistryData(data, this.plugin, this.directory);
        }

        public RegistryData<T> construct(Consumer<T> action, Object ... o) {
            File file = FileList.search(this.plugin).get("dummy", this.directory).getRoot().getParent().getParentFile();
            AddonLoader l = this.loader != null ? this.loader : (this.loader = AddonLoader.newInstance(this.plugin));
            List<Class<?>> classes = l.loadFolder(file);
            LinkedList data = new LinkedList();
            Constructor<?> constructor = null;
            block2: for (Constructor<?> con : this.type.getConstructors()) {
                if (o.length != con.getParameters().length) continue;
                int success = 0;
                for (int i = 0; i < o.length; ++i) {
                    Class<?> typeClass;
                    Class<?> objectClass = o[i].getClass();
                    if (objectClass.isAssignableFrom(typeClass = con.getParameters()[i].getType())) {
                        ++success;
                    }
                    if (success != o.length) continue;
                    constructor = con;
                    continue block2;
                }
            }
            for (Class clazz : classes) {
                if (!this.type.isAssignableFrom(clazz)) continue;
                try {
                    Object e = constructor != null ? clazz.getDeclaredConstructor(constructor.getParameterTypes()).newInstance(o) : clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    action.accept(e);
                    data.add(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return new RegistryData(data, this.plugin, this.directory);
        }
    }
}

