/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.Labyrinth;
import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.CuboidSelection;
import com.github.sanctum.labyrinth.data.FlagManager;
import com.github.sanctum.labyrinth.data.RegionServicesManager;
import com.github.sanctum.labyrinth.data.container.Region;
import com.github.sanctum.labyrinth.event.CuboidSelectEvent;
import com.github.sanctum.labyrinth.event.DefaultEvent;
import com.github.sanctum.labyrinth.event.LabyrinthVentCall;
import com.github.sanctum.labyrinth.event.RegionBuildEvent;
import com.github.sanctum.labyrinth.event.RegionDestroyEvent;
import com.github.sanctum.labyrinth.event.RegionInteractionEvent;
import com.github.sanctum.labyrinth.event.RegionPVPEvent;
import com.github.sanctum.labyrinth.library.Items;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.container.ImmutablePantherCollection;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.event.Vent;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;

public final class RegionServicesManagerImpl
extends RegionServicesManager {
    final PantherCollection<Region> cache = new PantherList<Region>();
    final FlagManager flagManager = new FlagManager(this);
    private ItemStack wand = new ItemStack(Material.STICK);

    public static void initialize(Labyrinth instance) {
        RegionServicesManagerImpl servicesManager = new RegionServicesManagerImpl();
        Bukkit.getServicesManager().register(RegionServicesManager.class, (Object)servicesManager, (Plugin)instance, ServicePriority.Normal);
        instance.getEventMap().subscribe(new Vent.Subscription<DefaultEvent.BlockBreak>(DefaultEvent.BlockBreak.class, instance, Vent.Priority.HIGH, (e, subscription) -> {
            RegionDestroyEvent event;
            Optional r = CompletableFuture.supplyAsync(() -> Optional.ofNullable(RegionServicesManagerImpl.getInstance().get(e.getBlock().getLocation()))).join();
            if (r.isPresent() && (event = (RegionDestroyEvent)new LabyrinthVentCall<RegionDestroyEvent>(new RegionDestroyEvent(e.getPlayer(), (Region)r.get(), e.getBlock())).run()).isCancelled()) {
                e.setCancelled(true);
            }
        }));
        instance.getEventMap().subscribe(new Vent.Subscription<DefaultEvent.BlockPlace>(DefaultEvent.BlockPlace.class, instance, Vent.Priority.HIGH, (e, subscription) -> {
            RegionBuildEvent event;
            Optional r = CompletableFuture.supplyAsync(() -> Optional.ofNullable(RegionServicesManagerImpl.getInstance().get(e.getBlock().getLocation()))).join();
            if (r.isPresent() && (event = (RegionBuildEvent)new LabyrinthVentCall<RegionBuildEvent>(new RegionBuildEvent(e.getPlayer(), (Region)r.get(), e.getBlock())).run()).isCancelled()) {
                e.setCancelled(true);
            }
        }));
        instance.getEventMap().subscribe(new Vent.Subscription<DefaultEvent.Join>(DefaultEvent.Join.class, "region-spawn", instance, Vent.Priority.MEDIUM, (event, subscription) -> {
            Region.Resident r = Region.Resident.get((OfflinePlayer)event.getPlayer());
            if (!event.getPlayer().hasPlayedBefore()) {
                TaskScheduler.of(() -> {
                    Region region = RegionServicesManagerImpl.getInstance().get("spawn");
                    if (region != null) {
                        r.setSpawnTagged(true);
                        r.setPastSpawn(false);
                    }
                }).scheduleLater(2L);
            } else {
                r.setSpawnTagged(false);
            }
        }));
        instance.getEventMap().subscribe(new Vent.Subscription<DefaultEvent.Interact>(DefaultEvent.Interact.class, "region-interact", instance, Vent.Priority.MEDIUM, (e, subscription) -> {
            RegionInteractionEvent event;
            Optional r;
            if (e.getAction() == Action.LEFT_CLICK_BLOCK) {
                r = CompletableFuture.supplyAsync(() -> e.getBlock().map(Block::getLocation).flatMap(location -> Optional.ofNullable(RegionServicesManagerImpl.getInstance().get((Location)location)))).join();
                if (r.isPresent() && (event = (RegionInteractionEvent)new LabyrinthVentCall<RegionInteractionEvent>(new RegionInteractionEvent(e.getPlayer(), (Region)r.get(), e.getBlock().get(), RegionInteractionEvent.ClickType.LEFT)).run()).isCancelled()) {
                    e.setCancelled(true);
                }
                if (e.getItem() == null) {
                    return;
                }
                if (!e.getPlayer().hasPermission("labyrinth.selection")) {
                    return;
                }
                CuboidSelection selection = CuboidSelection.get(e.getPlayer());
                if (e.getItem().getType() == selection.getWand().getType()) {
                    if (e.getResult() != Event.Result.DENY) {
                        e.setResult(Event.Result.DENY);
                    }
                    selection.setPos1(e.getBlock().get().getLocation());
                    new LabyrinthVentCall<1>(new CuboidSelectEvent(selection){}).run();
                }
            }
            if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                r = CompletableFuture.supplyAsync(() -> e.getBlock().map(Block::getLocation).flatMap(location -> Optional.ofNullable(RegionServicesManagerImpl.getInstance().get((Location)location)))).join();
                if (r.isPresent() && (event = (RegionInteractionEvent)new LabyrinthVentCall<RegionInteractionEvent>(new RegionInteractionEvent(e.getPlayer(), (Region)r.get(), e.getBlock().get(), RegionInteractionEvent.ClickType.RIGHT)).run()).isCancelled()) {
                    e.setCancelled(true);
                }
                if (e.getItem() == null) {
                    return;
                }
                if (!e.getPlayer().hasPermission("labyrinth.selection")) {
                    return;
                }
                boolean isOld = LabyrinthProvider.getInstance().isLegacy();
                Material mat = Items.findMaterial("WOODEN_AXE");
                if (isOld) {
                    mat = Items.findMaterial("WOOD_AXE");
                }
                if (e.getItem().getType() == mat) {
                    CuboidSelection selection = CuboidSelection.get(e.getPlayer());
                    if (e.getResult() != Event.Result.DENY) {
                        e.setResult(Event.Result.DENY);
                    }
                    selection.setPos2(e.getBlock().get().getLocation());
                    new LabyrinthVentCall<2>(new CuboidSelectEvent(selection){}).run();
                }
            }
        }));
        instance.getEventMap().subscribe(new Vent.Subscription<DefaultEvent.PlayerDamagePlayer>(DefaultEvent.PlayerDamagePlayer.class, "region-pvp", instance, Vent.Priority.MEDIUM, (event, subscription) -> {
            Region region;
            RegionPVPEvent e;
            Player p = event.getPlayer();
            Player target = event.getVictim();
            Region.Resident r = Region.Resident.get((OfflinePlayer)target);
            if (event.isPhysical()) {
                Region region2;
                RegionPVPEvent e2;
                if (r.getRegion().isPresent() && (e2 = (RegionPVPEvent)new LabyrinthVentCall<RegionPVPEvent>(new RegionPVPEvent(p, target, region2 = r.getRegion().get())).run()).isCancelled()) {
                    event.setCancelled(true);
                }
            } else if (r.getRegion().isPresent() && (e = (RegionPVPEvent)new LabyrinthVentCall<RegionPVPEvent>(new RegionPVPEvent(p, target, region = r.getRegion().get())).run()).isCancelled()) {
                event.setCancelled(true);
            }
        }));
    }

    @Override
    public PantherCollection<Region> getAll() {
        return ImmutablePantherCollection.of(this.cache);
    }

    @Override
    public Region get(@NotNull Location location) {
        if (location == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(0);
        }
        return this.cache.stream().filter(region -> region.contains(location)).findFirst().orElse(null);
    }

    @Override
    public Region get(@NotNull Player player) {
        if (player == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(1);
        }
        return this.cache.stream().filter(region -> region.contains(player)).findFirst().orElse(null);
    }

    @Override
    public Region get(@NotNull String name) {
        if (name == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(2);
        }
        return this.cache.stream().filter(region -> region.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public Region get(@NotNull Location location, boolean passthrough) {
        if (location == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(3);
        }
        return this.cache.stream().filter(region -> region.contains(location) && region.isDominant() == passthrough).findFirst().orElse(null);
    }

    @Override
    public Region get(@NotNull Player player, boolean passthrough) {
        if (player == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(4);
        }
        return this.cache.stream().filter(region -> region.contains(player) && region.isDominant() == passthrough).findFirst().orElse(null);
    }

    @Override
    public Region get(@NotNull String name, boolean passthrough) {
        if (name == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(5);
        }
        return this.cache.stream().filter(region -> region.getName().equals(name) && region.isDominant() == passthrough).findFirst().orElse(null);
    }

    @Override
    public boolean load(@NotNull Region region) {
        if (region == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.cache.contains(region)) {
            return false;
        }
        return this.cache.add(region);
    }

    @Override
    public boolean unload(@NotNull Region region) {
        if (region == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(7);
        }
        if (!this.cache.contains(region)) {
            return false;
        }
        return this.cache.remove(region);
    }

    @Override
    public FlagManager getFlagManager() {
        return this.flagManager;
    }

    @Override
    public ItemStack getWand() {
        return this.wand;
    }

    @Override
    public void setWand(@NotNull ItemStack itemStack) {
        if (itemStack == null) {
            RegionServicesManagerImpl.$$$reportNull$$$0(8);
        }
        this.wand = itemStack;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemStack";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/data/RegionServicesManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "unload";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setWand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

