/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.Node;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;

@Node.Pointer(value="org.bukkit.Location")
public final class LocationSerializable
implements JsonAdapter<Location> {
    @Override
    public JsonElement write(Location l) {
        JsonObject o = new JsonObject();
        o.addProperty("x", (Number)l.getX());
        o.addProperty("y", (Number)l.getY());
        o.addProperty("z", (Number)l.getZ());
        o.addProperty("yaw", (Number)Float.valueOf(l.getYaw()));
        o.addProperty("pitch", (Number)Float.valueOf(l.getPitch()));
        o.addProperty("world", l.getWorld().getName());
        return o;
    }

    @Override
    public Location read(Map<String, Object> o) {
        String world = (String)o.get("world");
        double x = (Double)o.get("x");
        double y = (Double)o.get("y");
        double z = (Double)o.get("z");
        float yaw = (float)((Double)o.get("yaw")).doubleValue();
        float pitch = (float)((Double)o.get("pitch")).doubleValue();
        return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }

    @Override
    public Class<Location> getSerializationSignature() {
        return Location.class;
    }
}

