/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.data.BukkitGeneric;
import com.github.sanctum.labyrinth.data.DataTable;
import com.github.sanctum.labyrinth.data.FileList;
import com.github.sanctum.labyrinth.data.YamlConfiguration;
import com.github.sanctum.labyrinth.data.YamlExtension;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.file.JsonConfiguration;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManager {
    protected final Configurable configuration;
    protected final Plugin plugin;

    protected FileManager(@NotNull Plugin plugin, @NotNull Configurable configuration) {
        if (plugin == null) {
            FileManager.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            FileManager.$$$reportNull$$$0(1);
        }
        this.plugin = plugin;
        this.configuration = configuration;
    }

    protected FileManager(@NotNull Plugin plugin, @NotNull String n, @Nullable String d, Configurable.Extension data) {
        if (plugin == null) {
            FileManager.$$$reportNull$$$0(2);
        }
        if (n == null) {
            FileManager.$$$reportNull$$$0(3);
        }
        if (data.get().endsWith("data") || data.get().endsWith("json")) {
            JsonConfiguration c = new JsonConfiguration(plugin.getDataFolder(), n, d);
            this.plugin = plugin;
            this.configuration = c;
            this.configuration.register(new BukkitGeneric());
            return;
        }
        if (data.get().endsWith("yml")) {
            YamlConfiguration c = new YamlConfiguration(plugin, n, d);
            this.plugin = c.plugin;
            this.configuration = c;
            this.configuration.register(new BukkitGeneric());
            return;
        }
        throw new IllegalArgumentException(data.get() + " files cannot be instantiated through file manager, injection required!");
    }

    public Configurable getRoot() {
        return this.configuration;
    }

    public <R> R read(Function<Configurable, R> fun) {
        return fun.apply(this.configuration);
    }

    public void write(Consumer<? super DataTable> table) {
        DataTable t = DataTable.newTable();
        table.accept(t);
        this.write(t);
    }

    @Note(value="You can create a fresh DataTable really easily see DataTable#newTable()")
    public void write(@Note(value="Provided table gets cleared upon finalization.") @Note(value="Provided table gets cleared upon finalization.") DataTable table) {
        this.write(table, true);
    }

    @Note(value="You can create a fresh DataTable really easily see DataTable#newTable()")
    public void write(@Note(value="Provided table gets cleared upon finalization.") @Note(value="Provided table gets cleared upon finalization.") DataTable table, boolean replace) {
        for (Map.Entry<String, Object> entry : table.values().entrySet()) {
            if (replace) {
                if (entry.getValue().equals("NULL")) {
                    this.configuration.set(entry.getKey(), null);
                    continue;
                }
                this.configuration.set(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue().equals("NULL") || this.configuration.isNode(entry.getKey())) continue;
            this.configuration.set(entry.getKey(), entry.getValue());
        }
        table.clear();
        this.configuration.save();
    }

    @NotNull
    public FileManager toJSON(@NotNull String name, String dir) {
        if (name == null) {
            FileManager.$$$reportNull$$$0(4);
        }
        FileManager n = FileList.search(this.plugin).get(name, dir, Configurable.Type.JSON);
        Configurable c = this.getRoot();
        if (c instanceof YamlConfiguration) {
            n.write(this.copy(), false);
            FileManager fileManager = n;
            if (fileManager == null) {
                FileManager.$$$reportNull$$$0(5);
            }
            return fileManager;
        }
        FileManager fileManager = this;
        if (fileManager == null) {
            FileManager.$$$reportNull$$$0(6);
        }
        return fileManager;
    }

    @NotNull
    public FileManager toYaml(@NotNull String name, String dir) {
        if (name == null) {
            FileManager.$$$reportNull$$$0(7);
        }
        FileManager n = FileList.search(this.plugin).get(name, dir, YamlExtension.INSTANCE);
        Configurable c = this.getRoot();
        if (c instanceof JsonConfiguration) {
            n.write(this.copy(), false);
            FileManager fileManager = n;
            if (fileManager == null) {
                FileManager.$$$reportNull$$$0(8);
            }
            return fileManager;
        }
        FileManager fileManager = this;
        if (fileManager == null) {
            FileManager.$$$reportNull$$$0(9);
        }
        return fileManager;
    }

    @NotNull
    public FileManager toJSON() {
        FileManager fileManager = this.toJSON(this.getRoot().getName(), this.getRoot().getDirectory());
        if (fileManager == null) {
            FileManager.$$$reportNull$$$0(10);
        }
        return fileManager;
    }

    @NotNull
    public FileManager toYaml() {
        FileManager fileManager = this.toYaml(this.getRoot().getName(), this.getRoot().getDirectory());
        if (fileManager == null) {
            FileManager.$$$reportNull$$$0(11);
        }
        return fileManager;
    }

    @NotNull
    public FileManager toMoved(String dir) {
        FileManager n = FileList.search(this.plugin).get(this.getRoot().getName(), dir, this.getRoot().getType());
        Configurable c = this.getRoot();
        n.write(this.copy(), false);
        c.delete();
        FileManager fileManager = n;
        if (fileManager == null) {
            FileManager.$$$reportNull$$$0(12);
        }
        return fileManager;
    }

    @NotNull
    public DataTable copy() {
        Configurable c = this.getRoot();
        DataTable inquiry = DataTable.newTable();
        c.getValues(true).forEach(inquiry::set);
        DataTable dataTable = inquiry;
        if (dataTable == null) {
            FileManager.$$$reportNull$$$0(13);
        }
        return dataTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileManager)) {
            return false;
        }
        FileManager config = (FileManager)o;
        return this.configuration.equals(config.configuration);
    }

    public int hashCode() {
        return this.configuration.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/data/FileManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/data/FileManager";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toJSON";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toYaml";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toMoved";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toJSON";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toYaml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

