/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.data.CustomFileOptional;
import com.github.sanctum.labyrinth.data.FileManager;
import com.github.sanctum.labyrinth.data.YamlExtension;
import com.github.sanctum.panther.file.Configurable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileList {
    static final Map<String, Map<String, FileManager>> CACHE = new ConcurrentHashMap<String, Map<String, FileManager>>();
    private static final ConcurrentHashMap<String, FileList> REGISTRY = new ConcurrentHashMap();
    private final Plugin plugin;

    private FileList(Plugin plugin) {
        this.plugin = plugin;
    }

    public static FileList search(@NotNull Plugin plugin) {
        if (plugin == null) {
            FileList.$$$reportNull$$$0(0);
        }
        return REGISTRY.computeIfAbsent(plugin.getName(), name -> new FileList(plugin));
    }

    public static List<FileManager> getFiles(Plugin plugin) {
        return (List)Optional.ofNullable(CACHE.get(plugin.getName())).map(Map::values).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    public static void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File is a directory!", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write to file! See log:", e);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public List<FileManager> getFiles() {
        return (List)Optional.ofNullable(CACHE.get(this.plugin.getName())).map(Map::values).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    public void inject(@NotNull Configurable configurable) {
        if (configurable == null) {
            FileList.$$$reportNull$$$0(1);
        }
        FileList.cacheFileManager(new FileManager(this.plugin, configurable));
    }

    public void copy(String fileName, FileManager fileManager) {
        InputStream stream = this.plugin.getResource(fileName);
        if (stream == null) {
            throw new RuntimeException("Non existent resources cannot be copied to file managers!");
        }
        FileList.copy(stream, fileManager.getRoot().getParent());
    }

    public void copyYML(String ymlName, FileManager fileManager) {
        this.copy(ymlName + ".yml", fileManager);
    }

    public void copyYML(String ymlName, File file) {
        InputStream stream = this.plugin.getResource(ymlName + ".yml");
        if (stream == null) {
            throw new RuntimeException("Non existent resources cannot be copied to file locations!");
        }
        FileList.copy(stream, file);
    }

    @NotNull
    public CustomFileOptional check(String name, String desc, Configurable.Extension extension) {
        return new CustomFileOptional(this, name, desc, extension);
    }

    @NotNull
    public FileManager get(@NotNull String name) throws IllegalArgumentException {
        if (name == null) {
            FileList.$$$reportNull$$$0(2);
        }
        FileManager fileManager = this.get(name, (String)null);
        if (fileManager == null) {
            FileList.$$$reportNull$$$0(3);
        }
        return fileManager;
    }

    @NotNull
    public FileManager get(@NotNull String name, @Nullable String desc) throws IllegalArgumentException {
        if (name == null) {
            FileList.$$$reportNull$$$0(4);
        }
        FileManager fileManager = this.get(name, desc, YamlExtension.INSTANCE);
        if (fileManager == null) {
            FileList.$$$reportNull$$$0(5);
        }
        return fileManager;
    }

    @NotNull
    public FileManager get(@NotNull String name, Configurable.Extension data) throws IllegalArgumentException {
        if (name == null) {
            FileList.$$$reportNull$$$0(6);
        }
        FileManager fileManager = this.get(name, null, data);
        if (fileManager == null) {
            FileList.$$$reportNull$$$0(7);
        }
        return fileManager;
    }

    @NotNull
    public FileManager get(@NotNull String name, @Nullable String desc, Configurable.Extension type) throws IllegalArgumentException {
        if (name == null) {
            FileList.$$$reportNull$$$0(8);
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty!");
        }
        FileManager fileManager = Optional.ofNullable(CACHE.get(this.plugin.getName())).map(m -> (FileManager)m.get(desc + ';' + name)).filter(m -> Objects.equals(m.getRoot().getType(), type)).orElseGet(() -> FileList.cacheFileManager(new FileManager(this.plugin, name, desc, type)));
        if (fileManager == null) {
            FileList.$$$reportNull$$$0(9);
        }
        return fileManager;
    }

    public boolean exists(@NotNull String name, @Nullable String desc) {
        if (name == null) {
            FileList.$$$reportNull$$$0(10);
        }
        return this.exists(name, desc, YamlExtension.INSTANCE);
    }

    public boolean exists(@NotNull String name, @Nullable String desc, @NotNull Configurable.Extension extension) {
        File parent;
        if (name == null) {
            FileList.$$$reportNull$$$0(11);
        }
        if (extension == null) {
            FileList.$$$reportNull$$$0(12);
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty!");
        }
        File file = parent = desc == null || desc.isEmpty() ? this.plugin.getDataFolder() : new File(this.plugin.getDataFolder(), desc);
        if (!parent.exists()) {
            return false;
        }
        File test = new File(parent, name.concat(extension.get()));
        return test.exists();
    }

    private static FileManager cacheFileManager(FileManager fileManager) {
        CACHE.computeIfAbsent(fileManager.plugin.getName(), s -> new ConcurrentHashMap()).put(fileManager.configuration.getDirectory() + ';' + fileManager.configuration.getName(), fileManager);
        return fileManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/data/FileList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/data/FileList";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inject";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

