/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.data.CuboidAxis;
import com.github.sanctum.labyrinth.data.CuboidLocation;
import com.github.sanctum.labyrinth.data.container.Cuboid;
import com.github.sanctum.panther.util.Check;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class DefaultCuboid
implements Cuboid {
    private final CuboidAxis axis;
    private final CuboidLocation location;

    public DefaultCuboid(Location start, Location end) throws NullPointerException {
        Check.forNull(start, "Starting point cannot be null!");
        Check.forNull(end, "End point cannot be null!");
        Check.argument(start.getWorld().getName().equals(end.getWorld().getName()), "The locations must both be from the same realm!");
        this.axis = new CuboidAxis(start.getBlockX(), end.getBlockX(), start.getBlockY(), end.getBlockY(), start.getBlockZ(), end.getBlockZ());
        this.location = new CuboidLocation(this.axis, start.getWorld());
    }

    @Override
    public Cuboid.VisualBoundary getBoundary(Player target) {
        return new Cuboid.VisualBoundary(this.axis.getxMax(), this.axis.getxMin(), this.axis.getyMax(), this.axis.getyMin(), this.axis.getzMax(), this.axis.getzMin()).setViewer(target);
    }

    @Override
    public int getTotalBlocks() {
        return this.axis.getTotalSize();
    }

    @Override
    public CuboidAxis getAxis() {
        return this.axis;
    }

    @Override
    public CuboidLocation getLocation() {
        return this.location;
    }
}

