/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.data.RegionServicesManager;
import com.github.sanctum.labyrinth.data.container.Cuboid;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CuboidSelection {
    private static final Set<CuboidSelection> cache = new HashSet<CuboidSelection>();
    private final Player wizard;
    private ItemStack wand;
    private Location pos1;
    private Location pos2;

    protected CuboidSelection(Player wizard) {
        this.wizard = wizard;
        this.wand = RegionServicesManager.getInstance().getWand();
    }

    public Player getPlayer() {
        return this.wizard;
    }

    public ItemStack getWand() {
        return this.wand;
    }

    public boolean isEmpty() {
        return this.getPos1() == null || this.getPos2() == null;
    }

    public void setWand(ItemStack wand) {
        this.wand = wand;
    }

    public Location getPos1() {
        return this.pos1;
    }

    public Location getPos2() {
        return this.pos2;
    }

    public Location getHighest() {
        return this.getPos1().getBlockY() > this.getPos2().getBlockY() ? this.getPos1() : this.getPos2();
    }

    public Location getLowest() {
        return this.getPos2().getBlockY() < this.getPos1().getBlockY() ? this.getPos2() : this.getPos1();
    }

    public Location expand(BlockFace direction) {
        switch (direction) {
            case UP: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.UP).getLocation();
                this.setPos1(update);
                return update;
            }
            case DOWN: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.DOWN).getLocation();
                this.setPos2(update);
                return update;
            }
            case EAST: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.EAST).getLocation();
                this.setPos1(update);
                return update;
            }
            case WEST: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.WEST).getLocation();
                this.setPos2(update);
                return update;
            }
            case NORTH: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.NORTH).getLocation();
                this.setPos1(update);
                return update;
            }
            case SOUTH: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.SOUTH).getLocation();
                this.setPos2(update);
                return update;
            }
        }
        throw new IllegalStateException();
    }

    public Location expand(BlockFace direction, int distance) {
        switch (direction) {
            case UP: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.UP, distance).getLocation();
                this.setPos1(update);
                return update;
            }
            case DOWN: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.DOWN, distance).getLocation();
                this.setPos2(update);
                return update;
            }
            case EAST: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.EAST, distance).getLocation();
                this.setPos1(update);
                return update;
            }
            case WEST: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.WEST, distance).getLocation();
                this.setPos2(update);
                return update;
            }
            case NORTH: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.NORTH, distance).getLocation();
                this.setPos1(update);
                return update;
            }
            case SOUTH: {
                Location update = this.getHighest().getBlock().getRelative(BlockFace.SOUTH, distance).getLocation();
                this.setPos2(update);
                return update;
            }
        }
        throw new IllegalStateException();
    }

    public void setPos1(Location pos1) {
        this.pos1 = pos1;
    }

    public void setPos2(Location pos2) {
        this.pos2 = pos2;
    }

    public Cuboid toCuboid() {
        return Cuboid.fromPoints(this.getPos1(), this.getPos2());
    }

    public static boolean has(Player p) {
        return cache.stream().anyMatch(s -> s.getPlayer().equals(p));
    }

    public static CuboidSelection get(Player p) {
        for (CuboidSelection r : cache) {
            if (!r.getPlayer().equals(p)) continue;
            return r;
        }
        CuboidSelection r = new CuboidSelection(p);
        cache.add(r);
        return r;
    }
}

