/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.command;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.command.SubCommand;
import com.github.sanctum.labyrinth.interfacing.MessageInListener;
import com.github.sanctum.labyrinth.library.CommandUtils;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.panther.container.PantherCollectionBase;
import com.github.sanctum.panther.container.PantherList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubCommandList
extends PantherCollectionBase<SubCommand> {
    protected final Crossover parent;

    protected SubCommandList(@NotNull Command parent) {
        if (parent == null) {
            SubCommandList.$$$reportNull$$$0(0);
        }
        this.parent = new Crossover(parent);
    }

    @NotNull
    public final String getCommand() {
        String string = this.parent.getLabel();
        if (string == null) {
            SubCommandList.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public final SubCommand getSubCommand(@NotNull String label) {
        if (label == null) {
            SubCommandList.$$$reportNull$$$0(2);
        }
        return this.stream().filter(s -> s.getLabel().equalsIgnoreCase(label)).findFirst().orElse(null);
    }

    public final void register(@NotNull SubCommand subCommand) {
        if (subCommand == null) {
            SubCommandList.$$$reportNull$$$0(3);
        }
        if (subCommand.getCommand().equalsIgnoreCase(this.getCommand())) {
            Command parent = CommandUtils.getCommandByLabel(subCommand.getCommand());
            if (this.parent.command.equals(parent)) {
                Plugin plugin = this.parent.getPlugin();
                CommandUtils.read(entry -> {
                    Map commandMappings = (Map)entry.getValue();
                    CommandMap map = (CommandMap)entry.getKey();
                    commandMappings.remove(parent.getName());
                    for (String alias : parent.getAliases()) {
                        if (!commandMappings.containsKey(alias) || !((Command)commandMappings.get(alias)).getAliases().contains(alias)) continue;
                        commandMappings.remove(alias);
                    }
                    parent.unregister(map);
                    map.register(this.getCommand(), plugin.getName(), (Command)this.parent);
                    return this;
                });
                if (!this.contains(subCommand)) {
                    this.add(subCommand);
                }
            } else {
                throw new IllegalArgumentException("Command " + subCommand.getCommand() + " either not found, not loaded or mismatched.");
            }
        }
    }

    public final void unregister(@NotNull SubCommand subCommand) {
        if (subCommand == null) {
            SubCommandList.$$$reportNull$$$0(4);
        }
        if (subCommand.getCommand().equalsIgnoreCase(this.getCommand())) {
            Command parent = CommandUtils.getCommandByLabel(subCommand.getCommand());
            if (this.parent.command.equals(parent)) {
                if (this.contains(subCommand)) {
                    this.remove(subCommand);
                }
            } else {
                throw new IllegalArgumentException("Command " + subCommand.getCommand() + " either not found or not loaded yet.");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/command/SubCommandList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/command/SubCommandList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class Crossover
    extends Command {
        private final Command command;
        private final Plugin plugin;

        Crossover(Command pass) {
            super(pass.getName());
            this.command = pass;
            this.plugin = Optional.of(JavaPlugin.getProvidingPlugin(pass.getClass())).orElseGet(() -> {
                if (pass instanceof PluginCommand) {
                    return ((PluginCommand)pass).getPlugin();
                }
                return LabyrinthProvider.getInstance().getPluginInstance();
            });
            if (!this.command.getAliases().isEmpty()) {
                this.setAliases(this.command.getAliases());
            }
            if (this.command.getPermission() != null) {
                this.setPermission(this.command.getPermission());
            }
            if (!this.command.getDescription().isEmpty()) {
                this.setDescription(this.command.getDescription());
            }
            if (!this.command.getUsage().isEmpty()) {
                this.setUsage(this.command.getUsage());
            }
            if (this.command.getPermissionMessage() != null) {
                this.setPermissionMessage(this.command.getPermissionMessage());
            }
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
            if (sender == null) {
                Crossover.$$$reportNull$$$0(0);
            }
            if (alias == null) {
                Crossover.$$$reportNull$$$0(1);
            }
            if (args == null) {
                Crossover.$$$reportNull$$$0(2);
            }
            PantherList labels = new PantherList();
            if (args.length > 0) {
                if (SubCommandList.this instanceof MessageInListener) {
                    ((MessageInListener)((Object)SubCommandList.this)).onReceiveSuggestion(String.join((CharSequence)" ", args));
                }
                for (SubCommand sub : SubCommandList.this) {
                    if (args.length == 1) {
                        Stream.of(sub.getLabel()).filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).forEach(labels::add);
                    }
                    if (!args[0].equalsIgnoreCase(sub.getLabel())) continue;
                    LinkedList<String> t = new LinkedList<String>(Arrays.asList(args));
                    t.removeIf(s -> StringUtils.use(s).containsIgnoreCase((CharSequence)sub.getLabel()));
                    List<String> list = sub.tab((Player)sender, alias, t.toArray(new String[0]));
                    if (list == null) {
                        Crossover.$$$reportNull$$$0(3);
                    }
                    return list;
                }
            }
            labels.addAll(this.command.tabComplete(sender, alias, args));
            List<String> list = labels.stream().collect(Collectors.toList());
            if (list == null) {
                Crossover.$$$reportNull$$$0(4);
            }
            return list;
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
            if (sender == null) {
                Crossover.$$$reportNull$$$0(5);
            }
            if (commandLabel == null) {
                Crossover.$$$reportNull$$$0(6);
            }
            if (args == null) {
                Crossover.$$$reportNull$$$0(7);
            }
            if (args.length > 0) {
                if (SubCommandList.this instanceof MessageInListener) {
                    ((MessageInListener)((Object)SubCommandList.this)).onReceiveMessage(String.join((CharSequence)" ", args));
                }
                for (SubCommand sub : SubCommandList.this) {
                    if (!args[0].equalsIgnoreCase(sub.getLabel())) continue;
                    LinkedList<String> t = new LinkedList<String>(Arrays.asList(args));
                    t.removeIf(s -> StringUtils.use(s).containsIgnoreCase((CharSequence)sub.getLabel()));
                    String[] realArgs = t.toArray(new String[0]);
                    if (sender instanceof Player) {
                        return sub.player((Player)sender, commandLabel, realArgs);
                    }
                    return sub.console(sender, commandLabel, realArgs);
                }
            }
            return this.command.execute(sender, commandLabel, args);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sender";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alias";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/github/sanctum/labyrinth/command/SubCommandList$Crossover";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/github/sanctum/labyrinth/command/SubCommandList$Crossover";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tabComplete";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "tabComplete";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

