/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.util.Task;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class TaskChain {
    private static final PantherMap<Integer, TaskChain> chainMap = new PantherEntryMap<Integer, TaskChain>();
    protected final PantherMap<String, Task> map = new PantherEntryMap<String, Task>();
    protected final ScheduledExecutorService defaultTimer = Executors.newSingleThreadScheduledExecutor();

    @NotNull
    public abstract TaskChain run(@NotNull Task var1);

    @NotNull
    public abstract TaskChain run(@NotNull Runnable var1);

    @NotNull
    public abstract TaskChain wait(@NotNull Task var1);

    @NotNull
    public abstract TaskChain wait(@NotNull Task var1, long var2);

    @NotNull
    public abstract TaskChain wait(@NotNull Runnable var1, long var2);

    @NotNull
    public abstract TaskChain wait(@NotNull Runnable var1, @NotNull String var2, long var3);

    @NotNull
    public abstract TaskChain repeat(@NotNull Task var1);

    @NotNull
    public abstract TaskChain repeat(@NotNull Task var1, long var2, long var4);

    @NotNull
    public abstract TaskChain repeat(@NotNull Runnable var1, long var2, long var4);

    @NotNull
    public abstract TaskChain repeat(@NotNull Runnable var1, @NotNull String var2, long var3, long var5);

    @NotNull
    public abstract <T> Future<T> submit(@NotNull Callable<T> var1);

    @NotNull
    public abstract <T> Future<T> submit(@NotNull Callable<T> var1, long var2);

    @NotNull
    public abstract <T> List<Future<T>> submit(@NotNull Collection<Callable<T>> var1, long var2) throws InterruptedException;

    public abstract boolean shutdown();

    public abstract Task get(String var1);

    public static void setChain(int runtime, @NotNull TaskChain chain) {
        chainMap.put(runtime, chain);
    }

    public static TaskChain getAsynchronous() {
        return TaskChain.getChain(1);
    }

    public static TaskChain getSynchronous() {
        return TaskChain.getChain(0);
    }

    public static TaskChain getChain(int runtime) {
        return chainMap.get(runtime);
    }

    static {
        chainMap.put(1, new TaskChain(){

            @Override
            @NotNull
            public TaskChain run(@NotNull Task task) {
                task.setChain(this);
                task.setFuture(this.defaultTimer.submit(task.setAsync(true)));
                return this;
            }

            @Override
            @NotNull
            public TaskChain run(@NotNull Runnable data) {
                this.defaultTimer.submit(data);
                return this;
            }

            @Override
            @NotNull
            public TaskChain wait(@NotNull Task task) {
                if (!task.getClass().isAnnotationPresent(Task.Delay.class)) {
                    throw new IllegalStateException("Task Delay annotation missing!");
                }
                long time = task.getClass().getAnnotation(Task.Delay.class).value();
                return this.wait(task, time);
            }

            @Override
            @NotNull
            public TaskChain wait(@NotNull Task task, long delay) {
                task.setChain(this);
                task.setFuture(this.defaultTimer.schedule(task.setAsync(true), delay, TimeUnit.MILLISECONDS));
                if (task.getKey() != null) {
                    this.map.put(task.getKey(), task);
                }
                return this;
            }

            @Override
            @NotNull
            public TaskChain wait(@NotNull Runnable data, long delay) {
                return this.wait(data, UUID.randomUUID().toString(), delay);
            }

            @Override
            @NotNull
            public TaskChain wait(final @NotNull Runnable data, @NotNull String key, long delay) {
                Task task = new Task(key, 0, this){
                    private static final long serialVersionUID = 5064153492626085962L;

                    @Ordinal
                    public void execute() {
                        data.run();
                    }
                };
                task.setFuture(this.defaultTimer.schedule(task.setAsync(true), delay, TimeUnit.MILLISECONDS));
                if (task.getKey() != null) {
                    this.map.put(task.getKey(), task);
                }
                return this;
            }

            @Override
            @NotNull
            public TaskChain repeat(@NotNull Task task) {
                if (!task.getClass().isAnnotationPresent(Task.Delay.class)) {
                    throw new IllegalStateException("Task Delay annotation missing!");
                }
                long delay = task.getClass().getAnnotation(Task.Delay.class).value();
                if (!task.getClass().isAnnotationPresent(Task.Period.class)) {
                    throw new IllegalStateException("Task Period annotation missing!");
                }
                long period = task.getClass().getAnnotation(Task.Period.class).value();
                return this.repeat(task, delay, period);
            }

            @Override
            @NotNull
            public TaskChain repeat(@NotNull Task task, long delay, long period) {
                if (!this.map.containsKey(task.getKey())) {
                    task.setFuture(this.defaultTimer.scheduleAtFixedRate(task.setAsync(true), delay, period, TimeUnit.MILLISECONDS));
                    if (task.getKey() != null) {
                        this.map.put(task.getKey(), task);
                    }
                }
                return this;
            }

            @Override
            @NotNull
            public TaskChain repeat(@NotNull Runnable task, long delay, long period) {
                return this.repeat(task, UUID.randomUUID().toString(), delay, period);
            }

            @Override
            @NotNull
            public TaskChain repeat(final @NotNull Runnable data, @NotNull String key, long delay, long period) {
                Task task = new Task(key, 0, this){
                    private static final long serialVersionUID = 5064153492626085962L;

                    @Ordinal
                    public void execute() {
                        data.run();
                    }
                };
                task.setFuture(this.defaultTimer.scheduleAtFixedRate(task.setAsync(true), delay, period, TimeUnit.MILLISECONDS));
                this.map.put(key, task);
                return this;
            }

            @Override
            @NotNull
            public <T> Future<T> submit(@NotNull Callable<T> data) {
                return this.defaultTimer.submit(data);
            }

            @Override
            @NotNull
            public <T> Future<T> submit(@NotNull Callable<T> data, long delay) {
                return this.defaultTimer.schedule(data, delay, TimeUnit.MILLISECONDS);
            }

            @Override
            @NotNull
            public <T> List<Future<T>> submit(@NotNull Collection<Callable<T>> data, long delay) throws InterruptedException {
                return this.defaultTimer.invokeAll(data, delay, TimeUnit.MILLISECONDS);
            }

            @Override
            public boolean shutdown() {
                if (!this.map.isEmpty()) {
                    this.map.values().forEach(Task::cancel);
                    this.map.clear();
                    this.defaultTimer.shutdown();
                    return true;
                }
                return false;
            }

            @Override
            public Task get(String key) {
                return (Task)this.map.get(key);
            }
        });
    }
}

