/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherQueue;
import com.github.sanctum.panther.container.PantherSet;
import com.github.sanctum.panther.util.AbstractJarScanner;
import com.github.sanctum.panther.util.TaskChain;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceLookup {
    final ClassLoader loader;
    final PantherQueue<Class<?>> classes;

    public ResourceLookup(@NotNull ClassLoader loader) {
        this.loader = loader;
        this.classes = new PantherQueue();
    }

    @Note(value="Queues all classes from a specific base package.")
    public @Note(value="Queues all classes from a specific base package.") ResourceLookup(@NotNull ClassLoader loader, @NotNull String packageName) {
        this(loader);
        this.getClasses(packageName);
    }

    @Nullable
    public Class<?> getClass(@NotNull String simpleName, @NotNull String packageName) {
        return this.getClasses(packageName).stream().filter(c -> c.getSimpleName().equals(simpleName)).findFirst().orElse(null);
    }

    @Nullable
    public Class<?> getClass(@NotNull String simpleName) {
        return this.getClasses().get(c -> c.getSimpleName().equals(simpleName));
    }

    @NotNull
    public PantherQueue<Class<?>> getClasses() {
        return this.classes;
    }

    @NotNull
    public PantherCollection<Class<?>> getClasses(@NotNull String packageName) {
        try {
            PantherCollection<Class<?>> collection = ResourceLookup.getClasses(packageName, this.loader);
            TaskChain.getAsynchronous().wait(() -> collection.forEach(c -> {
                if (!this.classes.contains((Class<?>)c)) {
                    this.classes.add((Class<?>)c);
                }
            }), 50L);
            return collection;
        }
        catch (Exception e) {
            return new PantherList();
        }
    }

    @Nullable
    public AbstractJarScanner getScanner(@NotNull String file) {
        InputStream stream = this.loader.getResourceAsStream(file);
        if (stream != null) {
            return new AbstractJarScanner(stream){};
        }
        return null;
    }

    public static PantherCollection<Class<?>> getClasses(String packageName, @NotNull ClassLoader classLoader) throws Exception {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        PantherList dirs = new PantherList();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(resource.getFile());
        }
        PantherSet classes = new PantherSet();
        for (String directory : dirs) {
            TreeSet<String> iterable = ResourceLookup.getClassNames(directory, packageName);
            classes.addAll(iterable);
        }
        PantherList classList = new PantherList();
        for (String clazz : classes) {
            try {
                Class<?> c = Class.forName(clazz);
                classList.add(c);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return classList;
    }

    private static TreeSet<String> getClassNames(String directory, String packageName) throws Exception {
        File dir;
        TreeSet<String> classes = new TreeSet<String>();
        if (directory.startsWith("file:") && directory.contains("!")) {
            String[] split = directory.split("!");
            URL jar = new URL(split[0]);
            try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
                ZipEntry entry = null;
                while ((entry = zip.getNextEntry()) != null) {
                    String className;
                    if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                    classes.add(className);
                }
            }
        }
        if (!(dir = new File(directory)).exists()) {
            return classes;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classes.addAll(ResourceLookup.getClassNames(file.getAbsolutePath(), packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
            }
        }
        return classes;
    }
}

