/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Json;
import com.github.sanctum.panther.util.JsonIntermediate;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class ProgressBar
implements JsonIntermediate {
    public static final int NO_PERCENTAGE = 0;
    public static final int PERCENT_ON_LEFT = 1;
    public static final int PERCENT_ON_RIGHT = 2;
    public static final int PERCENT_IN_MIDDLE = 3;
    private int position;
    private int progress;
    private int maxProgress = 150;
    private int maxBars = 33;
    private char symbol = (char)124;
    private String emptyColor = "&7";
    private String fullColor = "&a";
    private String prefix;
    private String suffix;

    public static ProgressBar fromJson(@Json String json) throws IllegalArgumentException {
        return ProgressBar.fromJson(JsonIntermediate.toJsonObject(json));
    }

    public static ProgressBar fromJson(JsonObject object) throws IllegalArgumentException {
        if (object.get(ProgressBar.class.getName()) != null) {
            JsonObject o = object.get(ProgressBar.class.getName()).getAsJsonObject();
            Map<String, Object> map = JsonIntermediate.convertToMap(o);
            String prefix = (String)map.get("prefix");
            String suffix = (String)map.get("suffix");
            String ecolor = (String)map.get("empty-color");
            String fcolor = (String)map.get("full-color");
            String symbol = (String)map.get("symbol");
            int position = (Integer)map.get("position");
            int progress = (Integer)map.get("progress");
            int maxprog = (Integer)map.get("max-progress");
            int bars = (Integer)map.get("bars");
            return new ProgressBar().setPrefix(prefix).setSuffix(suffix).setSymbol(symbol.charAt(0)).setEmptyColor(ecolor).setFullColor(fcolor).setPercentPosition(position).setProgress(progress).setGoal(maxprog).setBars(bars);
        }
        throw new IllegalArgumentException("Object not related to progress bar.");
    }

    public String toString() {
        int currentProgressBarIndex = (int)Math.ceil((double)this.maxBars / (double)this.maxProgress * (double)this.progress);
        String formattedPercent = String.format("%5.1f %% ", (double)(100 * currentProgressBarIndex) / (double)this.maxBars);
        int percentStartIndex = (this.maxBars - formattedPercent.length()) / 2;
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        if (this.position == 1) {
            sb.append(formattedPercent);
        }
        for (int progressBarIndex = 0; progressBarIndex < this.maxBars - 1; ++progressBarIndex) {
            if (progressBarIndex <= percentStartIndex - 1 || progressBarIndex >= percentStartIndex + formattedPercent.length()) {
                if (currentProgressBarIndex <= progressBarIndex) {
                    if (this.emptyColor != null) {
                        sb.append(this.emptyColor).append(this.symbol);
                    }
                } else if (this.fullColor != null) {
                    sb.append(this.fullColor).append(this.symbol);
                }
            }
            if (this.position != 3 || progressBarIndex != percentStartIndex) continue;
            sb.append("&r").append(formattedPercent.contains("100.0 %") ? " 100.0% " : formattedPercent);
        }
        if (this.position == 2) {
            sb.append(formattedPercent);
        }
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    public ProgressBar setProgress(int progress) {
        this.progress = progress;
        return this;
    }

    public ProgressBar setGoal(int progress) {
        this.maxProgress = progress;
        return this;
    }

    public ProgressBar setBars(int count) {
        this.maxBars = count < 9 || count % 2 == 0 ? 33 : count;
        return this;
    }

    public ProgressBar setSymbol(char symbol) {
        this.symbol = symbol;
        return this;
    }

    public ProgressBar setEmptyColor(String color) {
        this.emptyColor = color;
        return this;
    }

    public ProgressBar setFullColor(String color) {
        this.fullColor = color;
        return this;
    }

    public ProgressBar setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ProgressBar setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public ProgressBar setPercentPosition(int position) {
        this.position = position;
        return this;
    }

    public double getPercentage() {
        return (double)Math.round((double)this.progress * 100.0 / (double)this.maxProgress * 100.0) / 100.0;
    }

    @Json(key="prefix")
    String getPrefix() {
        return this.prefix;
    }

    @Json(key="suffix")
    String getSuffix() {
        return this.suffix;
    }

    @Json(key="progress")
    int getProgress() {
        return this.progress;
    }

    @Json(key="max-progress")
    int getMaxProgress() {
        return this.maxProgress;
    }

    @Json(key="bars")
    int getMaxBars() {
        return this.maxBars;
    }

    @Json(key="position")
    int getPosition() {
        return this.position;
    }

    @Json(key="symbol")
    String getSymbol() {
        return String.valueOf(this.symbol);
    }

    @Json(key="empty-color")
    String getEmptyColor() {
        return this.emptyColor;
    }

    @Json(key="full-color")
    String getFullColor() {
        return this.fullColor;
    }

    @Override
    public JsonObject toJsonObject() {
        JsonObject o = new JsonObject();
        o.add(this.getClass().getName(), (JsonElement)JsonIntermediate.toJsonObject(this));
        return o;
    }

    @Override
    @Deprecated
    public JsonArray toJsonArray() {
        return null;
    }
}

