/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.util.Check;
import com.github.sanctum.panther.util.DeployableMapping;
import com.github.sanctum.panther.util.PantherLogger;
import com.github.sanctum.panther.util.TaskChain;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public interface Deployable<T> {
    public Deployable<T> deploy();

    public Deployable<T> deploy(@NotNull Consumer<? super T> var1);

    public Deployable<T> queue();

    public Deployable<T> queue(long var1);

    public Deployable<T> queue(@NotNull Consumer<? super T> var1, long var2);

    public <O> DeployableMapping<O> map(@NotNull Function<? super T, ? extends O> var1);

    public CompletableFuture<T> submit();

    default public boolean isDeployed() {
        return this.get() != null;
    }

    default public T complete() {
        this.deploy();
        return this.submit().join();
    }

    default public T get() {
        return this.complete();
    }

    default public T orElse(T other) {
        return Optional.ofNullable(this.get()).orElse(other);
    }

    default public T orElseGet(Supplier<T> supplier) {
        return Optional.ofNullable(this.get()).orElseGet(supplier);
    }

    @NotNull
    public static Deployable<Void> of(final @NotNull Runnable data, final int runtime) {
        return new Deployable<Void>(){
            final TaskChain taskChain;
            boolean deployed;
            {
                this.taskChain = TaskChain.getChain(runtime);
                this.deployed = false;
            }

            @Override
            public Deployable<Void> deploy() {
                data.run();
                this.deployed = true;
                return this;
            }

            @Override
            public Deployable<Void> deploy(@NotNull Consumer<? super Void> consumer) {
                this.deploy();
                consumer.accept(null);
                return this;
            }

            @Override
            public Deployable<Void> queue() {
                this.taskChain.run(this::deploy);
                return this;
            }

            @Override
            public Deployable<Void> queue(long wait) {
                this.taskChain.wait(this::deploy, UUID.randomUUID().toString(), wait);
                return this;
            }

            @Override
            public Deployable<Void> queue(@NotNull Consumer<? super Void> consumer, long wait) {
                this.taskChain.wait(() -> {
                    this.deploy();
                    consumer.accept(null);
                }, UUID.randomUUID().toString(), wait);
                return this;
            }

            @Override
            public <O> DeployableMapping<O> map(@NotNull Function<? super Void, ? extends O> mapper) {
                return null;
            }

            @Override
            public CompletableFuture<Void> submit() {
                return CompletableFuture.supplyAsync(() -> this.deploy().get());
            }

            @Override
            public boolean isDeployed() {
                return this.deployed;
            }

            @Override
            public Void get() {
                throw new NullPointerException("No return values used with runnable deployable sequences.");
            }
        };
    }

    @NotNull
    public static <T> Deployable<T> of(final @NotNull Supplier<T> supplier, final int runtime) {
        return new Deployable<T>(){
            T element;
            boolean deployed = false;
            final TaskChain taskChain = TaskChain.getChain(runtime);

            @Override
            public Deployable<T> deploy() {
                this.element = supplier.get();
                this.deployed = true;
                return this;
            }

            @Override
            public Deployable<T> deploy(@NotNull Consumer<? super T> consumer) {
                this.deploy();
                consumer.accept(this.element);
                return this;
            }

            @Override
            public Deployable<T> queue() {
                this.taskChain.run(this::deploy);
                return this;
            }

            @Override
            public Deployable<T> queue(long wait) {
                this.taskChain.wait(this::deploy, wait);
                return this;
            }

            @Override
            public Deployable<T> queue(@NotNull Consumer<? super T> consumer, long wait) {
                this.taskChain.wait(() -> {
                    this.deploy();
                    consumer.accept((Object)this.element);
                }, wait);
                return this;
            }

            @Override
            public <O> DeployableMapping<O> map(@NotNull Function<? super T, ? extends O> mapper) {
                return new DeployableMapping<O>(this.taskChain, () -> this.element, mapper);
            }

            @Override
            public CompletableFuture<T> submit() {
                return CompletableFuture.supplyAsync(() -> this.deploy().get());
            }

            @Override
            public boolean isDeployed() {
                return this.deployed;
            }

            @Override
            public T get() {
                if (!this.isDeployed()) {
                    this.deploy();
                    Logger logger = PantherLogger.getInstance().getLogger();
                    logger.warning("               !!![WARNING]!!!");
                    logger.warning("================================================");
                    logger.warning("Illegal sequence retrieval w/ element " + this.element);
                    logger.warning("The ability to do this will be removed in the future!");
                    logger.warning("Make the subsequent calls to 'deploy' or 'queue' while processing deployables!");
                    logger.warning("================================================");
                }
                return this.isDeployed() ? this.element : Check.forNull(this.element, "Sequence not deployed, no object found.");
            }
        };
    }

    @NotNull
    public static <T> Deployable<T> of(final @NotNull T supplier, final @NotNull Consumer<T> operation, final int runtime) {
        return new Deployable<T>(){
            final T element;
            boolean deployed;
            final TaskChain taskChain;
            {
                this.element = supplier;
                this.deployed = false;
                this.taskChain = TaskChain.getChain(runtime);
            }

            @Override
            public Deployable<T> deploy() {
                operation.accept(this.element);
                this.deployed = true;
                return this;
            }

            @Override
            public Deployable<T> deploy(@NotNull Consumer<? super T> consumer) {
                this.deploy();
                consumer.accept(this.element);
                return this;
            }

            @Override
            public Deployable<T> queue() {
                this.taskChain.run(this::deploy);
                return this;
            }

            @Override
            public Deployable<T> queue(long wait) {
                this.taskChain.wait(this::deploy, UUID.randomUUID().toString(), wait);
                return this;
            }

            @Override
            public Deployable<T> queue(@NotNull Consumer<? super T> consumer, long wait) {
                this.taskChain.wait(() -> {
                    this.deploy();
                    consumer.accept((Object)this.element);
                }, UUID.randomUUID().toString(), wait);
                return this;
            }

            @Override
            public <O> DeployableMapping<O> map(@NotNull Function<? super T, ? extends O> mapper) {
                return new DeployableMapping<O>(this.taskChain, () -> this.element, mapper);
            }

            @Override
            public CompletableFuture<T> submit() {
                return CompletableFuture.supplyAsync(() -> this.deploy().get());
            }

            @Override
            public boolean isDeployed() {
                return this.deployed;
            }

            @Override
            public T get() {
                if (!this.deployed) {
                    Logger logger = PantherLogger.getInstance().getLogger();
                    logger.warning("               !!![WARNING]!!!");
                    logger.warning("================================================");
                    logger.warning("Illegal sequence retrieval w/ element " + this.element);
                    logger.warning("The ability to do this will be removed in the future!");
                    logger.warning("Make the subsequent calls to 'deploy' or 'queue' while processing deployables!");
                    logger.warning("================================================");
                    this.deploy();
                }
                return this.isDeployed() ? this.element : Check.forNull(this.element, "Sequence invalid or not deployed, no object found.");
            }
        };
    }
}

