/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface Applicable
extends Runnable,
Serializable {
    @Override
    public void run();

    @NotNull
    default public Applicable applyBefore(@NotNull Applicable applicable) {
        return () -> {
            this.run();
            applicable.run();
        };
    }

    @NotNull
    default public Applicable applyAfter(@NotNull Applicable applicable) {
        return () -> {
            applicable.run();
            this.run();
        };
    }

    @NotNull
    default public Task schedule(long milliseconds) {
        TaskChain chain = TaskChain.getAsynchronous();
        String key = "ApplicableTask;" + this.hashCode();
        return chain.wait(this, key, milliseconds).get(key);
    }

    @NotNull
    default public Task scheduleAlways(long delay, long period) {
        TaskChain chain = TaskChain.getAsynchronous();
        String key = "ApplicableTask;" + this.hashCode();
        return chain.repeat(this, key, delay, period).get(key);
    }
}

