/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.util.Deployable;
import com.github.sanctum.panther.util.Page;
import com.github.sanctum.panther.util.PantherPagination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPaginatedCollection<T>
implements Collection<Page<T>> {
    protected final Set<Page<T>> set = Collections.synchronizedSet(new LinkedHashSet());
    protected Collection<T> collection;
    protected int initialElementsPer = 8;
    protected boolean sorted;
    protected Comparator<? super T> comparator;
    protected Predicate<? super T> predicate;

    protected AbstractPaginatedCollection(Collection<T> collection) {
        this.collection = collection;
    }

    @SafeVarargs
    public AbstractPaginatedCollection(T ... t) {
        this.collection = Arrays.asList(t);
    }

    @Note(value="It is noted that this collection is modifiable and empty and implied to the type casting")
    public static <T> @Note(value="It is noted that this collection is modifiable and empty and implied to the type casting") AbstractPaginatedCollection<T> emptyCollection() {
        return new PantherPagination();
    }

    @SafeVarargs
    @Note(value="It is noted that this collection is modifiable and contains the following elements")
    public static <T> @Note(value="It is noted that this collection is modifiable and contains the following elements") AbstractPaginatedCollection<T> of(T ... t) {
        return new PantherPagination<T>(t);
    }

    @Note(value="It is noted that this collection is modifiable and contains the following elements")
    public static <T> @Note(value="It is noted that this collection is modifiable and contains the following elements") AbstractPaginatedCollection<T> of(Collection<T> collection) {
        return new PantherPagination<T>(collection);
    }

    public AbstractPaginatedCollection<T> sort(Comparator<? super T> comparator) {
        this.comparator = comparator;
        return this;
    }

    public AbstractPaginatedCollection<T> filter(Predicate<? super T> predicate) {
        this.predicate = predicate;
        return this;
    }

    public AbstractPaginatedCollection<T> limit(int elementsPer) {
        this.initialElementsPer = elementsPer;
        return this;
    }

    public Deployable<AbstractPaginatedCollection<T>> reorder() {
        return Deployable.of(() -> {
            this.sorted = true;
            HashSet toAdd = new HashSet();
            List<T> toSort = new ArrayList<T>();
            if (this.predicate != null) {
                toSort = this.collection.stream().filter(this.predicate).collect(Collectors.toList());
            }
            if (this.comparator != null) {
                toSort = toSort.isEmpty() ? this.collection.stream().sorted(this.comparator).collect(Collectors.toList()) : toSort.stream().sorted(this.comparator).collect(Collectors.toList());
            }
            if (toSort.isEmpty()) {
                toSort = new ArrayList<T>(this.collection);
            }
            this.collection = toSort;
            int totalPageCount = this.size();
            for (int slot = 1; slot < totalPageCount + 1; ++slot) {
                int page = slot;
                Page.Impl<T> newPage = new Page.Impl<T>(this, slot);
                if (page <= totalPageCount && !toSort.isEmpty()) {
                    int placeholder = 0;
                    int index = 0;
                    --page;
                    for (T value : toSort) {
                        if (page * this.initialElementsPer + placeholder + 1 != ++index || index == page * this.initialElementsPer + this.initialElementsPer + 1) continue;
                        ++placeholder;
                        newPage.add(value);
                    }
                }
                toAdd.add(newPage);
            }
            this.set.addAll(toAdd);
            return this;
        }, 0);
    }

    public Deployable<AbstractPaginatedCollection<T>> reorder(int runtime) {
        return Deployable.of(() -> {
            this.sorted = true;
            HashSet toAdd = new HashSet();
            List<T> toSort = new ArrayList<T>();
            if (this.predicate != null) {
                toSort = this.collection.stream().filter(this.predicate).collect(Collectors.toList());
            }
            if (this.comparator != null) {
                toSort = toSort.isEmpty() ? this.collection.stream().sorted(this.comparator).collect(Collectors.toList()) : toSort.stream().sorted(this.comparator).collect(Collectors.toList());
            }
            if (toSort.isEmpty()) {
                toSort = new ArrayList<T>(this.collection);
            }
            this.collection = toSort;
            int totalPageCount = this.size();
            for (int slot = 1; slot < totalPageCount + 1; ++slot) {
                int page = slot;
                Page.Impl<T> newPage = new Page.Impl<T>(this, slot);
                if (page <= totalPageCount && !toSort.isEmpty()) {
                    int placeholder = 0;
                    int index = 0;
                    --page;
                    for (T value : toSort) {
                        if (page * this.initialElementsPer + placeholder + 1 != ++index || index == page * this.initialElementsPer + this.initialElementsPer + 1) continue;
                        ++placeholder;
                        newPage.add(value);
                    }
                }
                toAdd.add(newPage);
            }
            this.set.addAll(toAdd);
            return this;
        }, runtime);
    }

    @NotNull
    public Set<Page<T>> getPages() {
        return Collections.unmodifiableSet(this.set);
    }

    @Override
    public int size() {
        int totalPageCount = 1;
        if (this.collection.size() % this.initialElementsPer == 0) {
            if (this.collection.size() > 0) {
                totalPageCount = this.collection.size() / this.initialElementsPer;
            }
        } else {
            totalPageCount = this.collection.size() / this.initialElementsPer + 1;
        }
        return totalPageCount;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public boolean isEmpty() {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.isEmpty();
    }

    @Override
    @Note(value="Use this method to also check if this collection contains a specific page!")
    public @Note(value="Use this method to also check if this collection contains a specific page!") boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.set.stream().filter(ts -> ts.getNumber() == ((Integer)o).intValue()).findFirst().orElse(null) != null;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.contains(o);
    }

    @Override
    @NotNull
    public Iterator<Page<T>> iterator() {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.stream().sorted(Comparator.comparingInt(Page::getNumber)).iterator();
    }

    @Override
    public Object[] toArray() {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.stream().sorted(Comparator.comparingInt(Page::getNumber)).toArray(Object[]::new);
    }

    @Override
    @NotNull
    public <R> R[] toArray(R[] a) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.toArray(a);
    }

    @Note(value="This works differently than the normal get index method! Make sure you call AbstractPaginatedCollection#contains(Object) first on the index or 'page' you want.")
    @NotNull
    public @Note(value="This works differently than the normal get index method! Make sure you call AbstractPaginatedCollection#contains(Object) first on the index or 'page' you want.") @NotNull Page<T> get(int index) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.stream().sorted(Comparator.comparingInt(Page::getNumber)).filter(p -> p.getNumber() == index).findFirst().orElseGet(() -> {
            Page.Impl newOne = new Page.Impl(this, index);
            this.add(newOne);
            return newOne;
        });
    }

    @Override
    @Note(value="Add a custom page to this pagination collection")
    public @Note(value="Add a custom page to this pagination collection") boolean add(Page<T> tPage) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.add(tPage);
    }

    @Note(value="Add a custom page to this pagination collection")
    public @Note(value="Add a custom page to this pagination collection") boolean add(Consumer<Page<T>> consumer, int page) {
        Page.Impl newIn = new Page.Impl(this, page);
        consumer.accept(newIn);
        this.add(newIn);
        return true;
    }

    public boolean add(T t, int page) {
        Page<T> test;
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        if ((test = this.get(page)) != null) {
            return test.add(t);
        }
        Page.Impl<T> p = new Page.Impl<T>(this, page);
        p.add(t);
        this.add(p);
        return true;
    }

    @Override
    @Note(value="Add remove a page from this pagination collection")
    public @Note(value="Add remove a page from this pagination collection") boolean remove(Object o) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.remove(o);
    }

    public boolean remove(T t, int page) {
        Page<T> test;
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        if ((test = this.get(page)) != null) {
            return test.remove(t);
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Page<T>> c) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (this.set.isEmpty() && !this.collection.isEmpty()) {
            this.reorder().deploy().submit().join();
        }
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }
}

