/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.container.PantherList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Scanner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJarScanner
implements Iterator<String> {
    File file = null;
    Scanner scanner = null;

    protected AbstractJarScanner(@NotNull InputStream stream) {
        this.initialize(stream);
    }

    public AbstractJarScanner(@NotNull JarFile file, @NotNull String entry) throws IllegalStateException {
        InputStream stream;
        try {
            JarEntry e = file.getJarEntry(entry);
            if (e == null) {
                throw new IOException();
            }
            stream = file.getInputStream(e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Jar entry '" + entry + "' not found in file " + file.getName());
        }
        if (stream != null) {
            this.initialize(stream);
        }
    }

    void initialize(@NotNull InputStream stream) {
        try {
            int read;
            File file = File.createTempFile(UUID.nameUUIDFromBytes(stream.toString().getBytes(StandardCharsets.UTF_8)).toString(), ".pif");
            file.deleteOnExit();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            ((OutputStream)out).close();
            this.file = file;
            this.scanner = new Scanner(file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file", e);
        }
    }

    @Override
    public void remove() {
        this.scanner.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super String> action) {
        this.scanner.forEachRemaining(action);
    }

    @Override
    public boolean hasNext() {
        return this.scanner.hasNext();
    }

    @Override
    public String next() {
        return this.scanner.next();
    }

    @NotNull
    public File toFile() {
        return this.file;
    }

    @NotNull
    public String[] scan() {
        PantherList l = new PantherList();
        do {
            l.add(this.next());
        } while (this.hasNext());
        return (String[])l.stream().toArray(String[]::new);
    }
}

