/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.util;

import com.github.sanctum.panther.annotation.Comment;
import com.github.sanctum.panther.annotation.Experimental;
import com.github.sanctum.panther.container.ImmutablePantherMap;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.util.Check;
import com.github.sanctum.panther.util.PantherLogger;
import com.github.sanctum.panther.util.ResourceLookup;
import com.github.sanctum.panther.util.WrongLoaderUsedException;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClassLoader<T>
extends URLClassLoader {
    protected final PantherMap<String, Class<?>> classes;
    protected final T mainClass;
    protected ClassLoader bukkitHandler;

    protected AbstractClassLoader(File file, ClassLoader parent, Object ... args) throws IOException {
        this(file, (Object)null, parent, args);
    }

    protected AbstractClassLoader(@NotNull File file, @Nullable(value="Plugin class/instance or classloader.") @Nullable(value="Plugin class/instance or classloader.") Object bukkit, ClassLoader parent, Object ... args) throws IOException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Class main = new TypeToken<T>(this.getClass()){}.getRawType();
        Logger logger = PantherLogger.getInstance().getLogger();
        PantherEntryMap loadedClasses = new PantherEntryMap();
        if (!file.isFile()) {
            throw new IllegalArgumentException("The provided file is not a jar file!");
        }
        if (bukkit != null) {
            this.setBukkitHandler(bukkit);
        }
        new JarFile(file).stream().map(ZipEntry::getName).filter(entryName -> entryName.contains(".class") && !entryName.contains("$")).map(classPath -> classPath.replace('/', '.')).map(className -> className.substring(0, className.length() - 6)).forEach(s -> {
            Class<?> resolvedClass;
            try {
                resolvedClass = this.loadClass((String)s, true);
            }
            catch (ClassNotFoundException e) {
                logger.warning(() -> "Unable to inject '" + s + "'");
                logger.warning(e::getMessage);
                return;
            }
            logger.finest(() -> "Loaded '" + s + "' successfully.");
            if (bukkit != null) {
                this.getBukkitClassMap().put((String)s, resolvedClass);
            }
            loadedClasses.put((String)s, resolvedClass);
        });
        this.classes = loadedClasses;
        if (!Check.isNull(main) && !main.equals(Object.class)) {
            try {
                Class addonClass = loadedClasses.values().stream().filter(main::isAssignableFrom).findFirst().map(aClass -> aClass).get();
                if (args != null && args.length > 0) {
                    Constructor<?> constructor = null;
                    block3: for (Constructor<?> con : main.getConstructors()) {
                        if (args.length != con.getParameters().length) continue;
                        int success = 0;
                        for (int i = 0; i < args.length; ++i) {
                            Class<?> typeClass;
                            Class<?> objectClass = args[i].getClass();
                            if (objectClass.isAssignableFrom(typeClass = con.getParameters()[i].getType())) {
                                ++success;
                            }
                            if (success != args.length) continue;
                            constructor = con;
                            continue block3;
                        }
                    }
                    this.mainClass = constructor != null ? addonClass.getDeclaredConstructor(constructor.getParameterTypes()).newInstance(args) : addonClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.mainClass = addonClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalStateException("Constructor not public", ex);
            }
            catch (InstantiationException ex) {
                throw new IllegalStateException("Constructor parameter mismatch", ex);
            }
        } else {
            this.mainClass = null;
        }
    }

    @Comment(value="Set the class loader of a bukkit object")
    void setBukkitHandler(@NotNull Object handler) {
        this.bukkitHandler = handler instanceof ClassLoader ? (ClassLoader)handler : (handler instanceof Class ? ((Class)handler).getClassLoader() : handler.getClass().getClassLoader());
    }

    public T getMainClass() {
        return this.mainClass;
    }

    public PantherCollection<Class<?>> getClasses() {
        return new PantherList(this.classes.values());
    }

    public PantherMap<String, Class<?>> getClassMap() {
        return ImmutablePantherMap.of(this.classes);
    }

    public ResourceLookup getLookup() {
        return new ResourceLookup(this);
    }

    public ResourceLookup getLookup(@NotNull String packageName) {
        return new ResourceLookup(this, packageName);
    }

    @Experimental
    public boolean unload(String name) throws ClassNotFoundException {
        if (this.classes.containsKey(name)) {
            this.classes.remove(name);
            if (this.bukkitHandler != null) {
                this.getBukkitClassMap().remove(name);
            }
            return true;
        }
        throw new ClassNotFoundException("Class " + name + " not found, cannot unload.");
    }

    @Experimental
    public boolean unload(Class<?> clazz) throws WrongLoaderUsedException {
        String name = clazz.getName().replace("/", ".").substring(0, clazz.getName().length() - 6);
        if (!this.classes.containsKey(name)) {
            throw new WrongLoaderUsedException("Class " + clazz.getName() + " does not belong to this loader!");
        }
        this.classes.remove(name);
        if (this.bukkitHandler != null) {
            this.getBukkitClassMap().remove(name);
        }
        return true;
    }

    @Comment(value="A reflection getter for internally supporting bukkit. Yes its this easy.")
    @Comment(value="A reflection getter for internally supporting bukkit. Yes its this easy.") Map<String, Class<?>> getBukkitClassMap() throws IllegalStateException {
        try {
            Field f = Class.forName("org.bukkit.plugin.java.PluginClassLoader").getDeclaredField("classes");
            f.setAccessible(true);
            return (Map)f.get(this.bukkitHandler);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "AbstractClassLoader{classes=" + this.classes + ", mainClass=" + this.mainClass + ", bukkitHandler=" + (this.bukkitHandler != null) + '}';
    }
}

