/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.recursive;

import com.github.sanctum.panther.util.TypeAdapter;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class ServiceLoader {
    final Class<?> classHandle;
    Supplier<?> serviceSupplier;
    Object service;

    public ServiceLoader(@NotNull Class<?> handle) {
        this.classHandle = handle;
    }

    public <R> ServiceLoader supply(@NotNull R service) {
        if (!this.classHandle.isAssignableFrom(service.getClass())) {
            throw new IllegalStateException("Class " + service.getClass().getSimpleName() + " does not inherit from " + this.classHandle.getSimpleName());
        }
        this.service = service;
        return this;
    }

    public <R> ServiceLoader supplyFresh(@NotNull Supplier<R> supplier) {
        TypeAdapter adapter = TypeAdapter.get();
        if (!this.classHandle.isAssignableFrom(adapter.getType())) {
            throw new IllegalStateException("Class " + adapter.getType().getSimpleName() + " does not inherit from " + this.classHandle.getSimpleName());
        }
        this.serviceSupplier = supplier;
        return this;
    }

    @NotNull(value="A service must be initialized!")
    public <R> @NotNull(value="A service must be initialized!") R load() {
        Class<?> c = this.classHandle;
        return (R)(this.service != null ? c.cast(this.service) : c.cast(this.serviceSupplier.get()));
    }
}

