/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.recursive;

import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.recursive.Service;
import com.github.sanctum.panther.recursive.ServiceLoader;
import com.github.sanctum.panther.recursive.ServiceManager;
import com.github.sanctum.panther.util.PantherLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceFactory
implements ServiceManager {
    static ServiceManager instance;
    final PantherMap<Class<?>, ServiceLoader> services = new PantherEntryMap();

    ServiceFactory() {
    }

    @NotNull
    public static ServiceManager getInstance() {
        return instance != null ? instance : (instance = new ServiceFactory());
    }

    public static void setInstance(@NotNull ServiceManager in) {
        instance = in;
    }

    @NotNull
    public static ServiceManager newInstance() {
        return new ServiceFactory();
    }

    @Override
    @Nullable
    public ServiceLoader getLoader(@NotNull Class<?> clazz) {
        return this.services.get(clazz);
    }

    @Override
    @NotNull
    public ServiceLoader newLoader(@NotNull Class<?> clazz) {
        if (this.services.containsKey(clazz)) {
            return this.services.get(clazz);
        }
        if (!Service.class.isAssignableFrom(clazz)) {
            if (!clazz.isAnnotationPresent(Service.Tag.class)) {
                throw new NullPointerException("Not a known service, services require inheritance from the interface Service or needs a Service.Tag class annotation!");
            }
            Service.Tag r = clazz.getAnnotation(Service.Tag.class);
            PantherLogger.getInstance().getLogger().finest("Registered new annotative service loader: {" + clazz.getName() + "}: [" + '\"' + r.value() + '\"' + "]");
        }
        ServiceLoader loader = new ServiceLoader(clazz);
        this.services.put(clazz, loader);
        return loader;
    }

    @Override
    @Nullable
    public <T> T getService(@NotNull Class<T> clazz) {
        ServiceLoader loader = this.getLoader(clazz);
        if (loader != null) {
            return (T)loader.load();
        }
        this.newLoader(clazz);
        return null;
    }
}

