/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.placeholder;

import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.placeholder.Placeholder;
import com.github.sanctum.panther.placeholder.PlaceholderTranslationUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlaceholderRegistration {
    static PlaceholderTranslationUtility instance;
    static final PantherMap<String, Map<String, Placeholder>> history;

    @NotNull
    public static PlaceholderRegistration getInstance() {
        if (instance == null) {
            instance = new PlaceholderTranslationUtility(){};
        }
        return PlaceholderRegistration.instance.registration;
    }

    public abstract void registerTranslation(@NotNull Placeholder.Translation var1);

    public abstract void unregisterTranslation(@NotNull Placeholder.Translation var1);

    public abstract Placeholder.Translation getTranslation(@NotNull Placeholder.Identifier var1);

    public abstract Placeholder.Translation getTranslation(@NotNull String var1);

    public abstract void runAction(@NotNull Consumer<Placeholder.Translation> var1);

    public abstract boolean isRegistered(@NotNull Placeholder.Translation var1);

    public abstract boolean isEmpty(@NotNull String var1);

    public abstract boolean isEmpty(@NotNull String var1, @Nullable Placeholder.Identifier var2);

    @NotNull
    public abstract String replaceAll(@NotNull String var1);

    @NotNull
    public abstract String replaceAll(@NotNull String var1, @Nullable Object var2);

    @NotNull
    public abstract String replaceAll(@NotNull String var1, @Nullable Placeholder.Variable var2);

    @NotNull
    public abstract String replaceAll(@NotNull String var1, @Nullable Placeholder.Variable var2, Placeholder var3);

    @NotNull
    public abstract String replaceAll(@NotNull String var1, @Nullable Placeholder.Variable var2, @Nullable Placeholder.Identifier var3, @NotNull Placeholder var4);

    @NotNull
    public abstract String replaceAll(@NotNull String var1, @NotNull Placeholder var2, @NotNull String var3);

    @Nullable
    public abstract String findFirst(@NotNull String var1, @NotNull Placeholder var2);

    @NotNull
    public abstract PantherCollection<String> findAny(@NotNull String var1, @NotNull Placeholder var2);

    @NotNull
    public abstract Placeholder[] findAny(@NotNull String var1, @NotNull Placeholder.Translation var2);

    public final PantherMap<Placeholder.Identifier, List<Placeholder>> getHistory() {
        PantherEntryMap<Placeholder.Identifier, List<Placeholder>> map = new PantherEntryMap<Placeholder.Identifier, List<Placeholder>>();
        history.forEach(entry -> {
            Placeholder.Identifier identifier = entry::getKey;
            ArrayList placeholders = new ArrayList(((Map)entry.getValue()).values());
            map.put(identifier, placeholders);
        });
        return map;
    }

    static {
        history = new PantherEntryMap<String, Map<String, Placeholder>>();
    }
}

