/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.file;

import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.file.AbstractJsonConfiguration;
import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.JsonAdapterInput;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.util.EasyTypeAdapter;
import com.github.sanctum.panther.util.MapDecompression;
import com.github.sanctum.panther.util.PantherLogger;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JsonConfiguration
extends AbstractJsonConfiguration {
    private final File file;
    private final File parent;
    private final String name;
    private final String directory;
    protected PantherMap<String, Object> map;
    protected JSONObject json;
    private final JSONParser parser = new JSONParser();

    public JsonConfiguration(@NotNull File folder, @NotNull String name, @Nullable String directory) {
        File parent;
        this.name = name;
        this.directory = directory;
        if (!folder.exists()) {
            folder.mkdir();
        }
        File file = parent = directory == null || directory.isEmpty() ? folder : new File(folder, directory);
        if (!parent.exists()) {
            parent.mkdir();
        }
        this.parent = parent;
        this.file = new File(parent, name.concat(".json"));
        File toRemove = new File(parent, name.concat(".data"));
        if (toRemove.exists()) {
            try {
                this.load(toRemove);
            }
            catch (Exception ex) {
                this.json = new JSONObject();
                this.map = new PantherEntryMap<String, Object>();
            }
            if (toRemove.delete()) {
                this.save();
            }
        } else {
            try {
                this.load(this.file);
            }
            catch (Exception ex) {
                this.json = new JSONObject();
                this.map = new PantherEntryMap<String, Object>();
            }
        }
    }

    public boolean load(@NotNull File file) throws Exception {
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            this.json = (JSONObject)this.parser.parse((Reader)reader);
            reader.close();
            fileInputStream.close();
            return true;
        }
        this.json = new JSONObject();
        return false;
    }

    @Override
    public void reload() {
        try {
            if (!this.load(this.file)) {
                PrintWriter writer = new PrintWriter(this.file, StandardCharsets.UTF_8.toString());
                writer.print("{");
                writer.print("}");
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean save() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);
            Gson g = JsonAdapter.getJsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().serializeNulls().serializeSpecialFloatingPointValues().create();
            g.toJson((Object)this.json, Map.class, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            return true;
        }
        catch (Exception ex) {
            PantherLogger.getInstance().getLogger().severe("- An object of unknown origin was attempted to be saved and failed.");
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean delete() {
        this.memory.clear();
        return this.file.delete();
    }

    @Override
    public boolean create() throws IOException {
        if (this.parent.exists()) {
            if (!this.file.exists()) {
                this.reload();
                return true;
            }
            return false;
        }
        return this.parent.mkdirs() && this.file.createNewFile();
    }

    @Override
    public boolean exists() {
        return this.parent.exists() && this.file.exists();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public File getParent() {
        return this.file;
    }

    @Override
    public void set(String key, Object o) {
        String[] a = key.split("\\.");
        String k = a[Math.max(0, a.length - 1)];
        JSONObject ob = this.json;
        for (int i = 0; i < a.length - 1; ++i) {
            String pathKey = a[i];
            Object os = ob.get((Object)pathKey);
            if (os instanceof JSONObject) {
                ob = (JSONObject)os;
                continue;
            }
            JSONObject n = new JSONObject();
            ob.put((Object)pathKey, (Object)n);
            ob = (JSONObject)ob.get((Object)pathKey);
        }
        if (o == null) {
            ob.remove((Object)k);
            return;
        }
        if (o instanceof Map) {
            ob.put((Object)k, (Object)new JSONObject((Map)o));
            return;
        }
        if (o instanceof Collection) {
            JSONArray ar = new JSONArray();
            ar.addAll((Collection)((List)o));
            ob.put((Object)k, (Object)ar);
            return;
        }
        ob.put((Object)k, o);
    }

    Object deserializeType(Type type, boolean array, Object object) {
        Object target = object;
        try {
            Class<?> cl = Class.forName(type.getTypeName());
            if (target instanceof JSONObject) {
                JSONObject j = (JSONObject)object;
                Gson g = JsonAdapter.getJsonBuilder().create();
                Map.Entry d = serializers.entrySet().stream().filter(de -> ((String)de.getKey()).equals(cl.getTypeName()) || cl.isAssignableFrom(((JsonAdapterInput)de.getValue()).getSerializationSignature())).findFirst().orElse(null);
                if (d != null && j.containsKey(d.getKey())) {
                    Object o;
                    Object ob = j.get(d.getKey());
                    if (ob instanceof String) {
                        Map map = (Map)g.fromJson((String)ob, new EasyTypeAdapter());
                        o = ((JsonAdapterInput)d.getValue()).read(map);
                    } else {
                        o = ((JsonAdapterInput)d.getValue()).read((Map)ob);
                    }
                    if (o != null) {
                        target = o;
                    }
                }
                return target;
            }
            if (target instanceof JSONArray && array) {
                JSONArray j = (JSONArray)object;
                Map.Entry d = serializers.entrySet().stream().filter(de -> cl.isAssignableFrom(((JsonAdapterInput)de.getValue()).getSerializationSignature())).findFirst().orElse(null);
                if (d != null) {
                    Object[] copy = (Object[])Array.newInstance(cl, j.size());
                    for (int i = 0; i < j.size(); ++i) {
                        Map map = (Map)j.get(i);
                        copy[i] = ((JsonAdapterInput)d.getValue()).read(map.containsKey(d.getKey()) ? (Map)map.get(d.getKey()) : map);
                    }
                    target = copy;
                }
            }
        }
        catch (ClassNotFoundException exception) {
            PantherLogger.getInstance().getLogger().severe("- An issue occurred while attempting to deserialize object " + type.getTypeName());
            exception.printStackTrace();
        }
        return target;
    }

    @Override
    public Object get(String key) {
        String[] a = key.split("\\.");
        String k = a[Math.max(0, a.length - 1)];
        JSONObject o = this.json;
        for (int i = 0; i < a.length - 1; ++i) {
            JSONObject js;
            String pathKey = a[i];
            Object obj = o.get((Object)pathKey);
            if (obj instanceof JSONObject) {
                js = (JSONObject)obj;
                if (js.containsKey((Object)k)) {
                    return js.get((Object)k);
                }
            } else {
                return obj;
            }
            o = js;
        }
        return o.get((Object)k);
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        boolean stop = false;
        Object ob = null;
        String[] a = key.split("\\.");
        String k = a[Math.max(0, a.length - 1)];
        JSONObject o = this.json;
        for (int i = 0; i < a.length - 1; ++i) {
            String pathKey = a[i];
            Object obj = o.get((Object)pathKey);
            if (obj instanceof JSONObject) {
                JSONObject js = (JSONObject)obj;
                if (js.containsKey((Object)k)) {
                    ob = this.deserializeType(type, false, js.get((Object)k));
                    stop = true;
                    continue;
                }
                o = js;
                continue;
            }
            ob = this.deserializeType(type.isArray() ? type.getComponentType() : type, obj instanceof JSONArray, obj);
            stop = true;
        }
        if (!stop) {
            Object object = o.get((Object)k);
            ob = this.deserializeType(type.isArray() ? type.getComponentType() : type, object instanceof JSONArray, object);
        }
        if (ob == null) {
            return null;
        }
        if (!type.isArray() && !type.isAssignableFrom(ob.getClass())) {
            return null;
        }
        return type.cast(ob);
    }

    @Override
    public Node getNode(String key) {
        return (Node)this.memory.entrySet().stream().filter(n -> ((String)n.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElseGet(() -> {
            Configurable.Node n = new Configurable.Node(key, this);
            this.memory.put(n.getPath(), n);
            return n;
        });
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        if (deep) {
            return MapDecompression.getInstance().decompress(this.json.entrySet(), '.', null).toSet();
        }
        HashSet<String> keys = new HashSet<String>(this.json.keySet());
        return keys;
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (deep) {
            return MapDecompression.getInstance().decompress(this.json.entrySet(), '.', null).toMap();
        }
        this.json.entrySet().forEach(e -> {
            Map.Entry entry = (Map.Entry)e;
            map.put((String)entry.getKey(), entry.getValue());
        });
        return map;
    }

    @Override
    public String getString(String key) {
        Object o = this.get(key);
        return String.valueOf(o);
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    @Override
    public boolean isList(String key) {
        return this.get(key) instanceof List;
    }

    @Override
    public boolean isStringList(String key) {
        return !this.getStringList(key).isEmpty();
    }

    @Override
    public boolean isFloatList(String key) {
        return !this.getFloatList(key).isEmpty();
    }

    @Override
    public boolean isDoubleList(String key) {
        return !this.getDoubleList(key).isEmpty();
    }

    @Override
    public boolean isLongList(String key) {
        return !this.getLongList(key).isEmpty();
    }

    @Override
    public boolean isIntegerList(String key) {
        return !this.getIntegerList(key).isEmpty();
    }

    @Override
    public boolean isBoolean(String key) {
        return this.get(key) instanceof Boolean;
    }

    @Override
    public boolean isDouble(String key) {
        return this.get(key) instanceof Double;
    }

    @Override
    public boolean isInt(String key) {
        return this.get(key) instanceof Integer;
    }

    @Override
    public boolean isLong(String key) {
        return this.get(key) instanceof Long;
    }

    @Override
    public boolean isFloat(String key) {
        return this.get(key) instanceof Float;
    }

    @Override
    public boolean isString(String key) {
        return this.get(key) instanceof String;
    }

    @Override
    public String getPath() {
        String s = "/" + this.getName() + "/";
        if (this.getDirectory() != null) {
            s = s + this.getDirectory();
        }
        return s;
    }

    @Override
    public boolean isNode(String key) {
        String[] a = key.split("\\.");
        String k = a[Math.max(0, a.length - 1)];
        JSONObject o = this.json;
        for (int i = 0; i < a.length - 1; ++i) {
            String pathKey = a[i];
            Object obj = o.get((Object)pathKey);
            if (!(obj instanceof JSONObject)) continue;
            JSONObject js = (JSONObject)obj;
            if (js.containsKey((Object)k)) {
                return js.get((Object)k) instanceof JSONObject;
            }
            o = js;
        }
        return o.get((Object)k) instanceof JSONObject;
    }

    @Override
    public double getDouble(String key) {
        try {
            return Double.parseDouble(this.getString(key));
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    @Override
    public long getLong(String key) {
        try {
            return Long.parseLong(this.getString(key));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public float getFloat(String key) {
        try {
            return Float.parseFloat(this.getString(key));
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    @Override
    public int getInt(String key) {
        try {
            return Integer.parseInt(this.getString(key));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public Map<?, ?> getMap(String key) {
        Object o = this.get(key);
        if (o instanceof Map) {
            return (Map)o;
        }
        return new HashMap();
    }

    @Override
    public List<?> getList(String key) {
        Object o = this.get(key);
        if (o instanceof List) {
            return (List)o;
        }
        return new ArrayList();
    }

    @Override
    public List<String> getStringList(String key) {
        List<String> l = this.getList(key);
        if (l.isEmpty()) {
            return new ArrayList<String>();
        }
        if (!(l.get(0) instanceof String)) {
            return new ArrayList<String>();
        }
        return l;
    }

    @Override
    public List<Integer> getIntegerList(String key) {
        List<Integer> l = this.getList(key);
        if (l.isEmpty()) {
            return new ArrayList<Integer>();
        }
        if (!(l.get(0) instanceof Integer) || !(l.get(0) instanceof Long)) {
            return new ArrayList<Integer>();
        }
        return l;
    }

    @Override
    public List<Double> getDoubleList(String key) {
        List<Double> l = this.getList(key);
        if (l.isEmpty()) {
            return new ArrayList<Double>();
        }
        if (!(l.get(0) instanceof Double) || !(l.get(0) instanceof Float)) {
            return new ArrayList<Double>();
        }
        return l;
    }

    @Override
    public List<Float> getFloatList(String key) {
        List<Float> l = this.getList(key);
        if (l.isEmpty()) {
            return new ArrayList<Float>();
        }
        if (!(l.get(0) instanceof Float) || !(l.get(0) instanceof Double)) {
            return new ArrayList<Float>();
        }
        return l;
    }

    @Override
    public List<Long> getLongList(String key) {
        List<Long> l = this.getList(key);
        if (l.isEmpty()) {
            return new ArrayList<Long>();
        }
        if (!(l.get(0) instanceof Long) || !(l.get(0) instanceof Integer)) {
            return new ArrayList<Long>();
        }
        return l;
    }
}

