/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.file;

import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.file.Generic;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.file.Primitive;
import com.github.sanctum.panther.util.MapDecompression;
import com.github.sanctum.panther.util.OrdinalProcedure;
import com.github.sanctum.panther.util.PantherLogger;
import com.github.sanctum.panther.util.SimpleAsynchronousTask;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ConfigurableNodeImpl
implements Node,
Primitive {
    protected final Configurable config;
    protected final String key;

    ConfigurableNodeImpl(String key, Configurable configuration) {
        this.config = configuration;
        this.key = key;
    }

    @Override
    public boolean isNode(String key) {
        return this.config.isNode(this.key + "." + key);
    }

    @Override
    public Node getNode(String node) {
        return (Node)Optional.ofNullable(this.config.memory.get(this.key + "." + node)).orElseGet(() -> {
            ConfigurableNodeImpl n = new ConfigurableNodeImpl(this.key + "." + node, this.config);
            this.config.memory.put(n.getPath(), n);
            return n;
        });
    }

    @Override
    public Object get() {
        return this.config.get(this.key);
    }

    @Override
    public Primitive toPrimitive() {
        return this;
    }

    @Override
    public <T extends Generic> T toGeneric(@NotNull Class<T> clazz) {
        Generic gen = this.config.processors.get(clazz);
        if (gen != null) {
            OrdinalProcedure.of(gen).get(20, this).get();
            return (T)gen;
        }
        throw new NullPointerException(clazz + " does not have a registered instance within this configurable!");
    }

    @Override
    public String getString() {
        return this.config.getString(this.key);
    }

    @Override
    public int getInt() {
        return this.config.getInt(this.key);
    }

    @Override
    public boolean getBoolean() {
        return this.config.getBoolean(this.key);
    }

    @Override
    public double getDouble() {
        return this.config.getDouble(this.key);
    }

    @Override
    public float getFloat() {
        return this.config.getFloat(this.key);
    }

    @Override
    public long getLong() {
        return this.config.getLong(this.key);
    }

    @Override
    public List<?> getList() {
        return this.config.getList(this.key);
    }

    @Override
    public Map<?, ?> getMap() {
        return this.config.getMap(this.key);
    }

    @Override
    public List<String> getStringList() {
        return this.config.getStringList(this.key);
    }

    @Override
    public List<Integer> getIntegerList() {
        return this.config.getIntegerList(this.key);
    }

    @Override
    public List<Double> getDoubleList() {
        return this.config.getDoubleList(this.key);
    }

    @Override
    public List<Float> getFloatList() {
        return this.config.getFloatList(this.key);
    }

    @Override
    public List<Long> getLongList() {
        return this.config.getLongList(this.key);
    }

    @Override
    public boolean isString() {
        return this.config.isString(this.key);
    }

    @Override
    public boolean isBoolean() {
        return this.config.isBoolean(this.key);
    }

    @Override
    public boolean isInt() {
        return this.config.isInt(this.key);
    }

    @Override
    public boolean isDouble() {
        return this.config.isDouble(this.key);
    }

    @Override
    public boolean isFloat() {
        return this.config.isFloat(this.key);
    }

    @Override
    public boolean isLong() {
        return this.config.isLong(this.key);
    }

    @Override
    public boolean isList() {
        return this.config.isList(this.key);
    }

    @Override
    public boolean isStringList() {
        return this.config.isStringList(this.key);
    }

    @Override
    public boolean isFloatList() {
        return this.config.isFloatList(this.key);
    }

    @Override
    public boolean isDoubleList() {
        return this.config.isDoubleList(this.key);
    }

    @Override
    public boolean isIntegerList() {
        return this.config.isIntegerList(this.key);
    }

    @Override
    public boolean isLongList() {
        return this.config.isLongList(this.key);
    }

    @Override
    public <T> T get(Class<T> type) {
        T o = this.config.get(this.key, type);
        if (o != null) {
            return o;
        }
        return null;
    }

    @Override
    public String getPath() {
        return this.key;
    }

    @Override
    public boolean delete() {
        if (this.config.isNode(this.key)) {
            this.config.set(this.key, null);
            SimpleAsynchronousTask.runNow(() -> this.config.memory.remove(this.key));
            return true;
        }
        return false;
    }

    @Override
    public void reload() {
        this.config.reload();
    }

    @Override
    public boolean create() {
        if (!this.config.exists()) {
            try {
                this.config.create();
            }
            catch (IOException ex) {
                PantherLogger.getInstance().getLogger().severe("- An issue occurred while attempting to create the backing file for the '" + this.config.getName() + "' configuration.");
                ex.printStackTrace();
            }
        }
        if (this.config.getType() == Configurable.Type.JSON) {
            this.set(new Object());
        }
        this.save();
        return false;
    }

    @Override
    public boolean exists() {
        return this.isNode(this.key) || this.get() != null;
    }

    @Override
    public boolean save() {
        return this.config.save();
    }

    @Override
    public void set(Object o) {
        this.config.set(this.key, o);
    }

    @Override
    public Node getParent() {
        String[] k = this.key.split("//.");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < k.length - 1; ++i) {
            builder.append(k[i]).append(".");
        }
        String key = builder.toString();
        if (key.endsWith(".")) {
            key = key.substring(0, builder.length() - 1);
        }
        if (key.equals(this.key)) {
            return this;
        }
        return this.getNode(key);
    }

    @Override
    public String toJson() {
        return JsonAdapter.getJsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().serializeNulls().setLenient().serializeSpecialFloatingPointValues().create().toJson(this.get());
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        HashSet<String> keys = new HashSet<String>();
        if (this.config.get(this.key) instanceof Map) {
            Map level1 = (Map)this.config.get(this.key);
            if (deep) {
                return MapDecompression.getInstance().decompress(level1.entrySet(), '.', null).toSet();
            }
            keys.addAll(level1.keySet());
        } else {
            keys.add(this.key);
        }
        return keys;
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.config.get(this.key) instanceof Map) {
            Map level1 = (Map)this.config.get(this.key);
            if (deep) {
                return MapDecompression.getInstance().decompress(level1.entrySet(), '.', null).toMap();
            }
            map.putAll(level1);
        } else {
            map.put(this.key, this.get());
        }
        return map;
    }
}

