/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.file;

import com.github.sanctum.panther.annotation.AnnotationDiscovery;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherCollectors;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.file.AbstractJsonConfiguration;
import com.github.sanctum.panther.file.AbstractYamlConfiguration;
import com.github.sanctum.panther.file.ConfigurableEditorQuery;
import com.github.sanctum.panther.file.ConfigurableNodeImpl;
import com.github.sanctum.panther.file.DataTable;
import com.github.sanctum.panther.file.Generic;
import com.github.sanctum.panther.file.InvalidJsonAdapterException;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.JsonAdapterInput;
import com.github.sanctum.panther.file.JsonConfiguration;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.file.Root;
import com.github.sanctum.panther.file.handler.EditorHandle;
import com.github.sanctum.panther.file.handler.NonExistentParentException;
import com.github.sanctum.panther.util.OrdinalProcedure;
import com.github.sanctum.panther.util.PantherLogger;
import com.github.sanctum.panther.util.TypeAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Configurable
implements MemorySpace,
Root {
    protected static final Map<String, JsonAdapterInput<?>> serializers = new HashMap();
    protected static final PantherCollection<Handle> handlers = new PantherList<Handle>();
    protected final Map<String, MemorySpace> memory = new HashMap<String, MemorySpace>();
    protected final PantherMap<Class<?>, Generic> processors = new PantherEntryMap();

    public final void register(@NotNull Generic processor) {
        this.processors.put(processor.getClass(), processor);
    }

    public final void unregister(@NotNull Generic processor) {
        this.processors.remove(processor.getClass());
    }

    public abstract Object get(String var1);

    public abstract <T> T get(String var1, Class<T> var2);

    public abstract void set(String var1, Object var2);

    public abstract String getString(String var1);

    public abstract boolean getBoolean(String var1);

    public abstract double getDouble(String var1);

    public abstract long getLong(String var1);

    public abstract float getFloat(String var1);

    public abstract int getInt(String var1);

    public abstract Map<?, ?> getMap(String var1);

    public abstract List<?> getList(String var1);

    public abstract List<String> getStringList(String var1);

    public abstract List<Integer> getIntegerList(String var1);

    public abstract List<Double> getDoubleList(String var1);

    public abstract List<Float> getFloatList(String var1);

    public abstract List<Long> getLongList(String var1);

    public abstract boolean isList(String var1);

    public abstract boolean isStringList(String var1);

    public abstract boolean isFloatList(String var1);

    public abstract boolean isDoubleList(String var1);

    public abstract boolean isLongList(String var1);

    public abstract boolean isIntegerList(String var1);

    public abstract boolean isBoolean(String var1);

    public abstract boolean isDouble(String var1);

    public abstract boolean isInt(String var1);

    public abstract boolean isLong(String var1);

    public abstract boolean isFloat(String var1);

    public abstract boolean isString(String var1);

    public abstract String getName();

    public abstract String getDirectory();

    public abstract File getParent();

    public Extension getType() {
        return Type.UNKNOWN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Configurable) {
            Configurable c = (Configurable)obj;
            return Objects.equals(this.getName(), c.getName()) && Objects.equals(this.getDirectory(), c.getDirectory()) && this.getType() == c.getType();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getDirectory(), this.getType().toString());
    }

    public static ConfigurableEditorQuery view(@NotNull Host host) {
        return ConfigurableEditorQuery.REGISTRY.computeIfAbsent(host.getName(), name -> new ConfigurableEditorQuery(host));
    }

    public static void registerClass(@NotNull Class<? extends JsonAdapter<?>> c) throws InvalidJsonAdapterException {
        try {
            String alias;
            JsonAdapter<?> d;
            AnnotationDiscovery<Node.Pointer, JsonAdapter<?>> test = AnnotationDiscovery.of(Node.Pointer.class, c);
            if (test.isPresent()) {
                d = null;
                alias = test.mapFromClass((r, u) -> r.value());
                if (alias != null && !alias.isEmpty()) {
                    Class n = test.mapFromClass((r, u) -> r.type());
                    d = n != null ? (!JsonAdapter.Dummy.class.isAssignableFrom(n) ? (JsonAdapter<?>)n.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) : c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    Class n = test.mapFromClass((r, u) -> r.type());
                    if (n != null) {
                        d = !JsonAdapter.Dummy.class.isAssignableFrom(n) ? (JsonAdapter<?>)n.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        alias = c.getSimpleName();
                    }
                }
                if (d == null) {
                    throw new InvalidJsonAdapterException("NodePointer context missing, JSON object serialization requires either an alias or class.");
                }
            } else {
                throw new InvalidJsonAdapterException("NodePointer annotation missing, JSON object serialization requires it.");
            }
            serializers.put(alias, new JsonAdapterInput.Impl(d));
        }
        catch (Exception e) {
            PantherLogger.getInstance().getLogger().severe("Class " + c.getSimpleName() + " failed to register JSON serialization handlers.");
            e.printStackTrace();
        }
    }

    public static void registerClass(@NotNull Class<? extends JsonAdapter<?>> c, Object ... objects) throws InvalidJsonAdapterException {
        block12: {
            try {
                Class d = null;
                AnnotationDiscovery<Node.Pointer, JsonAdapter<?>> test = AnnotationDiscovery.of(Node.Pointer.class, c);
                if (test.isPresent()) {
                    Class n;
                    String alias = test.mapFromClass((r, u) -> r.value());
                    if (alias != null && !alias.isEmpty()) {
                        n = test.mapFromClass((r, u) -> r.type());
                        d = n != null ? (!JsonAdapter.Dummy.class.isAssignableFrom(n) ? n : c) : c;
                    } else {
                        n = test.mapFromClass((r, u) -> r.type());
                        if (n != null) {
                            d = !JsonAdapter.Dummy.class.isAssignableFrom(n) ? n : c;
                            alias = c.getSimpleName();
                        }
                    }
                    if (d == null) {
                        throw new InvalidJsonAdapterException("NodePointer context missing, JSON object serialization requires either an alias or class.");
                    }
                    Constructor<?> constructor = null;
                    block2: for (Constructor<?> con : d.getConstructors()) {
                        if (objects.length != con.getParameters().length) continue;
                        int success = 0;
                        for (int i = 0; i < objects.length; ++i) {
                            Class<?> typeClass;
                            Class<?> objectClass = objects[i].getClass();
                            if (objectClass.isAssignableFrom(typeClass = con.getParameters()[i].getType())) {
                                ++success;
                            }
                            if (success != objects.length) continue;
                            constructor = con;
                            continue block2;
                        }
                    }
                    if (constructor != null) {
                        serializers.put(alias, new JsonAdapterInput.Impl((JsonAdapter)d.getDeclaredConstructor(constructor.getParameterTypes()).newInstance(objects)));
                    } else {
                        serializers.put(alias, new JsonAdapterInput.Impl((JsonAdapter)d.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                    }
                    break block12;
                }
                throw new InvalidJsonAdapterException("NodePointer annotation missing, JSON object serialization requires it.");
            }
            catch (Exception e) {
                PantherLogger.getInstance().getLogger().severe("Class " + c.getSimpleName() + " failed to register JSON serialization handlers.");
                e.printStackTrace();
            }
        }
    }

    public static <V> JsonAdapter<V> getAdapter(@NotNull Class<V> type) {
        return serializers.entrySet().stream().filter(e -> ((String)e.getKey()).equals(type.getName()) || type.isAssignableFrom(((JsonAdapterInput)e.getValue()).getSerializationSignature())).map(Map.Entry::getValue).map(c -> c).findFirst().orElse(null);
    }

    public static <V> JsonAdapter<V> getAdapter(@NotNull String pointer) {
        return serializers.values().stream().filter(jsonAdapterInput -> pointer.equals(OrdinalProcedure.select(jsonAdapterInput, 24).cast(TypeAdapter.STRING))).map(c -> c).findFirst().orElse(null);
    }

    public static void addHandle(@NotNull Handle handler) {
        handlers.add(handler);
    }

    public static void removeHandle(@NotNull Handle handler) {
        handlers.remove(handler);
    }

    @Nullable
    public static <T extends Handle> T getHandle(Class<T> handle) {
        if (handlers.size() == 0) {
            Configurable.newComposer();
        }
        PantherList handles = handlers.stream().filter(h -> handle.isAssignableFrom(h.getClass())).collect(PantherCollectors.toList());
        return (T)((Handle)handles.getLast());
    }

    @NotNull
    public static <T extends Handle> PantherList<T> getHandles(Class<T> handle) {
        if (handlers.size() == 0) {
            Configurable.newComposer();
        }
        return handlers.stream().filter(h -> handle.isAssignableFrom(h.getClass())).map(handle1 -> handle1).collect(PantherCollectors.toList());
    }

    static void newComposer() {
        Configurable.addHandle(new EditorHandle(){

            @Override
            @NotNull
            public Configurable onInstantiate(@NotNull Host host, @NotNull String name, @Nullable String desc, @NotNull Extension extension) {
                if (extension == Type.JSON) {
                    return new JsonConfiguration(host.getDataFolder(), name, desc);
                }
                if (extension == Type.YAML) {
                    throw new IllegalStateException("The default handler cannot construct yaml file wrappers!");
                }
                throw new IllegalArgumentException("Cannot construct unknown file extension.");
            }

            @Override
            @Nullable
            public InputStream onReset(@NotNull Host host, @NotNull String name, @Nullable String fileName) {
                return null;
            }

            @Nullable
            public <R> R onWriteFromTable(@NotNull R value, @NotNull String key, @NotNull MemorySpace memorySpace, boolean toReplace) {
                if (toReplace) {
                    return value;
                }
                if (!memorySpace.isNode(key)) {
                    return value;
                }
                return null;
            }
        });
    }

    public static class Editor {
        protected final Configurable configuration;
        protected final Host host;

        protected Editor(@NotNull Host host, @NotNull Configurable configuration) {
            this.host = host;
            this.configuration = configuration;
        }

        protected Editor(@NotNull Host host, @NotNull String n, @Nullable String d, Extension data) {
            PantherList<EditorHandle> handles = Configurable.getHandles(EditorHandle.class);
            Configurable configurable = null;
            for (EditorHandle handle : handles) {
                if (handle == null || !data.get().endsWith("data") && !data.get().endsWith("json") && !data.get().endsWith("yml")) continue;
                configurable = handle.onInstantiate(host, n, d, data);
            }
            if (configurable == null) {
                throw new IllegalStateException("Unable to locate the Editor Handle and therefore cannot parse file creation.");
            }
            this.host = host;
            this.configuration = configurable;
        }

        public Configurable getRoot() {
            return this.configuration;
        }

        public <R> R read(Function<Configurable, R> fun) {
            return fun.apply(this.configuration);
        }

        public void write(Consumer<? super DataTable> table) {
            DataTable t = DataTable.newTable();
            table.accept(t);
            this.write(t);
        }

        @Note(value="You can create a fresh DataTable really easily see DataTable#newTable()")
        public void write(@Note(value="Provided table gets cleared upon finalization.") @Note(value="Provided table gets cleared upon finalization.") DataTable table) {
            this.write(table, true);
        }

        @Note(value="You can create a fresh DataTable really easily see DataTable#newTable()")
        public void write(@Note(value="Provided table gets cleared upon finalization.") @Note(value="Provided table gets cleared upon finalization.") DataTable table, boolean replace) {
            PantherList<EditorHandle> handles = Configurable.getHandles(EditorHandle.class);
            for (EditorHandle handle : handles) {
                if (handle != null) {
                    for (Map.Entry<String, Object> entry : table.values().entrySet()) {
                        Object o = handle.onWriteFromTable(entry.getValue(), entry.getKey(), this.configuration, replace);
                        if (o == null) continue;
                        if (o == DataTable.NULL) {
                            this.configuration.set(entry.getKey(), null);
                            continue;
                        }
                        this.configuration.set(entry.getKey(), o);
                    }
                }
                table.clear();
                this.configuration.save();
            }
        }

        @NotNull
        public Editor toJSON(@NotNull String name, String dir) {
            Editor n = Configurable.view(this.host).get(name, dir, Type.JSON);
            Configurable c = this.getRoot();
            if (c instanceof AbstractYamlConfiguration) {
                n.write(this.copy(), false);
                return n;
            }
            return this;
        }

        @NotNull
        public Editor toYaml(@NotNull String name, String dir) {
            Editor n = Configurable.view(this.host).get(name, dir, Type.YAML);
            Configurable c = this.getRoot();
            if (c instanceof AbstractJsonConfiguration) {
                n.write(this.copy(), false);
                return n;
            }
            return this;
        }

        @NotNull
        public Editor toJSON() {
            return this.toJSON(this.getRoot().getName(), this.getRoot().getDirectory());
        }

        @NotNull
        public Editor toYaml() {
            return this.toYaml(this.getRoot().getName(), this.getRoot().getDirectory());
        }

        @NotNull
        public Editor toMoved(String dir) {
            Editor n = Configurable.view(this.host).get(this.getRoot().getName(), dir, this.getRoot().getType());
            Configurable c = this.getRoot();
            n.write(this.copy(), false);
            c.delete();
            return n;
        }

        @NotNull
        public DataTable copy() {
            Configurable c = this.getRoot();
            DataTable inquiry = DataTable.newTable();
            c.getValues(true).forEach(inquiry::set);
            return inquiry;
        }

        @NotNull
        public Editor reset() throws NonExistentParentException {
            PantherList<EditorHandle> handles = Configurable.getHandles(EditorHandle.class);
            for (EditorHandle handle : handles) {
                if (handle == null) continue;
                InputStream stream = handle.onReset(this.host, this.configuration.getName() + this.configuration.getType().get(), null);
                if (stream != null) {
                    this.copy(stream, this.configuration.getParent());
                    this.getRoot().reload();
                    this.getRoot().save();
                    continue;
                }
                throw new NonExistentParentException("There is no file by the name of " + this.configuration.getName() + " in this applications resources.");
            }
            return this;
        }

        @NotNull
        public Editor reset(@NotNull String fileName) throws NonExistentParentException {
            PantherList<EditorHandle> handles = Configurable.getHandles(EditorHandle.class);
            for (EditorHandle handle : handles) {
                if (handle == null) continue;
                InputStream stream = handle.onReset(this.host, this.configuration.getName(), fileName);
                if (stream != null) {
                    this.copy(stream, this.configuration.getParent());
                    this.getRoot().reload();
                    this.getRoot().save();
                    continue;
                }
                throw new NonExistentParentException("There is no file by the name of " + this.configuration.getName() + " in this applications resources.");
            }
            return this;
        }

        @NotNull
        public Editor resetYaml(@NotNull String yamlName) throws NonExistentParentException {
            PantherList<EditorHandle> handles = Configurable.getHandles(EditorHandle.class);
            for (EditorHandle handle : handles) {
                if (handle == null) continue;
                InputStream stream = handle.onReset(this.host, this.configuration.getName(), yamlName + ".yml");
                if (stream != null) {
                    this.copy(stream, this.configuration.getParent());
                    this.getRoot().reload();
                    this.getRoot().save();
                    continue;
                }
                throw new NonExistentParentException("There is no file by the name of " + this.configuration.getName() + " in this applications resources.");
            }
            return this;
        }

        @NotNull
        public Editor resetJson(@NotNull String jsonName) throws NonExistentParentException {
            PantherList<EditorHandle> handles = Configurable.getHandles(EditorHandle.class);
            for (EditorHandle handle : handles) {
                if (handle == null) continue;
                InputStream stream = handle.onReset(this.host, this.configuration.getName(), jsonName + ".json");
                if (stream != null) {
                    this.copy(stream, this.configuration.getParent());
                    this.getRoot().reload();
                    this.getRoot().save();
                    continue;
                }
                throw new NonExistentParentException("There is no file by the name of " + this.configuration.getName() + " in this applications resources.");
            }
            return this;
        }

        void copy(InputStream in, File file) {
            try {
                int len;
                FileOutputStream out = new FileOutputStream(file);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Cannot copy whole directories at a time! (" + file.getPath() + ")", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to write to file! See log:", e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Editor)) {
                return false;
            }
            Editor config = (Editor)o;
            return this.configuration.equals(config.configuration);
        }

        public int hashCode() {
            return this.configuration.hashCode();
        }
    }

    public static class Node
    extends ConfigurableNodeImpl {
        public Node(String key, Configurable configuration) {
            super(key, configuration);
        }
    }

    public static interface Host {
        default public Editor getFile(@NotNull String name, @Nullable String description, @NotNull Extension extension) {
            return Configurable.view(this).get(name, description, extension);
        }

        @NotNull
        public String getName();

        @NotNull
        public File getDataFolder();
    }

    public static interface Extension {
        public String get();

        default public Class<? extends Configurable> getImplementation() {
            return Configurable.class;
        }
    }

    public static enum Type implements Extension
    {
        JSON(AbstractJsonConfiguration.class),
        YAML(AbstractYamlConfiguration.class),
        UNKNOWN(Configurable.class);

        private final Class<? extends Configurable> c;

        private Type(Class<? extends Configurable> cl) {
            this.c = cl;
        }

        @Override
        public String get() {
            switch (this) {
                case JSON: {
                    return ".json";
                }
                case YAML: {
                    return ".yml";
                }
            }
            throw new IllegalArgumentException("Unknown file extension!");
        }

        @Override
        public Class<? extends Configurable> getImplementation() {
            return this.c;
        }
    }

    public static abstract class Handle {
        @NotNull
        public String getName() {
            return this.getClass().getSimpleName();
        }
    }
}

