/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.event;

import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherCollectors;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.container.PantherSet;
import com.github.sanctum.panther.event.Vent;
import com.github.sanctum.panther.recursive.Service;
import com.github.sanctum.panther.recursive.ServiceFactory;
import com.github.sanctum.panther.recursive.ServiceLoader;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VentMap
implements Service {
    public abstract void subscribe(@NotNull Vent.Host var1, @NotNull Object var2);

    public abstract void subscribe(@NotNull Vent.Subscription<?> var1);

    public abstract void subscribe(@NotNull Vent.Subscription.Extender<?> var1);

    public abstract void subscribeAll(@NotNull Vent.Subscription<?> var1, Vent.Subscription<?> ... var2);

    public abstract void subscribeAll(@NotNull Vent.Host var1, Object ... var2);

    public abstract void unsubscribe(@NotNull Object var1);

    public abstract void unsubscribe(@NotNull Vent.Subscription<?> var1);

    public abstract void unsubscribe(@NotNull Vent.Subscription.Extender<?> var1);

    public abstract void unsubscribe(@NotNull Vent.Host var1, @NotNull String var2);

    public abstract void unsubscribe(@NotNull Vent.Host var1, @Nullable String var2, Object var3);

    public abstract <T extends Vent> void unsubscribe(@NotNull Class<T> var1, @NotNull String var2);

    public abstract void unsubscribeAll(@NotNull String var1);

    public abstract void unsubscribeAll(@NotNull Predicate<Vent.Subscription<?>> var1);

    public abstract void unsubscribeAll(@NotNull Vent.Host var1);

    public abstract <T extends Vent> void unsubscribeAll(@NotNull Class<T> var1, @NotNull String var2);

    public abstract PantherCollection<Vent.Link> getLinks();

    public abstract PantherCollection<Vent.Link> getLinks(@NotNull Vent.Host var1);

    public abstract PantherCollection<Vent.Subscription<?>> getSubscriptions();

    public abstract PantherCollection<Vent.Subscription<?>> getSubscriptions(@NotNull Vent.Host var1);

    public abstract <T extends Vent> Stream<Vent.Subscription<T>> getSubscriptions(@NotNull Class<T> var1, @NotNull Vent.Priority var2);

    public abstract Vent.Link getLink(@NotNull String var1);

    public abstract <T extends Vent> Vent.Subscription<T> getSubscription(@NotNull Class<T> var1, @NotNull String var2);

    public abstract Stream<Vent.Subscription.Extender<?>> getExtenders(@NotNull String var1);

    @NotNull
    public static VentMap getInstance() {
        VentMap instance = ServiceFactory.getInstance().getService(VentMap.class);
        if (instance == null) {
            ServiceLoader loader = ServiceFactory.getInstance().newLoader(VentMap.class).supply(new Default());
            return (VentMap)loader.load();
        }
        return instance;
    }

    public static final class Default
    extends VentMap {
        final PantherMap<Vent.Host, PantherMap<String, PantherSet<Vent.Link>>> listeners = new PantherEntryMap<Vent.Host, PantherMap<String, PantherSet<Vent.Link>>>();
        final PantherMap<Vent.Host, PantherMap<Class<? extends Vent>, PantherMap<Vent.Priority, PantherSet<Vent.Subscription<?>>>>> subscriptions = new PantherEntryMap();
        final PantherMap<String, PantherSet<Vent.Subscription.Extender<?>>> extenders = new PantherEntryMap();
        final Service.Obligation obligation = () -> "To provide a local cache for custom event handling.";

        @Override
        @NotNull
        public Service.Obligation getObligation() {
            return this.obligation;
        }

        @Override
        public void subscribe(@NotNull Vent.Host host, @NotNull Object listener) {
            Vent.Link link = new Vent.Link(host, listener){};
            if (listener instanceof Vent.Link) {
                link = (Vent.Link)listener;
            }
            this.listeners.computeIfAbsent(host, h -> new PantherEntryMap()).computeIfAbsent(link.getKey(), s -> new PantherSet()).add(link);
        }

        @Override
        public void subscribe(@NotNull Vent.Subscription<?> subscription) {
            this.subscriptions.computeIfAbsent(subscription.getHost(), p -> new PantherEntryMap()).computeIfAbsent(subscription.getEventType(), t -> new PantherEntryMap()).computeIfAbsent(subscription.getPriority(), p -> new PantherSet()).add(subscription);
        }

        @Override
        public void subscribe(@NotNull Vent.Subscription.Extender<?> extender) {
            this.extenders.computeIfAbsent(extender.getKey(), s -> new PantherSet()).add(extender);
        }

        @Override
        public void subscribeAll(@NotNull Vent.Subscription<?> subscription, Vent.Subscription<?> ... subscriptions) {
            this.subscribe(subscription);
            for (Vent.Subscription<?> sub : subscriptions) {
                this.subscribe(sub);
            }
        }

        @Override
        public void subscribeAll(@NotNull Vent.Host host, Object ... listeners) {
            for (Object o : listeners) {
                this.subscribe(host, o);
            }
        }

        @Override
        public void unsubscribe(@NotNull Object listener) {
            Optional<Vent.Link> optional;
            if (listener instanceof Vent.Link) {
                this.listeners.get(((Vent.Link)listener).getHost()).get(((Vent.Link)listener).getKey()).remove((Vent.Link)listener);
            }
            if ((optional = this.getLinks().stream().filter(l -> l.getParent().equals(listener)).findFirst()).isPresent()) {
                Vent.Link link = optional.get();
                this.listeners.get(link.getHost()).get(link.getKey()).remove(link);
            }
        }

        @Override
        public void unsubscribe(@NotNull Vent.Subscription<?> subscription) {
            Optional.ofNullable(this.subscriptions.get(subscription.getHost())).map(m -> (PantherMap)m.get(subscription.getEventType())).map(m -> (PantherSet)m.get(subscription.getPriority())).ifPresent(s -> s.remove(subscription));
        }

        @Override
        public void unsubscribe(@NotNull Vent.Subscription.Extender<?> extender) {
            Optional.ofNullable(this.extenders.get(extender.getKey())).ifPresent(s -> s.remove(extender));
        }

        @Override
        public void unsubscribe(@NotNull Vent.Host host, @NotNull String key) {
            Optional.ofNullable(this.listeners.get(host)).map(m -> (PantherSet)m.get(key)).ifPresent(s -> s.removeIf(l -> key.equals(l.getKey())));
        }

        @Override
        public void unsubscribe(@NotNull Vent.Host host, @Nullable String key, Object listener) {
            Optional.ofNullable(this.listeners.get(host)).map(m -> (PantherSet)m.get(key)).ifPresent(s -> s.removeIf(l -> listener.equals(l.getParent())));
        }

        @Override
        public <T extends Vent> void unsubscribe(@NotNull Class<T> eventType, @NotNull String key) {
            Optional<Vent.Subscription> subscription = this.subscriptions.values().stream().flatMap(m -> Optional.ofNullable(m.get(eventType)).map(PantherMap::values).map(PantherCollection::stream).map(s -> s.flatMap(PantherCollection::stream)).orElse(Stream.empty())).filter(s -> s.getKey().map(key::equals).orElse(false)).findFirst();
            subscription.ifPresent(sub -> this.subscriptions.get(sub.getHost()).get(eventType).get(sub.getPriority()).remove((Vent.Subscription<?>)sub));
        }

        @Override
        public void unsubscribeAll(@NotNull String key) {
        }

        @Override
        public void unsubscribeAll(@NotNull Predicate<Vent.Subscription<?>> fun) {
        }

        @Override
        public void unsubscribeAll(@NotNull Vent.Host host) {
        }

        @Override
        public <T extends Vent> void unsubscribeAll(@NotNull Class<T> eventType, @NotNull String key) {
            this.subscriptions.values().forEach(m -> Optional.ofNullable(m.get(eventType)).map(PantherMap::values).map(PantherCollection::stream).ifPresent(s -> s.forEachOrdered(set -> set.removeIf(sub -> sub.getKey().map(key::equals).orElse(false)))));
        }

        @Override
        public PantherCollection<Vent.Link> getLinks() {
            return this.listeners.values().stream().map(PantherMap::values).flatMap(PantherCollection::stream).flatMap(PantherCollection::stream).collect(PantherCollectors.toList());
        }

        @Override
        public PantherCollection<Vent.Link> getLinks(@NotNull Vent.Host host) {
            return this.listeners.get(host).values().stream().flatMap(PantherCollection::stream).collect(PantherCollectors.toList());
        }

        @Override
        public PantherCollection<Vent.Subscription<?>> getSubscriptions() {
            return this.subscriptions.values().stream().flatMap(m -> m.values().stream()).flatMap(m -> m.values().stream()).flatMap(PantherCollection::stream).collect(PantherCollectors.toList());
        }

        @Override
        public PantherCollection<Vent.Subscription<?>> getSubscriptions(@NotNull Vent.Host host) {
            return Optional.ofNullable(this.subscriptions.get(host)).map(PantherMap::values).map(PantherCollection::stream).map(s -> s.flatMap(m -> m.values().stream())).map(s -> s.flatMap(PantherCollection::stream)).map(s -> s.collect(PantherCollectors.toList())).orElse(new PantherList());
        }

        @Override
        public <T extends Vent> Stream<Vent.Subscription<T>> getSubscriptions(@NotNull Class<T> tClass, @NotNull Vent.Priority priority) {
            return this.subscriptions.values().stream().map(m -> Optional.ofNullable(m.get(tClass)).map(v -> (PantherSet)v.get(priority)).orElse(new PantherSet())).flatMap(PantherCollection::stream).map(s -> s);
        }

        @Override
        public Vent.Link getLink(@NotNull String key) {
            return this.getLinks().stream().filter(l -> l.getKey().equals(key)).findAny().orElse(null);
        }

        @Override
        public <T extends Vent> Vent.Subscription<T> getSubscription(@NotNull Class<T> eventType, @NotNull String key) {
            return this.subscriptions.values().stream().flatMap(m -> Optional.ofNullable(m.get(eventType)).map(PantherMap::values).map(PantherCollection::stream).orElse(Stream.empty())).flatMap(PantherCollection::stream).filter(s -> s.getKey().map(key::equals).orElse(false)).findAny().orElse(null);
        }

        @Override
        public Stream<Vent.Subscription.Extender<?>> getExtenders(@NotNull String key) {
            return this.extenders.computeIfAbsent(key, s -> new PantherSet()).stream();
        }
    }
}

