/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.event;

import com.github.sanctum.panther.annotation.AnnotationDiscovery;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.event.Extend;
import com.github.sanctum.panther.event.Subscribe;
import com.github.sanctum.panther.event.SubscriptionRuntimeException;
import com.github.sanctum.panther.event.VentMap;
import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.util.PantherLogger;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Vent {
    private final Host host;
    private final boolean async;
    private final State state;
    private boolean cancelled;

    protected Vent(@NotNull Host host, boolean isAsync) {
        this.state = State.CANCELLABLE;
        this.host = host;
        this.async = isAsync;
    }

    protected Vent(@NotNull Host host, @NotNull State state, boolean isAsync) {
        this.state = state;
        this.host = host;
        this.async = isAsync;
    }

    public State getState() {
        return this.state;
    }

    public final Host getHost() {
        return this.host;
    }

    public final Runtime getRuntime() {
        return this.async ? Runtime.Asynchronous : Runtime.Synchronous;
    }

    public void setCancelled(boolean cancelled) {
        if (this.state == State.IMMUTABLE) {
            throw new IllegalStateException("Cannot cancel immutable events.");
        }
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public final boolean isAsynchronous() {
        return this.async;
    }

    public static interface Host
    extends Configurable.Host {
        default public void subscribe(@NotNull Object listener) {
            VentMap.getInstance().subscribe(this, listener);
        }

        default public void subscribe(@NotNull Subscription<?> subscription) {
            ((Subscription)subscription).host = this;
            VentMap.getInstance().subscribe(subscription);
        }

        default public void subscribeAll(Object ... listeners) {
            for (Object o : listeners) {
                this.subscribe(o);
            }
        }

        default public void unsubscribe(@NotNull Object listener) {
            VentMap.getInstance().unsubscribe(listener);
        }

        default public void unsubscribe(@NotNull Subscription<?> subscription) {
            VentMap.getInstance().unsubscribe(subscription);
        }

        default public void unsubscribeAll(Object ... listeners) {
            for (Object o : listeners) {
                VentMap.getInstance().unsubscribe(o);
            }
        }

        default public void unsubscribeAll(@NotNull Subscription<?> subscription, Subscription<?> ... subscriptions) {
            this.unsubscribe(subscription);
            for (Subscription<?> sub : subscriptions) {
                this.unsubscribe(sub);
            }
        }

        @Nullable
        default public Link getVentLink(@NotNull String key) {
            return this.getVentLinks().stream().filter(l -> key.equals(l.getKey())).findFirst().orElse(null);
        }

        @NotNull
        default public PantherCollection<Link> getVentLinks() {
            return VentMap.getInstance().getLinks(this);
        }

        @Nullable
        default public <T extends Vent> Subscription<T> getVentSubscription(@NotNull Class<T> clazz, @NotNull String key) {
            return VentMap.getInstance().getSubscription(clazz, key);
        }

        @NotNull
        default public PantherCollection<Subscription<?>> getVentSubscriptions() {
            return VentMap.getInstance().getSubscriptions(this);
        }
    }

    public static abstract class Link {
        protected final Map<Class<? extends Vent>, Map<Priority, Set<Consumer<?>>>> eventMap = new HashMap();
        protected final List<Subscription.Extender<?>> extenders = new LinkedList();
        protected final Object listener;
        protected final Host host;
        protected final String key;

        public Link(Host host, Object listener) {
            this.listener = listener;
            this.host = host;
            this.key = this.readKey();
            this.buildEventHandlers();
            this.buildExtensions();
        }

        private String readKey() {
            String result = AnnotationDiscovery.of(Key.class, this.getParent()).mapFromClass((r, u) -> r.value());
            return Objects.toString(result);
        }

        private void buildEventHandlers() {
            AnnotationDiscovery<Subscribe, Object> discovery = AnnotationDiscovery.of(Subscribe.class, this.listener);
            AnnotationDiscovery<Disabled, Object> disabled = AnnotationDiscovery.of(Disabled.class, this.listener);
            discovery.filter(m -> m.getParameters().length == 1 && Vent.class.isAssignableFrom(m.getParameters()[0].getType()) && m.isAnnotationPresent(Subscribe.class) && Modifier.isPublic(m.getModifiers())).forEach(m -> {
                Optional subscribe = discovery.read((Method)m).stream().findAny();
                Optional disable = disabled.read((Method)m).stream().findAny();
                Class<?> mClass = m.getParameters()[0].getType();
                if (subscribe.isPresent()) {
                    if (!disable.isPresent()) {
                        this.registerSubscription((Method)m, mClass, (Subscribe)subscribe.get());
                    }
                } else {
                    PantherLogger.getInstance().getLogger().severe("Error registering " + m.getDeclaringClass() + "#" + m.getName());
                }
            });
        }

        private void buildExtensions() {
            AnnotationDiscovery<Extend, Object> discovery = AnnotationDiscovery.of(Extend.class, this.listener);
            discovery.filter(m -> m.getParameters().length == 1 && m.isAnnotationPresent(Extend.class) && Modifier.isPublic(m.getModifiers())).forEach(m -> {
                Optional extend = discovery.read((Method)m).stream().findAny();
                if (extend.isPresent()) {
                    Class<?> parameterClass = m.getParameters()[0].getType();
                    this.registerExtender((Method)m, parameterClass, (Extend)extend.get());
                } else {
                    PantherLogger.getInstance().getLogger().severe("Error registering " + m.getDeclaringClass() + "#" + m.getName());
                }
            });
        }

        private <T> void registerExtender(Method m, Class<T> parameterClass, Extend extend) {
            String key = extend.identifier();
            Subscription.Extender<Object> extender = m.getReturnType().equals(Void.TYPE) || extend.resultProcessors().length == 0 ? new Subscription.Extender<Object>(parameterClass, t -> this.invokeAsExtender(m, Object.class, t), key, this) : new Subscription.Extender<Object>(parameterClass, Link.buildExtender(t -> this.invokeAsExtender(m, m.getReturnType(), t), extend.resultProcessors()), key, this);
            this.extenders.add(extender);
            VentMap.getInstance().subscribe(extender);
        }

        private <T extends Vent> void registerSubscription(Method method, Class<T> tClass, Subscribe subscribe) {
            Consumer<Vent> call;
            boolean useCancelled = subscribe.processCancelled();
            if (method.getReturnType().equals(Void.TYPE) || subscribe.resultProcessors().length == 0) {
                call = new Consumer<Vent>(t -> this.invokeAsListener(method, tClass.getName(), Object.class, t), useCancelled);
            } else {
                Class<?> resultClass = method.getReturnType();
                call = new Consumer<Vent>(Link.buildExtender(t -> this.invokeAsListener(method, tClass.getName(), resultClass, t), subscribe.resultProcessors()), useCancelled);
            }
            this.eventMap.computeIfAbsent(tClass, c -> new HashMap()).computeIfAbsent(subscribe.priority(), p -> new HashSet()).add(call);
        }

        private <T> CallInfo<T> invokeAsListener(Method method, String eventName, Class<T> resultClass, Object ... params) {
            String reflectionError = "Internal error hindered " + this.listener.getClass().getName() + "#" + method.getName() + " from executing. Check method accessibility, parameters & usage!";
            String callError = "Could not pass event " + eventName + " to " + this.host;
            return this.invoke(method, reflectionError, callError, resultClass, params);
        }

        private <T> CallInfo<T> invokeAsExtender(Method method, Class<T> resultClass, Object ... params) {
            String passed = "passed elements " + Arrays.toString(params);
            String reflectionError = "Internal error hindered " + this.listener.getClass().getName() + "#" + method.getName() + " from further processing " + passed + ". Check method accessibility, parameters & usage!";
            String callError = "Could not process" + passed + " at " + this.host;
            return this.invoke(method, reflectionError, callError, resultClass, params);
        }

        private <T> CallInfo<T> invoke(Method method, String refError, String callError, Class<T> retC, Object ... params) {
            try {
                method.setAccessible(true);
                return new CallInfo<T>(true, retC.cast(method.invoke(this.listener, params)));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                PantherLogger.getInstance().getLogger().severe(refError);
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                } else {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                PantherLogger.getInstance().getLogger().severe(callError);
                e.printStackTrace();
            }
            return new CallInfo<Object>(false, null);
        }

        public <T extends Vent> Stream<? extends Consumer<T>> getHandlers(Class<T> eventClass, Priority priority) {
            return Optional.ofNullable(this.eventMap.get(eventClass)).map(m -> (Set)m.get((Object)priority)).map(Collection::stream).map(s -> s.map(c -> c)).orElse(Stream.empty());
        }

        public <T extends Vent> Stream<? extends Consumer<T>> getDisabledHandlers(Class<T> eventClass, Priority priority) {
            AnnotationDiscovery<Disabled, Object> discovery = AnnotationDiscovery.of(Disabled.class, this.getParent());
            discovery.filter(m -> m.getParameterTypes().length > 0 && eventClass.isAssignableFrom(m.getParameterTypes()[0]), true);
            PantherList collection = new PantherList();
            discovery.forEach(method -> {
                Subscribe s = method.getAnnotation(Subscribe.class);
                if (s.priority() == priority) {
                    collection.add(new Consumer<Vent>(t -> {
                        try {
                            method.invoke(this.getParent(), t);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }, false));
                }
            });
            return collection.stream();
        }

        public Host getHost() {
            return this.host;
        }

        @Nullable
        public String getKey() {
            return this.key;
        }

        public Object getParent() {
            return this.listener;
        }

        public void remove() {
            VentMap map = VentMap.getInstance();
            map.unsubscribe(this);
            this.extenders.forEach(map::unsubscribe);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link that = (Link)o;
            return this.listener.equals(that.listener) && this.host.equals(that.host) && this.key.equals(that.key) && this.eventMap.equals(that.eventMap);
        }

        public int hashCode() {
            return Objects.hash(this.listener, this.host, this.key);
        }

        public String toString() {
            return "Vent.Link{listener=" + this.listener + ", host=" + this.host + ", key='" + this.key + '\'' + ", eventMap=" + this.eventMap + '}';
        }

        private static <T, S> java.util.function.Consumer<T> buildExtender(Function<T, CallInfo<S>> base, String[] targets) {
            return t -> {
                CallInfo callInfo = (CallInfo)base.apply(t);
                if (callInfo.success) {
                    for (String target : targets) {
                        Subscription.Extender.runExtensions(target, callInfo.result);
                    }
                }
            };
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface Key {
            @NotNull
            public String value();
        }

        static final class CallInfo<T> {
            private final boolean success;
            private final T result;

            CallInfo(boolean success, T result) {
                this.success = success;
                this.result = result;
            }
        }

        public static class Consumer<T extends Vent>
        implements Subscribe.Consumer<T> {
            private final java.util.function.Consumer<T> eventHandler;
            private final boolean handleCancelled;

            public Consumer(java.util.function.Consumer<T> eventHandler, boolean handleCancelled) {
                this.eventHandler = eventHandler;
                this.handleCancelled = handleCancelled;
            }

            @Override
            public void accept(T event, Subscription<T> unused) {
                this.eventHandler.accept(event);
            }

            public boolean handlesCancelled() {
                return this.handleCancelled;
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Disabled {
        public String until() default "N/A";
    }

    public static abstract class Call<T extends Vent> {
        protected final T event;
        protected T readOnlyEventCopy;
        protected final Runtime type;

        public Call(@NotNull T event) {
            this.event = event;
            this.readOnlyEventCopy = event;
            this.type = ((Vent)event).getRuntime();
        }

        public final T run() {
            this.notifySubscribersAndListeners();
            return this.event;
        }

        private void notifySubscribersAndListeners() {
            VentMap map = VentMap.getInstance();
            PantherCollection<Link> listeners = map.getLinks();
            List<Class<Vent>> assignableClasses = this.generateAssignableClasses(this.event.getClass());
            Priority.getWriteAccessing().forEach(p -> assignableClasses.forEach(c -> {
                map.getSubscriptions(c, (Priority)((Object)p)).map(s -> s).forEachOrdered(subscription -> this.runSubscription((Subscription<? super T>)subscription, this.event));
                listeners.forEach(l -> this.notifyListeners((Link)l, (Class)c, (Priority)((Object)p)));
            }));
            assignableClasses.forEach(c -> {
                map.getSubscriptions(c, Priority.READ_ONLY).map(s -> s).forEachOrdered(s -> this.runSubscriptionReadOnly((Subscription<? super T>)s, this.readOnlyEventCopy));
                listeners.forEach(listener -> this.runReadOnly((Link)listener, (Class)c));
            });
        }

        private <E extends Vent> void notifyListeners(Link listener, Class<E> eventSuperClass, Priority priority) {
            Vent vent = (Vent)eventSuperClass.cast(this.event);
            listener.getHandlers(eventSuperClass, priority).forEachOrdered(e -> {
                if (vent.getState() == State.CANCELLABLE && !e.handlesCancelled()) {
                    if (!vent.isCancelled()) {
                        e.accept(vent, null);
                        this.readOnlyEventCopy = this.event;
                    }
                } else {
                    e.accept(vent, null);
                    this.readOnlyEventCopy = this.event;
                }
            });
        }

        private <E extends Vent> void runReadOnly(Link listener, Class<E> eventSuperClass) {
            listener.getHandlers(eventSuperClass, Priority.READ_ONLY).forEachOrdered(e -> {
                boolean cancelled = ((Vent)this.readOnlyEventCopy).isCancelled();
                if (!cancelled || e.handlesCancelled()) {
                    e.accept((Vent)eventSuperClass.cast(this.readOnlyEventCopy), null);
                    if (((Vent)this.readOnlyEventCopy).isCancelled()) {
                        ((Vent)this.readOnlyEventCopy).setCancelled(cancelled);
                    }
                }
            });
        }

        private void runSubscription(Subscription<? super T> subscription, T event) {
            if (!(((Vent)event).getState() == State.CANCELLABLE && ((Vent)event).isCancelled() || ((Vent)event).isCancelled())) {
                this.runSub((Subscription)subscription, (Vent)event);
            }
        }

        private void runSubscriptionReadOnly(Subscription<? super T> subscription, T event) {
            if (!((Vent)event).isCancelled()) {
                this.runSub((Subscription)subscription, (Vent)event);
                if (((Vent)event).isCancelled()) {
                    ((Vent)event).setCancelled(false);
                }
            }
        }

        private <S extends Vent> void runSub(Subscription<S> subscription, S event) {
            subscription.getAction().accept(event, subscription);
        }

        private List<Class<? extends Vent>> generateAssignableClasses(Class<? extends Vent> ventClass) {
            ArrayList<Class<? extends Vent>> callingClasses = new ArrayList<Class<? extends Vent>>();
            Class<?> temp = this.event.getClass();
            do {
                callingClasses.add(temp);
            } while (Vent.class.isAssignableFrom(temp = temp.getSuperclass()));
            return callingClasses;
        }
    }

    public static class Subscription<T extends Vent> {
        final VentMap mapInstance = VentMap.getInstance();
        private final Class<T> eventType;
        private final Subscribe.Consumer<T> action;
        private final Priority priority;
        private Host host;
        private String key;
        protected boolean p;

        public Subscription(Class<T> eventType, Host user, Priority priority, Subscribe.Consumer<T> action) {
            this.eventType = eventType;
            this.host = user;
            this.priority = priority;
            this.action = action;
        }

        public Subscription(Class<T> eventType, String key, Host user, Priority priority, Subscribe.Consumer<T> action) {
            this.eventType = eventType;
            this.key = key;
            this.host = user;
            this.priority = priority;
            this.action = action;
        }

        public Subscription(Class<T> eventType, Priority priority, Subscribe.Consumer<T> action) {
            this.eventType = eventType;
            this.priority = priority;
            this.action = action;
        }

        public Subscription(Class<T> eventType, String key, Priority priority, Subscribe.Consumer<T> action) {
            this.eventType = eventType;
            this.key = key;
            this.priority = priority;
            this.action = action;
        }

        public void remove() {
            this.mapInstance.unsubscribe(this);
        }

        public boolean isParent() {
            return this.p;
        }

        public Optional<String> getKey() {
            return Optional.ofNullable(this.key);
        }

        public Host getHost() {
            return this.host;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public Subscribe.Consumer<T> getAction() {
            return this.action;
        }

        public Class<T> getEventType() {
            return this.eventType;
        }

        public static class Extender<T> {
            private final Class<T> type;
            private final Consumer<T> consumer;
            private final String key;
            private final Link link;

            public Extender(@NotNull Class<T> returnType, @NotNull Consumer<T> consumer, @NotNull String key, @NotNull Link parent) {
                this.type = returnType;
                this.consumer = consumer;
                this.key = key;
                this.link = parent;
            }

            public static void runExtensions(@NotNull String key, @NotNull Object toProcess) {
                VentMap.getInstance().getExtenders(key).filter(e -> e.getType().isAssignableFrom(toProcess.getClass())).forEach(e -> Extender.runFinisher(e, toProcess));
            }

            private static <E> void runFinisher(Extender<E> ventExtender, Object toProcess) {
                ventExtender.consumer.accept(ventExtender.getType().cast(toProcess));
            }

            @NotNull
            public final String getKey() {
                return this.key;
            }

            @NotNull
            public final Link getLink() {
                return this.link;
            }

            @NotNull
            public final Class<T> getType() {
                return this.type;
            }
        }

        public static final class Builder<T extends Vent> {
            final VentMap mapInstance = VentMap.getInstance();
            private final Class<T> tClass;
            private Subscription<T> subscription;
            private Subscribe.Consumer<T> subscriberCall;
            private String key;
            private Host host;
            private Priority priority;

            private Builder(Class<T> tClass) {
                this.tClass = tClass;
            }

            public static <T extends Vent> Builder<T> of(Class<T> event) {
                return new Builder<T>(event);
            }

            public Builder<T> next(String key) {
                this.key = key;
                return this;
            }

            public Builder<T> next(Host host) {
                this.host = host;
                return this;
            }

            public Builder<T> next(Priority priority) {
                this.priority = priority;
                return this;
            }

            public Builder<T> next(Subscribe.Consumer<T> call) {
                this.subscriberCall = call;
                return this;
            }

            public Subscription<T> build() throws IllegalStateException {
                boolean register;
                boolean bl = register = this.subscription == null;
                if (register) {
                    this.validate();
                    this.subscription = this.key != null ? new Subscription<T>(this.tClass, this.key, this.host, this.priority, this.subscriberCall) : new Subscription<T>(this.tClass, this.host, this.priority, this.subscriberCall);
                    this.mapInstance.subscribe(this.subscription);
                }
                return this.subscription;
            }

            private void validate() throws IllegalStateException {
                if (Stream.of(new Object[]{this.host, this.priority}).anyMatch(Objects::isNull)) {
                    throw new IllegalStateException("There are still unassigned builds needed to build a Subscription!");
                }
            }
        }
    }

    public static enum Priority {
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        HIGHEST(4),
        READ_ONLY(5);

        private static final List<Priority> writeAccessing;
        private final int level;

        private Priority(int level) {
            this.level = level;
        }

        public static List<Priority> getWriteAccessing() {
            return writeAccessing;
        }

        public int getLevel() {
            return this.level;
        }

        static {
            writeAccessing = Collections.unmodifiableList(Stream.of(LOW, MEDIUM, HIGH, HIGHEST).collect(Collectors.toList()));
        }
    }

    public static enum Runtime {
        Synchronous,
        Asynchronous;


        public void validate(Vent vent) throws SubscriptionRuntimeException {
            if (vent.getRuntime() != this) {
                throw new SubscriptionRuntimeException("Vent was tried to run " + (Object)((Object)this) + " but only can be run " + (Object)((Object)vent.getRuntime()));
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum State {
        CANCELLABLE,
        IMMUTABLE;

    }
}

