/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.container.PantherCollectionBase;
import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import java.util.Iterator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@Note(value="All queue modifications run on an in-daemon asynchronous task scheduler with an execution delay of 50 milliseconds.")
public final class PantherQueue<E>
extends PantherCollectionBase<E> {
    final TaskChain chain = TaskChain.getAsynchronous();
    boolean beingTraversed;

    public PantherQueue() {
    }

    public PantherQueue(int capacity) {
        super(capacity);
    }

    public PantherQueue(Iterable<E> iterable) {
        super(iterable);
    }

    public PantherQueue(Iterable<E> iterable, int capacity) {
        super(iterable, capacity);
    }

    public E get(Predicate<? super E> matcher) {
        return this.stream().filter(matcher).findFirst().orElse(null);
    }

    public E getFirst() {
        if (this.head == null) {
            return null;
        }
        return this.head.data;
    }

    public E getLast() {
        if (this.tail == null) {
            return null;
        }
        return this.tail.data;
    }

    public E pollNow() {
        String key;
        final E element = this.getFirst();
        if (element != null && this.chain.get(key = "Collection-Task;" + this.hashCode() + ":poll:" + element.hashCode()) == null) {
            Task task = new Task(key, 1, this.chain){

                @Ordinal
                public void onExecute() {
                    if (!PantherQueue.this.isBlocked()) {
                        PantherQueue.super.remove(element);
                    }
                }
            };
            this.chain.repeat(task, 0L, 50L);
        }
        return element;
    }

    public E poll() {
        E element = this.getFirst();
        if (element != null) {
            boolean blocked = true;
            do {
                if (this.isBlocked()) continue;
                this.remove(element);
                blocked = false;
            } while (blocked);
        }
        return element;
    }

    @Override
    public boolean add(final E e) {
        String key = "Collection-Task;" + this.hashCode() + ":add:" + e.hashCode();
        if (this.isBlocked()) {
            if (this.chain.get(key) == null) {
                Task task = new Task(key, 1, this.chain){

                    @Ordinal
                    public void onExecute() {
                        if (!PantherQueue.this.isBlocked()) {
                            PantherQueue.super.add(e);
                        }
                    }
                };
                this.chain.repeat(task, 0L, 50L);
            }
            return false;
        }
        return super.add(e);
    }

    @Override
    public boolean remove(final E e) {
        String key = "Collection-Task;" + this.hashCode() + ":remove:" + e.hashCode();
        if (this.isBlocked()) {
            if (this.chain.get(key) == null) {
                Task task = new Task(key, 1, this.chain){

                    @Ordinal
                    public void onExecute() {
                        if (!PantherQueue.this.isBlocked()) {
                            PantherQueue.super.remove(e);
                        }
                    }
                };
                this.chain.repeat(task, 0L, 50L);
            }
            return false;
        }
        return super.remove(e);
    }

    public boolean isBlocked() {
        return this.beingTraversed;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private PantherCollectionBase.Node initial;
            {
                this.initial = PantherQueue.this.head;
            }

            @Override
            public boolean hasNext() {
                PantherQueue.this.beingTraversed = true;
                return this.initial != null;
            }

            @Override
            public E next() {
                Object data = this.initial.data;
                this.initial = this.initial.next;
                PantherQueue.this.beingTraversed = false;
                return data;
            }
        };
    }
}

