/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import com.github.sanctum.panther.container.ImmutableStorageException;
import com.github.sanctum.panther.container.PantherEntry;
import com.github.sanctum.panther.container.PantherMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jetbrains.annotations.NotNull;

public abstract class PantherMapBase<K, V>
implements PantherMap<K, V> {
    protected Node head;
    protected Node tail;
    protected int size;
    protected int capacity;
    protected final boolean capacityEnforced;

    public PantherMapBase() {
        this.capacity = 10;
        this.capacityEnforced = false;
    }

    public PantherMapBase(int capacity) {
        this.capacity = capacity;
        this.capacityEnforced = true;
    }

    public PantherMapBase(Iterable<Map.Entry<K, V>> iterable) {
        this();
        iterable.forEach(entry -> this.put(entry.getKey(), entry.getValue()));
    }

    public PantherMapBase(Iterable<Map.Entry<K, V>> iterable, int capacity) {
        this(capacity);
        iterable.forEach(entry -> this.put(entry.getKey(), entry.getValue()));
    }

    @Override
    public V put(K e, V value) {
        Node imprint = this.getNode(e);
        if (imprint != null) {
            if (value == null) {
                this.remove(imprint);
            } else {
                imprint.value.setValue(value);
            }
            return value;
        }
        if (this.capacityEnforced) {
            if (this.size() >= this.capacity) {
                return null;
            }
        } else if (this.size() >= this.capacity) {
            ++this.capacity;
        }
        Node new_node = new Node(e, value);
        if (this.head == null) {
            this.head = new_node;
        } else {
            Node last = this.head;
            while (last.next != null) {
                last = last.next;
            }
            last.next = new_node;
            this.tail = new_node;
        }
        ++this.size;
        return value;
    }

    @Override
    public boolean putAll(Iterable<Map.Entry<K, V>> iterable) {
        boolean result = true;
        for (Map.Entry<K, V> entry : iterable) {
            if (this.containsKey(entry.getKey())) {
                result = false;
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public boolean remove(K e) {
        Node current = this.head;
        while (current != null) {
            if (current.value.getKey() == e || current.value.getKey().equals(e)) {
                --this.size;
                return this.remove(current);
            }
            current = current.next;
        }
        return false;
    }

    @Override
    public boolean removeAll(Iterable<Map.Entry<K, V>> iterable) {
        boolean result = true;
        for (Map.Entry<K, V> entry : iterable) {
            if (!this.containsKey(entry.getKey())) {
                result = false;
                continue;
            }
            this.remove(entry.getKey());
        }
        return result;
    }

    @Override
    public V get(K key) {
        V result = null;
        Node current = this.head;
        while (current != null) {
            if (current.value.getKey() == key || current.value.getKey().equals(key)) {
                result = current.value.getValue();
                break;
            }
            current = current.next;
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(K e) {
        boolean found = false;
        Node current = this.head;
        while (current != null) {
            if (current.value.getKey() == e || current.value.getKey().equals(e)) {
                found = true;
                break;
            }
            current = current.next;
        }
        return found;
    }

    @Override
    public boolean containsValue(V v) {
        boolean found = false;
        Node current = this.head;
        while (current != null) {
            if (current.value.getValue() == v || current.value.getValue().equals(v)) {
                found = true;
                break;
            }
            current = current.next;
        }
        return found;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public Spliterator<PantherEntry.Modifiable<K, V>> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    @Override
    @NotNull
    public Iterator<PantherEntry.Modifiable<K, V>> iterator() {
        return new Iterator<PantherEntry.Modifiable<K, V>>(){
            private Node initial;
            {
                this.initial = PantherMapBase.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.initial != null;
            }

            @Override
            public PantherEntry.Modifiable<K, V> next() {
                PantherEntry.Modifiable data = this.initial.value;
                this.initial = this.initial.next;
                return data;
            }
        };
    }

    public String toString() {
        StringBuilder list = new StringBuilder();
        int count = 0;
        for (PantherEntry.Modifiable<K, V> e : this) {
            if (count == this.size - 1) {
                list.append(e.toString());
            } else {
                list.append(e.toString()).append(", ");
            }
            ++count;
        }
        return "[" + list + "]";
    }

    Node getNode(K key) {
        Node result = null;
        Node current = this.head;
        while (current != null) {
            if (current.value.getKey() == key || current.value.getKey().equals(key)) {
                result = current;
                break;
            }
            current = current.next;
        }
        return result;
    }

    boolean removeFirst() {
        if (this.head == null) {
            return false;
        }
        if (this.head == this.tail) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = this.head.next;
        }
        return true;
    }

    boolean removeLast() {
        if (this.tail == null) {
            return false;
        }
        if (this.head == this.tail) {
            this.head = null;
            this.tail = null;
        } else {
            Node previousToTail = this.head;
            while (previousToTail.next != this.tail) {
                previousToTail = previousToTail.next;
            }
            this.tail = previousToTail;
            this.tail.next = null;
        }
        return true;
    }

    @Override
    boolean remove(Node node) {
        Node currentNode = this.head;
        Node prevNode = null;
        while (currentNode != null && !currentNode.equals(node)) {
            prevNode = currentNode;
            currentNode = currentNode.next;
        }
        if (currentNode == null) {
            return false;
        }
        if (prevNode == null) {
            return this.removeFirst();
        }
        if (prevNode.next.next == null) {
            return this.removeLast();
        }
        prevNode.next = prevNode.next.next;
        return true;
    }

    static class ImmutablePantherEntry<K, V>
    implements PantherEntry.Modifiable<K, V> {
        private final K k;
        private final V v;

        ImmutablePantherEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public V setValue(V value) {
            throw new ImmutableStorageException("Element modifications cannot be made to immutable entries!");
        }

        @Override
        @NotNull
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        public String toString() {
            return "Entry{key=" + this.k + ", value=" + this.v + "}";
        }
    }

    protected class Node {
        protected PantherEntry.Modifiable<K, V> value;
        protected Node next;

        Node(Node node) {
            this.value = node.value;
            this.next = node.next.copy();
        }

        Node(K k, V v) {
            this.value = PantherEntry.Modifiable.of(k, v);
            this.next = null;
        }

        Node(ImmutablePantherEntry<K, V> value) {
            this.value = value;
            this.next = null;
        }

        Node copy() {
            return new Node(this);
        }
    }
}

